/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.routing.slot;

import com.tridiumx.jsonToolkit.inbound.BJsonInbound;
import com.tridiumx.jsonToolkit.inbound.routing.BJsonRouter;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

public interface DynamicSlotUtil {
    default public void resetDynamicProperties(BJsonInbound target) {
        for (Property p : target.getDynamicPropertiesArray()) {
            this.resetDynamicProperty(target, p);
        }
    }

    default public void resetDynamicProperty(BJsonInbound target, Property property) {
        target.set(property, JsonSchemaUtil.getPropertyResetValue(property));
    }

    default public void readOnlySummaryOnAdd(BJsonInbound target, Property property) {
        Type t = property.getType();
        if (property.isDynamic() && (BString.TYPE.is(t) || BBoolean.TYPE.is(t) || target.get(property) instanceof BNumber || t.is(BStatusValue.TYPE))) {
            int intendedFlags = BJsonRouter.DEFAULT_ROUTER_SLOT_FLAGS;
            int actualFlags = target.getFlags((Slot)property);
            if (actualFlags != intendedFlags) {
                target.setFlags((Slot)property, intendedFlags);
            }
        }
    }
}

