/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.alarm.property;

import com.tridiumx.jsonToolkit.outbound.schema.alarm.property.BIJsonAlarmDataResolver;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaProperty;
import com.tridiumx.jsonToolkit.util.format.BBFormatErrorSubstituteValue;
import com.tridiumx.jsonToolkit.util.format.FormatResolveUtil;
import java.math.BigDecimal;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="format", type="BFormat", defaultValue="BFormat.DEFAULT", flags=8, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="attemptTypeConversion", type="boolean", defaultValue="true"), @NiagaraProperty(name="ErrorSubstitute", type="BBFormatErrorSubstituteValue", defaultValue="BBFormatErrorSubstituteValue.DEFAULT")})
public class BBFormatString
extends BJsonSchemaProperty<Object>
implements BIJsonAlarmDataResolver {
    @Generated
    public static final Property format = BBFormatString.newProperty((int)8, (BValue)BFormat.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property attemptTypeConversion = BBFormatString.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property ErrorSubstitute = BBFormatString.newProperty((int)0, (BValue)BBFormatErrorSubstituteValue.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBFormatString.class);
    private Object result;

    @Generated
    public BFormat getFormat() {
        return (BFormat)this.get(format);
    }

    @Generated
    public void setFormat(BFormat v) {
        this.set(format, (BValue)v, null);
    }

    @Generated
    public boolean getAttemptTypeConversion() {
        return this.getBoolean(attemptTypeConversion);
    }

    @Generated
    public void setAttemptTypeConversion(boolean v) {
        this.setBoolean(attemptTypeConversion, v, null);
    }

    @Generated
    public BBFormatErrorSubstituteValue getErrorSubstitute() {
        return (BBFormatErrorSubstituteValue)this.get(ErrorSubstitute);
    }

    @Generated
    public void setErrorSubstitute(BBFormatErrorSubstituteValue v) {
        this.set(ErrorSubstitute, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Object getJsonValue() {
        return this.result;
    }

    @Override
    public void resolve(BAlarmRecord r) {
        String candidate = FormatResolveUtil.resolveFormat((BObject)r, this.getFormat(), this.getErrorSubstitute());
        if (log.isLoggable(Level.FINE)) {
            log.fine("[" + this.getSlotPath() + "] " + this.getFormat() + " = " + candidate);
        }
        if (this.getAttemptTypeConversion()) {
            switch (candidate) {
                case "true": {
                    this.result = Boolean.TRUE;
                    break;
                }
                case "false": {
                    this.result = Boolean.FALSE;
                    break;
                }
                default: {
                    try {
                        BigDecimal bd = new BigDecimal(candidate);
                        this.result = bd.doubleValue();
                        break;
                    }
                    catch (Exception e) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Failed to create Number from " + candidate + ", will use as String");
                        }
                        this.useStringValue(candidate);
                    }
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("[" + this.getSlotPath() + "] " + this.getFormat() + " Converted to = " + this.result);
            }
        }
        if (this.result == null) {
            this.useStringValue(candidate);
        }
    }

    private void useStringValue(Object candidate) {
        this.result = candidate;
    }
}

