/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.config.folder;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaConfigFolder;
import com.tridiumx.jsonToolkit.outbound.schema.program.BTypeOverride;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
public class BJsonSchemaOverrideFolder
extends BFolder {
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonSchemaOverrideFolder.class);
    public static final Logger ovLog = BJsonSchemaService.childLogger("typeOverride");
    private static final Object[] VALID_CHILD_NAME = new Object[]{BTypeOverride.TYPE.getTypeName()};

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BValue processOverrides(BValue value) {
        BTypeOverride[] to;
        for (BTypeOverride t : to = (BTypeOverride[])this.getChildren(BTypeOverride.class)) {
            if (ovLog.isLoggable(Level.FINEST)) {
                ovLog.finest("Passing " + t.getName() + " a " + value.getClass() + ' ' + value.toString());
            }
            try {
                BValue result = t.override(value);
                if (result != value) {
                    ovLog.fine(t.getName() + " replaced " + value + " with " + result);
                    value = result;
                    continue;
                }
                if (!ovLog.isLoggable(Level.FINEST)) continue;
                ovLog.finest("Value not replaced " + result);
            }
            catch (Exception e) {
                ovLog.log(Level.WARNING, ((BJsonSchemaConfigFolder)this.getParent()).getSchema().getName() + " attempting to use Type Override " + t.getName(), e);
            }
        }
        return value;
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is(this.getType(), parent.getType(), BJsonSchema.TYPE, BJsonSchemaConfigFolder.TYPE);
    }

    public boolean isChildLegal(BComponent child) {
        if (child instanceof BTypeOverride) {
            return true;
        }
        ovLog.warning("Found child " + child.getType());
        throw new IllegalChildException(TYPE.getModule().getModuleName(), "expectsChild", VALID_CHILD_NAME);
    }

    public BIcon getIcon() {
        BIcon base = super.getIcon();
        return BIcon.make((BIcon)base, (BIcon)BIcon.make((String)"module://icons/x16/badges/export.png"));
    }
}

