/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.postprocess;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaDebugFolder;
import com.tridiumx.jsonToolkit.outbound.schema.postprocess.BIPostProcessor;
import com.tridiumx.jsonToolkit.outbound.schema.relative.BRelativeJsonSchema;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="queryFolderExecutions", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="individualQueryExecutions", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="queryFails", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="lastQueryFailReason", type="String", defaultValue="BString.DEFAULT", flags=73729), @NiagaraProperty(name="lastQueryExecutionMillis", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="queryExecutionMillisTotal", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="queryExecutionMillisMax", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="queryExecutionMillisAvg", type="double", defaultValue="BDouble.DEFAULT", flags=73729, facets={@Facet(value="createPrecisionFacet(2)")}), @NiagaraProperty(name="requestSchemaGenerations", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="schemaGenerations", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="schemaGenerationFails", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="lastSchemaGenerationFailReason", type="String", defaultValue="BString.DEFAULT", flags=73729), @NiagaraProperty(name="outputChanges", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="lastOutputSize", type="long", defaultValue="BLong.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()")}), @NiagaraProperty(name="outputSizeTotal", type="long", defaultValue="BLong.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()")}), @NiagaraProperty(name="outputSizeMax", type="long", defaultValue="BLong.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()")}), @NiagaraProperty(name="outputSizeAvg", type="double", defaultValue="BDouble.DEFAULT", flags=73729, facets={@Facet(value="createByteUnitFacet()"), @Facet(value="createPrecisionFacet(2)")}), @NiagaraProperty(name="resolveErrors", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="baseItemQueueSize", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="subscribes", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="unsubscribes", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="subscriptionEvents", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="subscriptionEventsIgnored", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="cacheHits", type="long", defaultValue="BLong.DEFAULT", flags=73729), @NiagaraProperty(name="cacheMisses", type="long", defaultValue="BLong.DEFAULT", flags=73729)})
@NiagaraAction(name="reset")
public class BJsonSchemaMetrics
extends BComponent
implements BIPostProcessor {
    static final int METRIC_FLAGS = 73729;
    @Generated
    public static final Property queryFolderExecutions = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property individualQueryExecutions = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property queryFails = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property lastQueryFailReason = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property lastQueryExecutionMillis = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property queryExecutionMillisTotal = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property queryExecutionMillisMax = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property queryExecutionMillisAvg = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BDouble.DEFAULT, (BFacets)BJsonSchemaMetrics.createPrecisionFacet(2));
    @Generated
    public static final Property requestSchemaGenerations = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property schemaGenerations = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property schemaGenerationFails = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property lastSchemaGenerationFailReason = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property outputChanges = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property lastOutputSize = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, (BFacets)BJsonSchemaMetrics.createByteUnitFacet());
    @Generated
    public static final Property outputSizeTotal = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, (BFacets)BJsonSchemaMetrics.createByteUnitFacet());
    @Generated
    public static final Property outputSizeMax = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, (BFacets)BJsonSchemaMetrics.createByteUnitFacet());
    @Generated
    public static final Property outputSizeAvg = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BDouble.DEFAULT, (BFacets)BFacets.make((BFacets)BJsonSchemaMetrics.createByteUnitFacet(), (BFacets)BJsonSchemaMetrics.createPrecisionFacet(2)));
    @Generated
    public static final Property resolveErrors = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property baseItemQueueSize = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property subscribes = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property unsubscribes = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property subscriptionEvents = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property subscriptionEventsIgnored = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property cacheHits = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Property cacheMisses = BJsonSchemaMetrics.newProperty((int)73729, (BValue)BLong.DEFAULT, null);
    @Generated
    public static final Action reset = BJsonSchemaMetrics.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonSchemaMetrics.class);
    private final Object mutex = new Object();

    static BFacets createByteUnitFacet() {
        return BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"byte"));
    }

    static BFacets createPrecisionFacet(int precision) {
        return BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)precision));
    }

    @Generated
    public long getQueryFolderExecutions() {
        return this.getLong(queryFolderExecutions);
    }

    @Generated
    public void setQueryFolderExecutions(long v) {
        this.setLong(queryFolderExecutions, v, null);
    }

    @Generated
    public long getIndividualQueryExecutions() {
        return this.getLong(individualQueryExecutions);
    }

    @Generated
    public void setIndividualQueryExecutions(long v) {
        this.setLong(individualQueryExecutions, v, null);
    }

    @Generated
    public long getQueryFails() {
        return this.getLong(queryFails);
    }

    @Generated
    public void setQueryFails(long v) {
        this.setLong(queryFails, v, null);
    }

    @Generated
    public String getLastQueryFailReason() {
        return this.getString(lastQueryFailReason);
    }

    @Generated
    public void setLastQueryFailReason(String v) {
        this.setString(lastQueryFailReason, v, null);
    }

    @Generated
    public long getLastQueryExecutionMillis() {
        return this.getLong(lastQueryExecutionMillis);
    }

    @Generated
    public void setLastQueryExecutionMillis(long v) {
        this.setLong(lastQueryExecutionMillis, v, null);
    }

    @Generated
    public long getQueryExecutionMillisTotal() {
        return this.getLong(queryExecutionMillisTotal);
    }

    @Generated
    public void setQueryExecutionMillisTotal(long v) {
        this.setLong(queryExecutionMillisTotal, v, null);
    }

    @Generated
    public long getQueryExecutionMillisMax() {
        return this.getLong(queryExecutionMillisMax);
    }

    @Generated
    public void setQueryExecutionMillisMax(long v) {
        this.setLong(queryExecutionMillisMax, v, null);
    }

    @Generated
    public double getQueryExecutionMillisAvg() {
        return this.getDouble(queryExecutionMillisAvg);
    }

    @Generated
    public void setQueryExecutionMillisAvg(double v) {
        this.setDouble(queryExecutionMillisAvg, v, null);
    }

    @Generated
    public long getRequestSchemaGenerations() {
        return this.getLong(requestSchemaGenerations);
    }

    @Generated
    public void setRequestSchemaGenerations(long v) {
        this.setLong(requestSchemaGenerations, v, null);
    }

    @Generated
    public long getSchemaGenerations() {
        return this.getLong(schemaGenerations);
    }

    @Generated
    public void setSchemaGenerations(long v) {
        this.setLong(schemaGenerations, v, null);
    }

    @Generated
    public long getSchemaGenerationFails() {
        return this.getLong(schemaGenerationFails);
    }

    @Generated
    public void setSchemaGenerationFails(long v) {
        this.setLong(schemaGenerationFails, v, null);
    }

    @Generated
    public String getLastSchemaGenerationFailReason() {
        return this.getString(lastSchemaGenerationFailReason);
    }

    @Generated
    public void setLastSchemaGenerationFailReason(String v) {
        this.setString(lastSchemaGenerationFailReason, v, null);
    }

    @Generated
    public long getOutputChanges() {
        return this.getLong(outputChanges);
    }

    @Generated
    public void setOutputChanges(long v) {
        this.setLong(outputChanges, v, null);
    }

    @Generated
    public long getLastOutputSize() {
        return this.getLong(lastOutputSize);
    }

    @Generated
    public void setLastOutputSize(long v) {
        this.setLong(lastOutputSize, v, null);
    }

    @Generated
    public long getOutputSizeTotal() {
        return this.getLong(outputSizeTotal);
    }

    @Generated
    public void setOutputSizeTotal(long v) {
        this.setLong(outputSizeTotal, v, null);
    }

    @Generated
    public long getOutputSizeMax() {
        return this.getLong(outputSizeMax);
    }

    @Generated
    public void setOutputSizeMax(long v) {
        this.setLong(outputSizeMax, v, null);
    }

    @Generated
    public double getOutputSizeAvg() {
        return this.getDouble(outputSizeAvg);
    }

    @Generated
    public void setOutputSizeAvg(double v) {
        this.setDouble(outputSizeAvg, v, null);
    }

    @Generated
    public long getResolveErrors() {
        return this.getLong(resolveErrors);
    }

    @Generated
    public void setResolveErrors(long v) {
        this.setLong(resolveErrors, v, null);
    }

    @Generated
    public long getBaseItemQueueSize() {
        return this.getLong(baseItemQueueSize);
    }

    @Generated
    public void setBaseItemQueueSize(long v) {
        this.setLong(baseItemQueueSize, v, null);
    }

    @Generated
    public long getSubscribes() {
        return this.getLong(subscribes);
    }

    @Generated
    public void setSubscribes(long v) {
        this.setLong(subscribes, v, null);
    }

    @Generated
    public long getUnsubscribes() {
        return this.getLong(unsubscribes);
    }

    @Generated
    public void setUnsubscribes(long v) {
        this.setLong(unsubscribes, v, null);
    }

    @Generated
    public long getSubscriptionEvents() {
        return this.getLong(subscriptionEvents);
    }

    @Generated
    public void setSubscriptionEvents(long v) {
        this.setLong(subscriptionEvents, v, null);
    }

    @Generated
    public long getSubscriptionEventsIgnored() {
        return this.getLong(subscriptionEventsIgnored);
    }

    @Generated
    public void setSubscriptionEventsIgnored(long v) {
        this.setLong(subscriptionEventsIgnored, v, null);
    }

    @Generated
    public long getCacheHits() {
        return this.getLong(cacheHits);
    }

    @Generated
    public void setCacheHits(long v) {
        this.setLong(cacheHits, v, null);
    }

    @Generated
    public long getCacheMisses() {
        return this.getLong(cacheMisses);
    }

    @Generated
    public void setCacheMisses(long v) {
        this.setLong(cacheMisses, v, null);
    }

    @Generated
    public void reset() {
        this.invoke(reset, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReset() {
        Object object = this.mutex;
        synchronized (object) {
            Property[] props = this.getFrozenPropertiesArray();
            Arrays.stream(props).forEach(property -> this.set((Property)property, property.getDefaultValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postProcess(BJsonSchema schema, Exception exception) {
        Object object = this.mutex;
        synchronized (object) {
            if (exception == null) {
                this.incrementMetric(schemaGenerations);
            } else {
                this.incrementMetric(schemaGenerationFails);
                this.setLastSchemaGenerationFailReason(exception.getMessage());
            }
            if (schema.isRelative()) {
                this.setBaseItemQueueSize(((BRelativeJsonSchema)schema.as(BRelativeJsonSchema.class)).getQueueSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputChanged(String output) {
        Object object = this.mutex;
        synchronized (object) {
            int length = output.getBytes().length;
            this.incrementMetric(outputChanges);
            this.setLastOutputSize(length);
            this.increaseMetric(outputSizeTotal, length);
            BigDecimal outputTotal = new BigDecimal(this.getOutputSizeTotal()).setScale(2, RoundingMode.HALF_UP);
            this.setOutputSizeAvg(outputTotal.divide(new BigDecimal(this.getOutputChanges()), RoundingMode.HALF_UP).doubleValue());
            if ((long)length > this.getOutputSizeMax()) {
                this.setOutputSizeMax(length);
            }
        }
    }

    public void incrementRequestCounter() {
        this.incrementMetric(requestSchemaGenerations);
    }

    public void incrementQueryFolderExecs() {
        this.incrementMetric(queryFolderExecutions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryResult(long millis) {
        Object object = this.mutex;
        synchronized (object) {
            this.setLastQueryExecutionMillis(millis);
            this.incrementMetric(individualQueryExecutions);
            this.increaseMetric(queryExecutionMillisTotal, millis);
            BigDecimal millisTotal = new BigDecimal(this.getQueryExecutionMillisTotal()).setScale(2, RoundingMode.HALF_UP);
            this.setQueryExecutionMillisAvg(millisTotal.divide(new BigDecimal(this.getIndividualQueryExecutions()), RoundingMode.HALF_UP).doubleValue());
            if (millis > this.getQueryExecutionMillisMax()) {
                this.setQueryExecutionMillisMax(millis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryFail(String error) {
        Object object = this.mutex;
        synchronized (object) {
            this.incrementMetric(queryFails);
            this.setLastQueryFailReason(error);
            this.incrementMetric(individualQueryExecutions);
        }
    }

    public void subscription() {
        this.incrementMetric(subscribes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscriptionEvent(boolean eventPropagated) {
        Object object = this.mutex;
        synchronized (object) {
            this.incrementMetric(subscriptionEvents);
            if (!eventPropagated) {
                this.incrementMetric(subscriptionEventsIgnored);
            }
        }
    }

    public void unsubscribeEvent() {
        this.incrementMetric(unsubscribes);
    }

    public void cacheResult(BObject cacheValue) {
        this.incrementMetric(cacheValue != null ? cacheHits : cacheMisses);
    }

    public void resolveError() {
        this.incrementMetric(resolveErrors);
    }

    protected void incrementMetric(Property property) {
        this.increaseMetric(property, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseMetric(Property property, long increase) {
        Object object = this.mutex;
        synchronized (object) {
            this.setLong(property, this.getLong(property) + increase);
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BJsonSchemaDebugFolder.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"superscript.png");
    }
}

