/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.program;

import com.tridium.program.BProgram;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaConfigFolder;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaOverrideFolder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="override", parameterType="BValue", defaultValue="new BComponent()", returnType="BValue", flags=2048)
public class BTypeOverride
extends BComponent {
    @Generated
    public static final Action override = BTypeOverride.newAction((int)2048, (BValue)new BComponent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTypeOverride.class);
    private static final Logger log = BJsonSchemaOverrideFolder.ovLog;

    @Generated
    public BValue override(BValue parameter) {
        return this.invoke(override, parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BValue doOverride(BValue value) {
        return this.overrideValueEncoding(value);
    }

    public BValue overrideValueEncoding(BValue value) {
        return this.considerPrograms(value);
    }

    protected BValue considerPrograms(BValue value) {
        BProgram[] overridePrograms = (BProgram[])this.getChildren(BProgram.class);
        if (overridePrograms.length > 0) {
            BProgram program = overridePrograms[0];
            if (log.isLoggable(Level.FINER)) {
                log.finer("Found override program " + program.getName());
            }
            try {
                Action a = program.getAction("override");
                BValue result = program.invoke(a, value);
                if (result != value) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(program.getName() + " replaced " + value + " with " + result);
                    }
                    value = result;
                } else if (log.isLoggable(Level.FINER)) {
                    log.finer("Value not replaced " + result);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, ((BJsonSchemaConfigFolder)this.getParent()).getSchema().getName() + " attempting to user Override Program " + program, e);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " missing override Program");
        }
        return value;
    }

    public BIcon getIcon() {
        return BIcon.std((String)"moveDown.png");
    }
}

