/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.property;

import com.tridium.util.PrefixLogUtil;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaProperty;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="binding", type="BOrd", defaultValue="BOrd.DEFAULT", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"jsonToolkit:SlotOrdFE\")")}), @NiagaraProperty(name="tagId", type="String", defaultValue="n:name"), @NiagaraProperty(name="searchParents", type="boolean", defaultValue="false")})
public class BJsonSchemaTagProperty
extends BJsonSchemaProperty<BIDataValue> {
    @Generated
    public static final Property binding = BJsonSchemaTagProperty.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:SlotOrdFE")));
    @Generated
    public static final Property tagId = BJsonSchemaTagProperty.newProperty((int)0, (String)"n:name", null);
    @Generated
    public static final Property searchParents = BJsonSchemaTagProperty.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonSchemaTagProperty.class);

    @Generated
    public BOrd getBinding() {
        return (BOrd)this.get(binding);
    }

    @Generated
    public void setBinding(BOrd v) {
        this.set(binding, (BValue)v, null);
    }

    @Generated
    public String getTagId() {
        return this.getString(tagId);
    }

    @Generated
    public void setTagId(String v) {
        this.setString(tagId, v, null);
    }

    @Generated
    public boolean getSearchParents() {
        return this.getBoolean(searchParents);
    }

    @Generated
    public void setSearchParents(boolean v) {
        this.setBoolean(searchParents, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BJsonSchemaTagProperty make(BOrd ord, String tagId) {
        BJsonSchemaTagProperty tagProperty = new BJsonSchemaTagProperty();
        tagProperty.setBinding(ord);
        tagProperty.setTagId(tagId);
        return tagProperty;
    }

    private static BIDataValue lookupTag(String tag, BComponent c) {
        try {
            Id id = Id.newId((String)tag);
            Collection tags = c.tags().getAll();
            Optional<Tag> found = tags.stream().filter(t -> t.getId().equals((Object)id)).findFirst();
            if (!found.isPresent()) {
                throw new BajaRuntimeException("tag: not present" + tag + " on " + c.getName());
            }
            BIDataValue v = found.get().getValue();
            if (BJsonSchemaService.log.isLoggable(Level.FINEST)) {
                BJsonSchemaService.log.finest("Found tag: " + v.toString());
            }
            return v;
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Error reading tag " + tag + " from " + c.getName(), (Throwable)e);
        }
    }

    @Override
    public BIDataValue getJsonValue() {
        BComplex base = this.getSchema().getBaseObject();
        if (this.getBinding() == null || this.getBinding().isNull()) {
            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, (String)("Cannot function with null ord in " + this.getSlotPath()), (Object)this);
        } else {
            try {
                BObject object = this.getBinding().get((BObject)base);
                if (object != null) {
                    if (object.getType().is(BComponent.TYPE)) {
                        try {
                            return this.findTagInComponent(object.asComponent());
                        }
                        catch (BajaRuntimeException bre) {
                            if (this.getSearchParents()) {
                                return this.searchParents(object.asComponent());
                            }
                            PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, (String)"Fetching Tag", (Throwable)bre, (Object)this);
                        }
                    } else {
                        PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, (String)("Tags can only be fetched from BComponent type, not: " + object.toDebugString()), (Object)this);
                    }
                }
            }
            catch (UnresolvedException ue) {
                this.getSchema().getConfig().getDebug().getMetrics().resolveError();
                PrefixLogUtil.logWithPrefix((Logger)BJsonSchemaService.log, (Level)Level.WARNING, (String)("base:" + base.getName() + ": cannot find child tagged component: " + this.getBinding()), (Throwable)ue, (Object)this);
            }
        }
        return BString.DEFAULT;
    }

    private BIDataValue searchParents(BComponent component) {
        BComponent parent;
        while ((parent = (BComponent)component.getParent()) != null) {
            try {
                return this.findTagInComponent(parent);
            }
            catch (BajaRuntimeException bre) {
                component = parent;
                continue;
            }
            break;
        }
        return BString.DEFAULT;
    }

    private BIDataValue findTagInComponent(BComponent component) {
        BIDataValue value;
        block3: {
            value = BJsonSchemaTagProperty.lookupTag(this.getTagId(), component);
            if (!this.getSchema().getConfig().getUseEscapeCharacters() && value.getType().is(BString.TYPE)) {
                try {
                    String unescaped = SlotPath.unescape((String)value.toString());
                    value = BString.make((String)unescaped);
                }
                catch (Exception e) {
                    if (!BJsonSchemaService.log.isLoggable(Level.FINE)) break block3;
                    BJsonSchemaService.log.log(Level.FINE, "Could not unescape value " + value, e);
                }
            }
        }
        return value;
    }
}

