/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.query;

import com.tridium.json.JSONException;
import com.tridium.json.JSONWriter;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQuery;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryResultHolder;
import com.tridiumx.jsonToolkit.outbound.schema.query.style.BObjectsArray;
import com.tridiumx.jsonToolkit.outbound.schema.query.style.BQueryResultWriter;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaNameUtil;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="query", type="String", defaultValue="BString.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"jsonToolkit:QueryPickerFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"jsonToolkit:QueryPicker\"))")}), @NiagaraProperty(name="outputStyle", type="BTypeSpec", defaultValue="BObjectsArray.TYPE.getTypeSpec()", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"jsonToolkit:QueryStylePickerFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"jsonToolkit:QueryStylePicker\"))")})})
public class BJsonSchemaBoundQueryResult
extends BJsonSchemaMember {
    @Generated
    public static final Property query = BJsonSchemaBoundQueryResult.newProperty((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:QueryPickerFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:QueryPicker"))));
    @Generated
    public static final Property outputStyle = BJsonSchemaBoundQueryResult.newProperty((int)0, (BValue)BObjectsArray.TYPE.getTypeSpec(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:QueryStylePickerFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:QueryStylePicker"))));
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonSchemaBoundQueryResult.class);
    private static final BIcon ICON = BIcon.make((String)"module://jsonToolkit/icons/bracesQuery.png");

    @Generated
    public String getQuery() {
        return this.getString(query);
    }

    @Generated
    public void setQuery(String v) {
        this.setString(query, v, null);
    }

    @Generated
    public BTypeSpec getOutputStyle() {
        return (BTypeSpec)this.get(outputStyle);
    }

    @Generated
    public void setOutputStyle(BTypeSpec v) {
        this.set(outputStyle, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BJsonSchemaBoundQueryResult make(String queryName, BTypeSpec writerType) {
        BJsonSchemaBoundQueryResult result = new BJsonSchemaBoundQueryResult();
        result.setQuery(queryName);
        result.setOutputStyle(writerType);
        return result;
    }

    @Override
    public String getJsonName() {
        return this.getName();
    }

    @Override
    public void process(JSONWriter jsonWriter, boolean jsonKeysValid) {
        if (jsonKeysValid) {
            JsonSchemaNameUtil.writeKey(this, jsonWriter, this.getJsonName());
        }
        try {
            this.populateQueryContent(jsonWriter);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public BIcon getIcon() {
        return ICON;
    }

    private void populateQueryContent(JSONWriter json) {
        BJsonSchemaQuery query;
        if (!this.getQuery().isEmpty()) {
            query = (BJsonSchemaQuery)this.getSchema().getQueries().get(this.getQuery());
            if (query == null) {
                throw new JSONException(String.format("Query %s not found query result %s: ", this.getQuery(), this.getSchemaPath()));
            }
        } else {
            throw new JSONException("No query defined in bound query result: " + this.getSchemaPath());
        }
        this.populateQueryContent(query, json);
    }

    private void populateQueryContent(BJsonSchemaQuery query, JSONWriter json) {
        if (query != null) {
            if (query.hasLastResult()) {
                QueryResultHolder result = query.getLastResult();
                try {
                    BQueryResultWriter queryStyleWriter = (BQueryResultWriter)this.getOutputStyle().getInstance();
                    queryStyleWriter.initialize(this.getSchema(), this);
                    queryStyleWriter.columnCountCheck(result);
                    queryStyleWriter.appendJson(json, result);
                }
                catch (ClassCastException cce) {
                    throw new JSONException(String.format("Invalid query writer found: %s", this.getOutputStyle()));
                }
            } else {
                JsonSchemaUtil.logger.warning(String.format("No result found for bound query result [%s] in member [%s] in schema [%s] with base [%s] ", this.getQuery(), this.getSchemaPath(), this.getSchema().getName(), JsonSchemaUtil.getSlotPath((BObject)this.getSchema().getBaseObject())));
            }
        } else {
            JsonSchemaUtil.logger.warning(String.format("No query found in bound query result [%s] in schema [%s]", this.getSchemaPath(), this.getSchema().getName()));
        }
    }
}

