/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.relative;

import com.tridiumx.jsonToolkit.outbound.schema.query.QueryFailException;
import com.tridiumx.jsonToolkit.outbound.schema.relative.BRelativeJsonSchema;
import com.tridiumx.jsonToolkit.util.LicenseLimit;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=1), @NiagaraProperty(name="faultCause", type="String", defaultValue="BString.DEFAULT", flags=1), @NiagaraProperty(name="baseQuery", type="BOrd", defaultValue="BOrd.DEFAULT", flags=8, facets={@Facet(value="BFacets.make(BFacets.TARGET_TYPE, \"bql:BqlScheme\")")}), @NiagaraProperty(name="publishInterval", type="BRelTime", defaultValue="BRelTime.makeHours(24)", facets={@Facet(name="BFacets.MIN", value="BRelTime.DEFAULT")}), @NiagaraProperty(name="lastPublishCount", type="int", defaultValue="0", flags=65539), @NiagaraProperty(name="lastPublishTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65539)})
public class BBaseQuery
extends BComponent {
    @Generated
    public static final Property status = BBaseQuery.newProperty((int)1, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BBaseQuery.newProperty((int)1, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property baseQuery = BBaseQuery.newProperty((int)8, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (String)"bql:BqlScheme"));
    @Generated
    public static final Property publishInterval = BBaseQuery.newProperty((int)0, (BValue)BRelTime.makeHours((int)24), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT));
    @Generated
    public static final Property lastPublishCount = BBaseQuery.newProperty((int)65539, (int)0, null);
    @Generated
    public static final Property lastPublishTime = BBaseQuery.newProperty((int)65539, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBaseQuery.class);
    private final Object publishMutex = new Object();
    private static final Lexicon LEX = Lexicon.make(BBaseQuery.class);

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BOrd getBaseQuery() {
        return (BOrd)this.get(baseQuery);
    }

    @Generated
    public void setBaseQuery(BOrd v) {
        this.set(baseQuery, (BValue)v, null);
    }

    @Generated
    public BRelTime getPublishInterval() {
        return (BRelTime)this.get(publishInterval);
    }

    @Generated
    public void setPublishInterval(BRelTime v) {
        this.set(publishInterval, (BValue)v, null);
    }

    @Generated
    public int getLastPublishCount() {
        return this.getInt(lastPublishCount);
    }

    @Generated
    public void setLastPublishCount(int v) {
        this.setInt(lastPublishCount, v, null);
    }

    @Generated
    public BAbsTime getLastPublishTime() {
        return (BAbsTime)this.get(lastPublishTime);
    }

    @Generated
    public void setLastPublishTime(BAbsTime v) {
        this.set(lastPublishTime, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(baseQuery) && this.getSchema().getEnabled()) {
            this.republish();
        } else if (property.equals(publishInterval)) {
            this.getSchema().changed(property, context);
        }
    }

    void republish() {
        if (this.isRunning()) {
            this.getSchema().unregisterAndUnsubscribeAll();
            this.publish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publish() {
        if (!this.isRunning()) {
            return;
        }
        if (BRelativeJsonSchema.logger.isLoggable(Level.FINEST)) {
            BRelativeJsonSchema.logger.finest(this.getName() + " Entering publish");
        }
        LicenseLimit.checkExportLicensed();
        Object object = this.publishMutex;
        synchronized (object) {
            try {
                BITable<BComplex> result = this.resolveBaseQuery();
                this.enqueueBaseItems(result);
            }
            catch (QueryFailException qfe) {
                this.failReport(qfe);
            }
        }
    }

    private BITable<BComplex> resolveBaseQuery() throws QueryFailException {
        if (this.getBaseQuery() == null || this.getBaseQuery().equals((Object)BOrd.NULL)) {
            throw new QueryFailException(LEX.getText("baseUndefined"));
        }
        if (BRelativeJsonSchema.logger.isLoggable(Level.FINE)) {
            BRelativeJsonSchema.logger.fine(String.format("Publishing base query %s for relative schema %s", this.getBaseQuery(), this.getSchema().getName()));
        }
        try {
            BObject candidate = this.getBaseQuery().get((BObject)Sys.getStation());
            if (candidate instanceof BITable) {
                return (BITable)candidate;
            }
            throw new QueryFailException(String.format("%s %s %s [%s]", this.getSchema().getName(), TYPE.getTypeName(), LEX.getText("tableRequired"), this.getBaseQuery()));
        }
        catch (BajaRuntimeException e) {
            throw new QueryFailException(String.format("%s %s", LEX.getText("baseQueryFailed"), e.getMessage()), (Exception)((Object)e));
        }
    }

    private void enqueueBaseItems(BITable<BComplex> result) {
        int itemCount = 0;
        boolean nonBComplexEncountered = false;
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                try {
                    BComplex base = (BComplex)c.get();
                    this.getSchema().enqueueBase(base);
                    ++itemCount;
                }
                catch (ClassCastException cce) {
                    nonBComplexEncountered = true;
                    BRelativeJsonSchema.logger.log(Level.WARNING, String.format("Json Schema %s Query returned non BValue? %s for query %s", this.getSchema().getName(), cce.getMessage(), this.getBaseQuery()));
                }
                catch (UnresolvedException ue) {
                    this.failReport(new QueryFailException(LEX.getText("baseInvalid"), (Exception)((Object)ue)));
                }
            }
        }
        this.setLastPublishCount(itemCount);
        this.setLastPublishTime(BAbsTime.now());
        if (nonBComplexEncountered) {
            this.failReport(new QueryFailException(LEX.getText("baseNonComplex")));
        } else if (itemCount < 1) {
            this.failReport(new QueryFailException(LEX.getText("baseNoObjects")));
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
        if (BRelativeJsonSchema.logger.isLoggable(Level.FINE)) {
            BRelativeJsonSchema.logger.fine(this.getSchema().getName() + ": Base count: " + itemCount + ", with components only: " + nonBComplexEncountered);
        }
    }

    private void failReport(Exception e) {
        this.setStatus(BStatus.fault);
        this.setFaultCause(e.getLocalizedMessage());
        BRelativeJsonSchema.logger.log(Level.WARNING, this.getSchema().getName() + ' ' + e.getLocalizedMessage() + this.getBaseQuery(), e);
    }

    private BRelativeJsonSchema getSchema() {
        return (BRelativeJsonSchema)this.getParent();
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BRelativeJsonSchema.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"animate.png");
    }
}

