/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.CursorException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="nextIndex", type="int", defaultValue="BInteger.make(\"0\")", flags=5), @NiagaraProperty(name="listTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=5), @NiagaraProperty(name="vector", type="BVector", defaultValue="new BVector()", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="addItem", parameterType="BValue", defaultValue="BString.DEFAULT"), @NiagaraAction(name="removeItem", parameterType="BValue", defaultValue="BString.DEFAULT"), @NiagaraAction(name="clearList")})
@NiagaraTopics(value={@NiagaraTopic(name="itemAdded", eventType="BValue"), @NiagaraTopic(name="itemRemoved", eventType="BValue")})
public class BListOf<T extends BValue>
extends BComponent
implements Iterable<T> {
    @Generated
    public static final Property nextIndex = BListOf.newProperty((int)5, (BValue)BInteger.make((String)"0"), null);
    @Generated
    public static final Property listTypeSpec = BListOf.newProperty((int)5, (BValue)BTypeSpec.DEFAULT, null);
    @Generated
    public static final Property vector = BListOf.newProperty((int)5, (BValue)new BVector(), null);
    @Generated
    public static final Action addItem = BListOf.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action removeItem = BListOf.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action clearList = BListOf.newAction((int)0, null);
    @Generated
    public static final Topic itemAdded = BListOf.newTopic((int)0, null);
    @Generated
    public static final Topic itemRemoved = BListOf.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BListOf.class);
    private static final String REMOVED = "REMOVED";
    private static final String ITEM = "item";
    private final Object mutex = new Object();
    private Class<T> typeClass;

    @Generated
    public int getNextIndex() {
        return this.getInt(nextIndex);
    }

    @Generated
    public void setNextIndex(int v) {
        this.setInt(nextIndex, v, null);
    }

    @Generated
    public BTypeSpec getListTypeSpec() {
        return (BTypeSpec)this.get(listTypeSpec);
    }

    @Generated
    public void setListTypeSpec(BTypeSpec v) {
        this.set(listTypeSpec, (BValue)v, null);
    }

    @Generated
    public BVector getVector() {
        return (BVector)this.get(vector);
    }

    @Generated
    public void setVector(BVector v) {
        this.set(vector, (BValue)v, null);
    }

    @Generated
    public void addItem(BValue parameter) {
        this.invoke(addItem, parameter, null);
    }

    @Generated
    public void removeItem(BValue parameter) {
        this.invoke(removeItem, parameter, null);
    }

    @Generated
    public void clearList() {
        this.invoke(clearList, null, null);
    }

    @Generated
    public void fireItemAdded(BValue event) {
        this.fire(itemAdded, event, null);
    }

    @Generated
    public void fireItemRemoved(BValue event) {
        this.fire(itemRemoved, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BListOf() {
    }

    public BListOf(Type type) {
        this.setListTypeSpec(type.getTypeSpec());
    }

    @SafeVarargs
    public BListOf(Type type, T ... initialValues) {
        this.setListTypeSpec(type.getTypeSpec());
        Arrays.stream(initialValues).forEach(this::add);
    }

    public boolean isNavChild() {
        return false;
    }

    public boolean isChildLegal(BComponent child) {
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final SlotCursor<Property> cursor;
            {
                this.cursor = BListOf.this.getCursor();
            }

            @Override
            public boolean hasNext() {
                if (BListOf.this.getListTypeSpec().equals((Object)BTypeSpec.DEFAULT)) {
                    return false;
                }
                return this.cursor.next(BListOf.this.getTypeClass());
            }

            @Override
            public T next() {
                try {
                    return this.cursor.get();
                }
                catch (CursorException e) {
                    throw new NoSuchElementException(e.getMessage());
                }
            }
        };
    }

    public void doAddItem(BValue value) {
        this.add(value);
    }

    public void doRemoveItem(BValue value) {
        this.remove(value);
    }

    public void doClearList() {
        this.clear();
    }

    public final boolean contains(BValue element) {
        for (BValue existing : this) {
            if (!existing.equivalent((Object)element)) continue;
            return true;
        }
        return false;
    }

    public String toString(Context cx) {
        if (cx instanceof BasicContext) {
            return "List of " + this.size() + ':' + this.getListTypeSpec().getTypeName();
        }
        StringBuilder sb = new StringBuilder("{");
        SlotCursor<Property> sc = this.getCursor();
        if (!this.getListTypeSpec().equals((Object)BTypeSpec.DEFAULT)) {
            while (sc.next(this.getTypeClass())) {
                if (!((Property)sc.slot()).isProperty()) continue;
                sb.append(sc.get()).append(',');
            }
        }
        if (sb.length() == 1) {
            return "{}";
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(BValue listElement) {
        Object object = this.mutex;
        synchronized (object) {
            int nextIndex = this.getNextIndex();
            this.setNextIndex(nextIndex + 1);
            this.getVector().add(ITEM + nextIndex, listElement.newCopy(), 5);
            this.fireItemAdded(listElement);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T set(int index, T listElement) {
        if (this.rangeCheckForAdd(index)) {
            Object object = this.mutex;
            synchronized (object) {
                if (index == this.getNextIndex()) {
                    this.add((BValue)listElement);
                    return listElement;
                }
                BVector vector = this.getVector();
                vector.set(ITEM + index, listElement.newCopy());
                vector.setFlags(vector.getSlot(ITEM + index), 5);
            }
            this.fireItemAdded((BValue)listElement);
            return listElement;
        }
        throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T listElement) {
        if (this.getListTypeSpec().equals((Object)BTypeSpec.DEFAULT)) {
            return false;
        }
        SlotCursor<Property> c = this.getCursor();
        boolean removed = false;
        Object object = this.mutex;
        synchronized (object) {
            try {
                while (c.next(this.getTypeClass())) {
                    Property property = c.property();
                    if (!removed && c.get().equivalent(listElement)) {
                        this.getVector().rename(property, REMOVED);
                        removed = true;
                        this.setNextIndex(this.getNextIndex() - 1);
                        continue;
                    }
                    if (!removed) continue;
                    int index = BListOf.indexOf(property);
                    this.getVector().rename(property, ITEM + --index);
                }
            }
            finally {
                if (removed) {
                    this.getVector().remove(REMOVED);
                    this.fireItemRemoved((BValue)listElement);
                }
            }
        }
        return removed;
    }

    public T remove(int index) {
        if (this.rangeCheck(index)) {
            T toRemove = this.get(index);
            this.remove(toRemove);
            return toRemove;
        }
        throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
    }

    public T get(int index) {
        if (this.rangeCheck(index)) {
            return (T)this.getVector().get(ITEM + index);
        }
        throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
    }

    public int indexOf(T listElement) {
        SlotCursor<Property> c = this.getCursor();
        if (!this.getListTypeSpec().equals((Object)BTypeSpec.DEFAULT)) {
            while (c.next(this.getTypeClass())) {
                if (!c.get().equivalent(listElement)) continue;
                return BListOf.indexOf(c.property());
            }
        }
        return -1;
    }

    private static int indexOf(Property property) {
        return Integer.parseInt(property.getName().substring(ITEM.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.getVector().removeAll();
            this.setNextIndex(0);
        }
    }

    public int size() {
        return this.getNextIndex();
    }

    public boolean isEmpty() {
        return this.getNextIndex() == 0;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)("ListOf " + this.getTypeClass().getSimpleName()), 2);
        SlotCursor<Property> c = this.getCursor();
        if (!this.getListTypeSpec().equals((Object)BTypeSpec.DEFAULT)) {
            while (c.next(this.getTypeClass())) {
                BValue value = c.get();
                out.prop((Object)((Property)c.slot()).getName(), (Object)value);
            }
        }
        out.endProps();
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public List<T> toList() {
        ArrayList<T> result = new ArrayList<T>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.get(i));
        }
        return result;
    }

    private SlotCursor<Property> getCursor() {
        return this.getVector().getProperties();
    }

    private boolean rangeCheckForAdd(int index) {
        return index <= this.size() && index > -1;
    }

    private boolean rangeCheck(int index) {
        return index < this.size() && index > -1;
    }

    private String outOfBoundsMsg(int index) {
        return "index: " + index + " current size: " + this.size();
    }

    private Class<T> getTypeClass() {
        if (this.typeClass == null) {
            this.typeClass = this.getListTypeSpec().getInstance().getClass();
        }
        return this.typeClass;
    }
}

