/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.driver.util.DrUtil;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.fox.sys.data.BIPostQueryFilter;
import com.tridium.fox.sys.data.BIPreQueryValidator;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNSpaceScheme;
import com.tridium.nd.BNiagaraEdgeLiteStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.nd.util.BNiagaraRemoteQueryFilter;
import com.tridium.nd.util.NiagaraDriverUtil;
import com.tridium.nd.virtual.BNiagaraVirtualDeviceExt;
import com.tridium.niagaraSystemIndex.BNiagaraNetworkSystemIndexer;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexImport;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.metrics.BISubLicenseable;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemIndex.BSystemIndexService;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import com.tridium.systemIndex.SystemIndexUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.util.BDescriptorDeviceExt;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relations;
import javax.baja.tag.Tags;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.virtual.VirtualPath;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="globalIndexStatus", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="globalIndexState", type="BDescriptorState", defaultValue="BDescriptorState.idle", flags=1), @NiagaraProperty(name="globalIndexLastAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="globalIndexLastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="globalIndexLastFailure", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="globalIndexFaultCause", type="String", defaultValue="", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="acceptsGlobalIndexRequests", type="boolean", defaultValue="true")})
@NiagaraAction(name="executeGlobalIndexOnThisStation", flags=16)
public abstract class BAbstractSystemIndexDeviceExt
extends BDescriptorDeviceExt
implements BIStatus,
BINiagaraDeviceExt,
BISubLicenseable,
BFoxClientConnection.Interest {
    @Generated
    public static final Property globalIndexStatus = BAbstractSystemIndexDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property globalIndexState = BAbstractSystemIndexDeviceExt.newProperty((int)1, (BValue)BDescriptorState.idle, null);
    @Generated
    public static final Property globalIndexLastAttempt = BAbstractSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property globalIndexLastSuccess = BAbstractSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property globalIndexLastFailure = BAbstractSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property globalIndexFaultCause = BAbstractSystemIndexDeviceExt.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property acceptsGlobalIndexRequests = BAbstractSystemIndexDeviceExt.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action executeGlobalIndexOnThisStation = BAbstractSystemIndexDeviceExt.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractSystemIndexDeviceExt.class);
    private static BCategoryService categoryService;
    private static BNiagaraNetwork niagaraNetwork;
    private static final BIcon icon;
    static final Version VER_4_4;
    private static final Id nStationId;
    private static final Map<String, Integer> entitiesPerStationLimit;
    private final AtomicBoolean checkedLicense = new AtomicBoolean();
    private volatile String fatalFault;
    private long numGlobalExecutes;
    private long totalGlobalExecuteTime;
    private long minGlobalExecuteTime = Long.MAX_VALUE;
    private long maxGlobalExecuteTime;

    @Generated
    public BStatus getGlobalIndexStatus() {
        return (BStatus)this.get(globalIndexStatus);
    }

    @Generated
    public void setGlobalIndexStatus(BStatus v) {
        this.set(globalIndexStatus, (BValue)v, null);
    }

    @Generated
    public BDescriptorState getGlobalIndexState() {
        return (BDescriptorState)this.get(globalIndexState);
    }

    @Generated
    public void setGlobalIndexState(BDescriptorState v) {
        this.set(globalIndexState, (BValue)v, null);
    }

    @Generated
    public BAbsTime getGlobalIndexLastAttempt() {
        return (BAbsTime)this.get(globalIndexLastAttempt);
    }

    @Generated
    public void setGlobalIndexLastAttempt(BAbsTime v) {
        this.set(globalIndexLastAttempt, (BValue)v, null);
    }

    @Generated
    public BAbsTime getGlobalIndexLastSuccess() {
        return (BAbsTime)this.get(globalIndexLastSuccess);
    }

    @Generated
    public void setGlobalIndexLastSuccess(BAbsTime v) {
        this.set(globalIndexLastSuccess, (BValue)v, null);
    }

    @Generated
    public BAbsTime getGlobalIndexLastFailure() {
        return (BAbsTime)this.get(globalIndexLastFailure);
    }

    @Generated
    public void setGlobalIndexLastFailure(BAbsTime v) {
        this.set(globalIndexLastFailure, (BValue)v, null);
    }

    @Generated
    public String getGlobalIndexFaultCause() {
        return this.getString(globalIndexFaultCause);
    }

    @Generated
    public void setGlobalIndexFaultCause(String v) {
        this.setString(globalIndexFaultCause, v, null);
    }

    @Generated
    public boolean getAcceptsGlobalIndexRequests() {
        return this.getBoolean(acceptsGlobalIndexRequests);
    }

    @Generated
    public void setAcceptsGlobalIndexRequests(boolean v) {
        this.setBoolean(acceptsGlobalIndexRequests, v, null);
    }

    @Generated
    public void executeGlobalIndexOnThisStation() {
        this.invoke(executeGlobalIndexOnThisStation, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public String getStationName() {
        return this.getDevice().getName();
    }

    protected BReachableStationInfo getReachableStationInfo() {
        return null;
    }

    protected BStatus getReachableStationStatus() {
        return BStatus.ok;
    }

    public boolean getReceiveExportedIndexFromRemoteStation() {
        return false;
    }

    protected void globalIndexSucceeded() {
    }

    protected void globalIndexFailed(Throwable reason) {
    }

    final boolean canAcceptGlobalQueries(SystemIndexLog log, boolean checkLicense, Context cx) {
        if (!this.getAcceptsGlobalIndexRequests() || this.isDisabled()) {
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.disabled", new String[]{this.getStationName()});
            }
            return false;
        }
        if (this.getDevice().isFatalFault()) {
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.fatalFault", new String[]{this.getStationName()});
            }
            return false;
        }
        BSystemIndexService indexService = BAbstractSystemIndexDeviceExt.getSystemIndexService(false);
        if (indexService == null || !indexService.isOperational()) {
            String lexKey = indexService == null ? "systemIndex.missingSystemIndex" : "systemIndex.inoperableSystemIndex";
            this.setGlobalIndexFaultCause(Lexicon.make((String)"systemIndex", (Context)cx).getText(lexKey));
            if (log.isLoggingEnabled()) {
                log.message("systemIndex", lexKey);
            }
            return false;
        }
        if (!this.remoteStationSupportsIndexing(log)) {
            return false;
        }
        if (this.hasEnabledEntityImport()) {
            this.setGlobalIndexFaultCause(Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.indexSkipped.importExists"));
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.importExists", new String[]{this.getStationName()});
            }
            return false;
        }
        if (checkLicense) {
            try {
                this.checkLicenseForIndexing();
            }
            catch (Exception e) {
                this.setGlobalIndexFaultCause(SystemIndexUtil.getFailureReason((Throwable)e));
                if (log.isLoggingEnabled()) {
                    log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.fatalFault", new String[]{this.getStationName()});
                }
                return false;
            }
        }
        return true;
    }

    private boolean hasEnabledEntityImport() {
        SlotCursor props = this.getProperties();
        while (props.next(BNiagaraSystemIndexImport.class)) {
            BNiagaraSystemIndexImport indexImport = (BNiagaraSystemIndexImport)props.get();
            if (!indexImport.isRunning() || indexImport.isDisabled() || indexImport.isFatalFault()) continue;
            return true;
        }
        return false;
    }

    final void executeGlobalIndex(BOrdList indexQueries, SystemIndexLog log, Context cx) {
        if (!this.isDown() && this.canAcceptGlobalQueries(log, true, cx)) {
            long start = DiagnosticUtil.startIfLoggable((String)"systemIndexDeviceExt_executeGlobal");
            long startTicks = Clock.ticks();
            BReachableStationInfo info = this.getReachableStationInfo();
            BFoxClientConnection connection = ((BNiagaraStation)this.getDevice()).getClientConnection();
            try {
                this.executeInProgress();
                int limit = this.checkLicenseForIndexing();
                BAbstractSystemIndexDeviceExt.getCategoryService(true);
                BAbstractSystemIndexDeviceExt.getNiagaraNetwork(true);
                if (log.isLoggingEnabled()) {
                    log.start("systemIndex", "systemIndex.job.startFullIndex", new String[]{'\"' + this.getStationName() + '\"', indexQueries.toString(cx)});
                }
                connection.engageNoRetry((BFoxClientConnection.Interest)this);
                BDataChannel channel = (BDataChannel)connection.getChannels().get("data", BDataChannel.TYPE);
                BNiagaraRemoteQueryFilter[] queryFilters = new BNiagaraRemoteQueryFilter[]{BNiagaraRemoteQueryFilter.make((boolean)true, (boolean)this.getReceiveExportedIndexFromRemoteStation())};
                List entitiesList = channel.resolveReachableStationEntitiesToList(indexQueries, 0, -1, null, (BIPreQueryValidator[])queryFilters, (BIPostQueryFilter[])queryFilters, info != null ? NiagaraDriverUtil.parseRouteToStation((String)info.getRouteToStation(), (boolean)false) : null);
                int size = limit != Integer.MAX_VALUE ? entitiesList.size() : -1;
                String stationNameStr = this.getStationName();
                connection.disengage((BFoxClientConnection.Interest)this);
                BSystemIndexer.systemIndexToSystemDb((String)stationNameStr, BAbstractSystemIndexDeviceExt.toEntityStream(stationNameStr, entitiesList, size, limit, info), (SystemIndexLog)log, (Context)SystemIndexContextHolder.INDEX_CONTEXT);
                this.executeOk();
                if (size > limit) {
                    String[] args = new String[]{this.getStationName(), Integer.toString(size), Integer.toString(limit)};
                    this.setGlobalIndexFaultCause(Lexicon.make((String)"systemIndex").getText("systemIndex.exceededEntityLimit", (Object[])args));
                    if (log.isLoggingEnabled()) {
                        log.message("systemIndex", "systemIndex.exceededEntityLimit.noLineFeeds", args);
                    }
                }
                if (log.isLoggingEnabled()) {
                    log.success("systemIndex", "systemIndex.job.completeFullIndex", new String[]{'\"' + this.getStationName() + '\"', indexQueries.toString(cx)});
                }
            }
            catch (Throwable th) {
                Throwable t = SystemIndexUtil.processAndLogSystemIndexError((Throwable)th, (BComponent)(info != null ? info : this.getDevice()));
                this.executeFail(t);
                if (log.isLoggingEnabled()) {
                    log.failed("systemIndex", "systemIndex.job.failedFullIndex", new String[]{'\"' + this.getStationName() + '\"', indexQueries.toString(cx)}, t);
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new BajaRuntimeException(t.getLocalizedMessage(), t);
            }
            finally {
                if (connection != null && connection.isEngaged((BFoxClientConnection.Interest)this)) {
                    connection.disengage((BFoxClientConnection.Interest)this);
                }
                if (start != 0L) {
                    DiagnosticUtil.complete((long)start, (String)"systemIndexDeviceExt_executeGlobal", (Object)this.toPathString());
                }
                this.updateGlobalStatistics(startTicks);
            }
        }
    }

    public final IFuture post(Action action, BValue arg, Context cx) {
        if (executeGlobalIndexOnThisStation.equals(action)) {
            if (this.isDown() || this.getGlobalIndexState() != BDescriptorState.idle || !this.canAcceptGlobalQueries(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG, true, cx)) {
                if (!this.isDown()) {
                    BSystemIndexService indexService = BAbstractSystemIndexDeviceExt.getSystemIndexService(false);
                    if (indexService == null) {
                        this.executeFail(Lexicon.make((String)"systemIndex").getText("systemIndex.missingSystemIndex"));
                    } else if (indexService.isFatalFault()) {
                        this.executeFail(Lexicon.make((String)"systemIndex").getText("systemIndex.inoperableSystemIndex"));
                    } else if (this.fatalFault != null) {
                        this.executeFail(this.getGlobalIndexFaultCause());
                    }
                }
                return null;
            }
            try {
                this.executePending();
                this.getGlobalNiagaraNetworkIndexer(cx).validateIndexQueries(cx);
                BSystemIndexService service = BAbstractSystemIndexDeviceExt.getSystemIndexService(true);
                BNiagaraNetworkSystemIndexer.executeAsync(service, this.getDevice().getName(), (Runnable)new Invocation((BComponent)this, action, arg, cx));
                return null;
            }
            catch (Exception e) {
                this.setGlobalIndexLastAttempt(Clock.time());
                this.executeFail(e);
                return null;
            }
        }
        return super.post(action, arg, cx);
    }

    public final void doExecuteGlobalIndexOnThisStation(Context cx) {
        if (this.canAcceptGlobalQueries(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG, true, cx)) {
            BSystemIndexer.runIndex((String)Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.individualGlobalIndex", new Object[]{this.getStationName()}), (Context)cx, (log, context) -> this.executeGlobalIndex(this.getGlobalNiagaraNetworkIndexer((Context)context).getOperationalIndexQueries(), (SystemIndexLog)log, (Context)context));
        }
    }

    static BSystemIndexService getSystemIndexService(boolean failOnMissing) {
        BSystemIndexService service = null;
        try {
            service = (BSystemIndexService)Sys.getService((Type)BSystemIndexService.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (failOnMissing && service == null) {
            throw new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.unavailableSystemIndexService");
        }
        return service;
    }

    private BNiagaraNetworkSystemIndexer getGlobalNiagaraNetworkIndexer(Context cx) {
        BNiagaraNetworkSystemIndexer indexer = null;
        try {
            indexer = (BNiagaraNetworkSystemIndexer)BOrd.make((String)"service:niagaraSystemIndex:NiagaraNetworkSystemIndexSource|slot:globalNiagaraNetworkIndexer").get((BObject)this, cx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (indexer == null) {
            throw new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.unavailableGlobalIndexer");
        }
        return indexer;
    }

    private void executeOk() {
        this.setGlobalIndexFaultCause("");
        this.setGlobalIndexLastSuccess(Clock.time());
        this.setGlobalIndexState(BDescriptorState.idle);
        this.updateStatus();
        this.globalIndexSucceeded();
    }

    private void executeFail(Throwable ex) {
        this.globalIndexFailed(ex);
        this.executeFail(SystemIndexUtil.getFailureReason((Throwable)ex));
    }

    private void executeFail(String reason) {
        this.setGlobalIndexLastFailure(Clock.time());
        this.setGlobalIndexFaultCause(reason);
        this.setGlobalIndexState(BDescriptorState.idle);
        this.updateStatus();
    }

    private void executeInProgress() {
        this.setGlobalIndexLastAttempt(Clock.time());
        this.setGlobalIndexState(BDescriptorState.inProgress);
    }

    final void executePending() {
        this.setGlobalIndexState(BDescriptorState.pending);
    }

    public final BStatus getStatus() {
        return this.getGlobalIndexStatus();
    }

    public final boolean isFault() {
        return this.getGlobalIndexStatus().isFault();
    }

    public final boolean isDisabled() {
        return this.getGlobalIndexStatus().isDisabled();
    }

    public final boolean isDown() {
        return this.getGlobalIndexStatus().isDown();
    }

    public void updateStatus() {
        super.updateStatus();
        int newStatus = this.getGlobalIndexStatus().getBits();
        BStatus deviceStatus = this.getDevice().getStatus();
        BReachableStationInfo info = this.getReachableStationInfo();
        newStatus = deviceStatus.isDisabled() || !this.getAcceptsGlobalIndexRequests() || info != null && (!info.getRouteEnabled() || info.getReachableStationsContainer().isDisabled()) ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = deviceStatus.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        newStatus = this.fatalFault != null || !this.getGlobalIndexLastFailure().isNull() && this.getGlobalIndexLastFailure().isAfter(this.getGlobalIndexLastSuccess()) || deviceStatus.isFault() || !this.remoteStationSupportsIndexing(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG) ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (newStatus == this.getGlobalIndexStatus().getBits()) {
            return;
        }
        this.setGlobalIndexStatus(BStatus.make((int)newStatus));
    }

    protected boolean remoteStationSupportsIndexing(SystemIndexLog log) {
        BNiagaraStation station = (BNiagaraStation)this.getDevice();
        String remoteVersionStr = station.getVersion();
        if (!remoteVersionStr.isEmpty() && new Version(remoteVersionStr).compareTo(VER_4_4) < 0) {
            if (this.getGlobalIndexFaultCause().isEmpty()) {
                this.setGlobalIndexFaultCause(Lexicon.make((BModule)TYPE.getModule(), (Context)null).getText("niagaraSystemIndex.incompatibleVersion", new Object[]{remoteVersionStr, VER_4_4}));
            }
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.versionMismatch", new String[]{station.getName(), remoteVersionStr, VER_4_4.toString()});
            }
            return false;
        }
        return true;
    }

    static BCategoryService getCategoryService(boolean reload) {
        if (reload || categoryService == null) {
            categoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
        }
        return categoryService;
    }

    static BNiagaraNetwork getNiagaraNetwork(boolean reload) {
        if (reload || niagaraNetwork == null) {
            niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        }
        return niagaraNetwork;
    }

    public static Supplier<Stream<Entity>> toEntityStream(String stationName, List<Entity> entitiesList, int size, int limit, BReachableStationInfo info) {
        return () -> {
            BString sName = BString.make((String)stationName);
            Stream<Entity> remoteEntities = entitiesList.stream().map(e -> BAbstractSystemIndexDeviceExt.convertRemoteEntity(e, sName, info)).distinct();
            if (size > limit) {
                remoteEntities = remoteEntities.limit(limit);
            }
            return remoteEntities;
        };
    }

    private static Entity convertRemoteEntity(Entity e, BString stationName, BReachableStationInfo info) {
        Tags tags = e.tags();
        if (!tags.contains(nStationId)) {
            tags.set(nStationId, (BIDataValue)stationName);
        }
        if (e instanceof BICategorizable) {
            return e;
        }
        return new CategorizableEntity(e, info);
    }

    public void clientOpened() {
    }

    public void clientClosed() {
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public BIcon getIcon() {
        return icon;
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"System Index Statistics", 2);
            out.prop((Object)"Total Global Execute attempts", (Object)String.valueOf(this.numGlobalExecutes));
            out.prop((Object)"Total Global Execute time", (Object)BRelTime.make((long)this.totalGlobalExecuteTime));
            long avg = this.numGlobalExecutes > 0L ? this.totalGlobalExecuteTime / this.numGlobalExecutes : 0L;
            out.prop((Object)"Avg Global Execute time", (Object)BRelTime.make((long)avg));
            long min = this.minGlobalExecuteTime != Long.MAX_VALUE ? this.minGlobalExecuteTime : 0L;
            out.prop((Object)"Min Global Execute time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max Global Execute time", (Object)BRelTime.make((long)this.maxGlobalExecuteTime));
            out.endProps();
        }
        super.spy(out);
    }

    private void updateGlobalStatistics(long startTicks) {
        long duration = Clock.ticks() - startTicks;
        BNiagaraNetworkSystemIndexer.updateStatistics((BComponent)this, duration);
        ++this.numGlobalExecutes;
        this.totalGlobalExecuteTime += duration;
        if (duration <= this.minGlobalExecuteTime) {
            this.minGlobalExecuteTime = duration;
        }
        if (duration >= this.maxGlobalExecuteTime) {
            this.maxGlobalExecuteTime = duration;
        }
    }

    public final String getLicenseKeyPrefix() {
        BDevice parentDevice;
        try {
            parentDevice = this.getDevice();
        }
        catch (Exception e) {
            parentDevice = (BDevice)DrUtil.getParent((BComplex)this, (Type)BDevice.TYPE);
        }
        if (BISubLicenseable.isSubLicenseable((BObject)parentDevice)) {
            if (parentDevice instanceof BNiagaraEdgeLiteStation) {
                return "edgeLite1";
            }
            return ((BISubLicenseable)parentDevice).getLicenseKeyPrefix();
        }
        return null;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 501) {
            try {
                this.checkLicenseForIndexing();
                return null;
            }
            catch (Exception e) {
                String unlicensed = SystemIndexUtil.getFailureReason((Throwable)e);
                if (unlicensed == null) {
                    unlicensed = "unlicensed";
                }
                return unlicensed;
            }
        }
        if (x == 11) {
            if (this.getGlobalIndexState() != BDescriptorState.idle) {
                this.executeFail(Lexicon.make((String)"niagaraSystemIndex").getText("niagaraSystemIndex.indexFailure.interrupted"));
            } else {
                this.updateStatus();
            }
        } else if (x == 2 && this.isRunning() && acceptsGlobalIndexRequests.equals(a)) {
            this.updateStatus();
        }
        return super.fw(x, a, b, c, d);
    }

    int checkLicenseForIndexing() throws Exception {
        String key;
        int entitiesPerStationLimit;
        BSystemIndexService systemIndexService = BAbstractSystemIndexDeviceExt.getSystemIndexService(true);
        if (this.fatalFault != null) {
            throw new LocalizableRuntimeException("systemIndex", "systemIndex.unlicensedStation", new Object[]{this.getStationName(), this.fatalFault});
        }
        if (!this.checkedLicense.get()) {
            BDevice device = this.getDevice();
            if (device == null) {
                throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{"null", this.getType()});
            }
            String prefix = this.getLicenseKeyPrefix();
            if (prefix == null) {
                prefix = "";
            }
            this.fatalFault = (String)systemIndexService.fw(501, (Object)BISubLicenseable.getLicenseKey((BObject)this, (String)"station.limit"), (Object)(prefix + this.getStationName()), null, null);
            this.checkedLicense.set(true);
            if (this.fatalFault != null) {
                Object[] args = new Object[]{this.getStationName(), this.fatalFault};
                this.setGlobalIndexFaultCause(Lexicon.make((String)"systemIndex").getText("systemIndex.unlicensedStation", args));
                this.updateStatus();
                throw new LocalizableRuntimeException("systemIndex", "systemIndex.unlicensedStation", args);
            }
        }
        if ((entitiesPerStationLimit = BAbstractSystemIndexDeviceExt.entitiesPerStationLimit.computeIfAbsent(key = BISubLicenseable.getLicenseKey((BObject)this, (String)"station.entity.limit"), k -> LicenseUtil.parseLimit((Feature)systemIndexService.getLicenseFeature(), (String)k)).intValue()) <= 0) {
            String msg = Lexicon.make((String)"systemIndex").getText("systemIndex.missingEntityLimit", new Object[]{key});
            throw new LocalizableRuntimeException("systemIndex", "systemIndex.unlicensedStation", new Object[]{this.getStationName(), msg});
        }
        return entitiesPerStationLimit;
    }

    static {
        icon = BIcon.std((String)"indexService.png");
        VER_4_4 = new Version("4.4");
        nStationId = Id.newId((String)"n", (String)"station");
        entitiesPerStationLimit = Collections.synchronizedMap(new HashMap());
    }

    static final class SystemIndexContextHolder {
        public static final Context INDEX_CONTEXT = AccessController.doPrivileged(BSystemDb::getSystemIndexContext);

        SystemIndexContextHolder() {
        }
    }

    private static class CategorizableEntity
    implements Entity,
    BICategorizable {
        private final Entity entity;
        private final BReachableStationInfo reachableStationInfo;

        public CategorizableEntity(Entity entity, BReachableStationInfo info) {
            this.entity = entity;
            this.reachableStationInfo = info;
        }

        public Tags tags() {
            return this.entity.tags();
        }

        public BCategoryMask getAppliedCategoryMask() {
            return this.computeCategoryMask(true);
        }

        public BCategoryMask getCategoryMask() {
            return this.computeCategoryMask(false);
        }

        private BCategoryMask computeCategoryMask(boolean applied) {
            BOrd ord = this.getOrdToEntity().orElseThrow(() -> new BajaRuntimeException("Missing Entity ORD encountered during system index"));
            OrdQuery[] queries = ord.parse();
            OrdQuery nspaceQuery = queries[0];
            if (!nspaceQuery.getScheme().equals(BNSpaceScheme.INSTANCE.getId())) {
                throw new BajaRuntimeException("Unexpected Entity ORD encountered during system index: " + ord);
            }
            BNiagaraStation station = null;
            if (this.reachableStationInfo == null && (station = (BNiagaraStation)BAbstractSystemIndexDeviceExt.getNiagaraNetwork(false).getStation(nspaceQuery.getBody())) == null) {
                throw new BajaRuntimeException("Cannot find local NiagaraStation corresponding to Entity ORD encountered during system index: " + ord);
            }
            for (int i = 1; i < queries.length; ++i) {
                String body;
                SlotPath path = null;
                if (queries[i] instanceof VirtualPath) {
                    path = (SlotPath)queries[i];
                } else if (queries[i] instanceof SlotPath) {
                    path = VirtualPath.convertFromSlotPath((SlotPath)((SlotPath)queries[i]));
                    queries[i] = path;
                }
                if (this.reachableStationInfo == null || path == null || !path.isAbsolute() || !(body = path.getBody()).startsWith("/")) continue;
                queries[i] = body.length() == 1 ? VirtualPath.EMPTY_VIRTUAL_PATH : path.makePath(body.substring(1));
            }
            BNiagaraVirtualDeviceExt gateway = null;
            if (this.reachableStationInfo == null) {
                gateway = station.getVirtual();
                ord = BOrd.make((BOrd)gateway.getNavOrd().relativizeToSession(), (BOrd)BOrd.make((OrdQuery[])queries, (int)1, (int)queries.length));
            } else {
                ord = BOrd.make((BOrd)this.reachableStationInfo.getVirtualSpaceOrd(), (BOrd)BOrd.make((OrdQuery[])queries, (int)1, (int)queries.length));
            }
            if (ord != null && !ord.isNull()) {
                BCategoryService service = BAbstractSystemIndexDeviceExt.getCategoryService(false);
                BCategoryMask mask = applied ? service.getOrdMap().getAppliedCategoryMask(ord) : service.getOrdMap().getCategoryMask(ord);
                if (mask != null) {
                    return mask;
                }
            }
            if (applied) {
                if (this.reachableStationInfo != null) {
                    BReachableStations container = this.reachableStationInfo.getReachableStationsContainer();
                    if (container != null) {
                        station = container.getNiagaraStation();
                    }
                    if (station == null) {
                        throw new BajaRuntimeException("Cannot find local NiagaraStation corresponding to Entity ORD encountered during system index: " + ord);
                    }
                    gateway = station.getVirtual();
                }
                return gateway.getAppliedCategoryMask();
            }
            return BCategoryMask.NULL;
        }

        public Relations relations() {
            return this.entity.relations();
        }

        public Optional<BOrd> getOrdToEntity() {
            return this.entity.getOrdToEntity();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CategorizableEntity) {
                return this.getOrdToEntity().equals(((CategorizableEntity)obj).getOrdToEntity());
            }
            return false;
        }

        public int hashCode() {
            return this.getOrdToEntity().hashCode();
        }

        public <T extends BIObject> T as(Class<T> cls) {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public BIDataValue toDataValue() {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public String toString(Context context) {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public boolean equivalent(Object obj) {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public Type getType() {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }

        public BObject asObject() {
            throw new UnsupportedOperationException("Only Entity and Category APIs are valid");
        }
    }
}

