/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.niagaraSystemIndex.BAbstractSystemIndexDeviceExt;
import com.tridium.niagaraSystemIndex.BNiagaraNetworkSystemIndexSource;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexDeviceExt;
import com.tridium.niagaraSystemIndex.BReachableStationSystemIndexDeviceExt;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.systemIndex.BSystemIndexJob;
import com.tridium.systemIndex.BSystemIndexService;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import com.tridium.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.job.BJob;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="globalIndexTimeout", type="BRelTime", defaultValue="BRelTime.makeHours(2)", facets={@Facet(name="BFacets.MIN", value="BRelTime.make(1)")}), @NiagaraProperty(name="includeReachableStations", type="boolean", defaultValue="false"), @NiagaraProperty(name="globalIndexLastResult", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")})})
public final class BNiagaraNetworkSystemIndexer
extends BSystemIndexer
implements BIRestrictedComponent {
    @Generated
    public static final Property globalIndexTimeout = BNiagaraNetworkSystemIndexer.newProperty((int)0, (BValue)BRelTime.makeHours((int)2), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    @Generated
    public static final Property includeReachableStations = BNiagaraNetworkSystemIndexer.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property globalIndexLastResult = BNiagaraNetworkSystemIndexer.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraNetworkSystemIndexer.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"index.png"), (BIcon)BIcon.std((String)"badges/import.png"));
    private static final int MAX_DISPLAYED_FAILURES = 5;
    private static final String INDEX_EXPORT_ERROR_MSG = Lexicon.make((String)"niagaraDriver").get("niagaraSystemIndex.illegalImportAndExport", "");
    private static final Lexicon lex = Lexicon.make((String)"niagaraSystemIndex");
    private static final Logger LOG = Logger.getLogger("systemIndex");
    private static final String[][] LICENSE_LIMIT_PAIRS = new String[][]{{"station.limit", "station.entity.limit"}, {"edgeLite1_station.limit", "edgeLite1_station.entity.limit"}};
    private static final String LEXICON_ARG;
    private static final String GLOBAL_UNLICENSED;
    private static final AtomicLong NUM_STATION_INDEX_EXECUTES;
    private static final AtomicLong TOTAL_STATION_INDEX_EXECUTE_TIME;
    private static volatile long minStationIndexExecuteTime;
    private static volatile String minIndexExecuteStation;
    private static volatile long maxStationIndexExecuteTime;
    private static volatile String maxIndexExecuteStation;

    @Generated
    public BRelTime getGlobalIndexTimeout() {
        return (BRelTime)this.get(globalIndexTimeout);
    }

    @Generated
    public void setGlobalIndexTimeout(BRelTime v) {
        this.set(globalIndexTimeout, (BValue)v, null);
    }

    @Generated
    public boolean getIncludeReachableStations() {
        return this.getBoolean(includeReachableStations);
    }

    @Generated
    public void setIncludeReachableStations(boolean v) {
        this.setBoolean(includeReachableStations, v, null);
    }

    @Generated
    public String getGlobalIndexLastResult() {
        return this.getString(globalIndexLastResult);
    }

    @Generated
    public void setGlobalIndexLastResult(String v) {
        this.setString(globalIndexLastResult, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeFullIndex(SystemIndexLog log, Context cx) throws Exception {
        BNiagaraNetworkSystemIndexer.checkServicesOperational((SystemIndexLog)log);
        long start = DiagnosticUtil.startIfLoggable((String)"systemIndexer_global_executeFull");
        try {
            this.indexStations(false, log, cx);
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"systemIndexer_global_executeFull");
        }
    }

    public boolean shouldRetryFailedIndexes(Context cx) {
        if (this.isUnoperational() || this.getState() != BDescriptorState.idle) {
            return false;
        }
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        List devices = network.getBDeviceList();
        for (BDevice device : devices) {
            BNiagaraStation station = (BNiagaraStation)device;
            SlotCursor props = station.getProperties();
            while (props.next(BNiagaraSystemIndexDeviceExt.class)) {
                BNiagaraSystemIndexDeviceExt deviceExt = (BNiagaraSystemIndexDeviceExt)props.get();
                if (!deviceExt.isFault() || deviceExt.isDown() || !deviceExt.canAcceptGlobalQueries(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG, true, cx) || deviceExt.getGlobalIndexFaultCause().equals(INDEX_EXPORT_ERROR_MSG)) continue;
                return true;
            }
        }
        if (this.getIncludeReachableStations()) {
            Map reachableStations = BReachableStations.findAllReachableStations((BObject)this, (boolean)false, (boolean)false, (boolean)false, (Version)BAbstractSystemIndexDeviceExt.VER_4_4, null, null, (String[])new String[0]);
            for (List infos : reachableStations.values()) {
                for (BReachableStationInfo info : infos) {
                    if (info.getReachableStationsContainer().getNiagaraStation().isDisabled() || info.getReachableStationsContainer().getNiagaraStation().isFatalFault()) continue;
                    SlotCursor props = info.getProperties();
                    while (props.next(BReachableStationSystemIndexDeviceExt.class)) {
                        BReachableStationSystemIndexDeviceExt deviceExt = (BReachableStationSystemIndexDeviceExt)props.get();
                        if (!deviceExt.isFault() || deviceExt.isDown() || deviceExt.getReachableStationStatus().isDown() || !deviceExt.getUsedByLastGlobalIndexAttempt() || !deviceExt.canAcceptGlobalQueries(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG, true, cx) || deviceExt.getGlobalIndexFaultCause().equals(INDEX_EXPORT_ERROR_MSG)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeFailedIndexes(SystemIndexLog log, Context cx) throws Exception {
        BNiagaraNetworkSystemIndexer.checkServicesOperational((SystemIndexLog)log);
        long start = DiagnosticUtil.startIfLoggable((String)"systemIndexer_global_executeFailed");
        try {
            this.indexStations(true, log, cx);
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"systemIndexer_global_executeFailed");
        }
    }

    private void indexStations(boolean onlyStationsInFault, SystemIndexLog log, Context cx) throws Exception {
        if (log.isLoggingEnabled()) {
            log.message("niagaraSystemIndex", "niagaraSystemIndex.job.moreDetails");
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        List<String> failedStations = Collections.synchronizedList(new ArrayList());
        AtomicInteger totalEligibleStations = new AtomicInteger();
        AtomicInteger totalSuccessful = new AtomicInteger();
        List<String> downStations = Collections.synchronizedList(new ArrayList());
        List<String> failedReachableStations = Collections.synchronizedList(new ArrayList());
        AtomicInteger totalEligibleReachableStations = new AtomicInteger();
        AtomicInteger totalSuccessfulReachables = new AtomicInteger();
        List<String> downReachableStations = Collections.synchronizedList(new ArrayList());
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        List devices = network.getBDeviceList();
        for (BDevice device : devices) {
            BNiagaraStation station = (BNiagaraStation)device;
            SlotCursor props = station.getProperties();
            while (props.next(BNiagaraSystemIndexDeviceExt.class)) {
                BNiagaraSystemIndexDeviceExt deviceExt = (BNiagaraSystemIndexDeviceExt)props.get();
                if (!deviceExt.canAcceptGlobalQueries(log, true, cx)) continue;
                this.indexSystemIndexDeviceExt(deviceExt, onlyStationsInFault, futures, failedStations, totalEligibleStations, totalSuccessful, downStations, log, cx);
            }
        }
        boolean includeReachables = this.getIncludeReachableStations();
        if (includeReachables) {
            Map reachableStations = BReachableStations.findAllReachableStations((BObject)this, (boolean)true, (boolean)true, (boolean)true, (Version)BAbstractSystemIndexDeviceExt.VER_4_4, null, null, (String[])new String[0]);
            for (List infos : reachableStations.values()) {
                BReachableStationSystemIndexDeviceExt bestActiveReachableStationDeviceExt = null;
                BReachableStationSystemIndexDeviceExt bestDownReachableStationDeviceExt = null;
                BReachableStationSystemIndexDeviceExt bestSecondaryReachableStationDeviceExt = null;
                for (BReachableStationInfo info : infos) {
                    boolean isInfoActive = info.getRouteEnabled() && !info.getReachableStationsContainer().isDisabled() && !info.getReachableStationsContainer().getNiagaraStation().isDisabled() && !info.getReachableStationsContainer().getNiagaraStation().isFatalFault() && !info.getVirtualSpaceOrd().isNull();
                    SlotCursor props = info.getProperties();
                    while (props.next(BReachableStationSystemIndexDeviceExt.class)) {
                        BReachableStationSystemIndexDeviceExt deviceExt = (BReachableStationSystemIndexDeviceExt)props.get();
                        if (isInfoActive && bestActiveReachableStationDeviceExt == null && deviceExt.canAcceptGlobalQueries(log, true, cx)) {
                            if (onlyStationsInFault) {
                                if (deviceExt.getUsedByLastGlobalIndexAttempt()) {
                                    if (deviceExt.isFault()) {
                                        bestActiveReachableStationDeviceExt = deviceExt;
                                        continue;
                                    }
                                    bestSecondaryReachableStationDeviceExt = deviceExt;
                                    continue;
                                }
                                if (bestSecondaryReachableStationDeviceExt == null && !deviceExt.isDown()) {
                                    bestSecondaryReachableStationDeviceExt = deviceExt;
                                } else if (bestDownReachableStationDeviceExt == null) {
                                    bestDownReachableStationDeviceExt = deviceExt;
                                }
                            } else {
                                if (!deviceExt.isDown()) {
                                    bestActiveReachableStationDeviceExt = deviceExt;
                                    continue;
                                }
                                if (bestDownReachableStationDeviceExt == null) {
                                    bestDownReachableStationDeviceExt = deviceExt;
                                }
                            }
                        }
                        deviceExt.setUsedByLastGlobalIndexAttempt(false);
                    }
                }
                BReachableStationSystemIndexDeviceExt deviceExt = bestActiveReachableStationDeviceExt != null ? bestActiveReachableStationDeviceExt : (bestSecondaryReachableStationDeviceExt != null ? bestSecondaryReachableStationDeviceExt : bestDownReachableStationDeviceExt);
                if (deviceExt == null) continue;
                deviceExt.setUsedByLastGlobalIndexAttempt(true);
                this.indexSystemIndexDeviceExt(deviceExt, onlyStationsInFault, futures, failedReachableStations, totalEligibleReachableStations, totalSuccessfulReachables, downReachableStations, log, cx);
            }
        }
        LocalizableRuntimeException timeoutException = null;
        if (!futures.isEmpty()) {
            CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            try {
                allDoneFuture.get(this.getGlobalIndexTimeout().getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                try {
                    allDoneFuture.cancel(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                timeoutException = new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.globalIndexTimeout", (Throwable)te);
            }
        }
        if (includeReachables) {
            String reachableDownText = BNiagaraNetworkSystemIndexer.getLexiconTextForStations(downReachableStations);
            if (!reachableDownText.isEmpty()) {
                reachableDownText = '\n' + lex.getText("niagaraSystemIndex.globalIndexDownReachables", new Object[]{reachableDownText});
            }
            String lastResult = lex.getText("niagaraSystemIndex.globalIndexStateText", new Object[]{totalSuccessful.get(), totalEligibleStations.get(), downStations.size()}) + "\n\n" + lex.getText("niagaraSystemIndex.globalIndexStateTextForReachables", new Object[]{totalSuccessfulReachables.get(), totalEligibleReachableStations.get(), downReachableStations.size(), reachableDownText});
            this.setGlobalIndexLastResult(lastResult);
        } else {
            this.setGlobalIndexLastResult(lex.getText("niagaraSystemIndex.globalIndexStateText", new Object[]{totalSuccessful.get(), totalEligibleStations.get(), downStations.size()}));
        }
        if (!failedStations.isEmpty() || !failedReachableStations.isEmpty()) {
            String niagaraStationFailures = BNiagaraNetworkSystemIndexer.getLexiconTextForStations(failedStations);
            if (includeReachables) {
                if (failedReachableStations.isEmpty()) {
                    throw new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.globalIndexFailure.directFailureReachableSuccess", new Object[]{failedStations.size(), totalEligibleStations.get(), downStations.size(), niagaraStationFailures, totalSuccessfulReachables.get(), totalEligibleReachableStations.get(), downReachableStations.size()});
                }
                String reachableStationFailures = BNiagaraNetworkSystemIndexer.getLexiconTextForStations(failedReachableStations);
                if (failedStations.isEmpty()) {
                    throw new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.globalIndexFailure.directSuccessReachableFailure", new Object[]{totalSuccessful.get(), totalEligibleStations.get(), downStations.size(), failedReachableStations.size(), totalEligibleReachableStations.get(), downReachableStations.size(), reachableStationFailures});
                }
                throw new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.globalIndexFailure.directFailureReachableFailure", new Object[]{failedStations.size(), totalEligibleStations.get(), downStations.size(), niagaraStationFailures, failedReachableStations.size(), totalEligibleReachableStations.get(), downReachableStations.size(), reachableStationFailures});
            }
            throw new LocalizableRuntimeException("niagaraSystemIndex", "niagaraSystemIndex.globalIndexFailure", new Object[]{failedStations.size(), totalEligibleStations.get(), downStations.size(), niagaraStationFailures});
        }
        if (timeoutException != null) {
            throw timeoutException;
        }
    }

    static CompletableFuture<Void> executeAsync(BSystemIndexService indexService, String deviceName, Runnable r) {
        return BNiagaraNetworkSystemIndexer.runAsync((BSystemIndexService)indexService, (String)deviceName, (Runnable)r);
    }

    private void indexSystemIndexDeviceExt(BAbstractSystemIndexDeviceExt deviceExt, boolean onlyStationsInFault, List<CompletableFuture<Void>> futures, List<String> failedStations, AtomicInteger totalEligibleStations, AtomicInteger totalSuccessful, List<String> downStations, SystemIndexLog log, Context cx) {
        String stationName = deviceExt.getStationName();
        totalEligibleStations.incrementAndGet();
        if (!onlyStationsInFault || deviceExt.isFault() && !deviceExt.getGlobalIndexFaultCause().equals(INDEX_EXPORT_ERROR_MSG)) {
            if (!deviceExt.isDown()) {
                deviceExt.executePending();
                SystemIndexLog stationLog = systemIndexJobLog.isLoggable(Level.FINE) ? SystemIndexLog.makeJobSystemIndexLog((BJob)new BSystemIndexJob(), (boolean)false) : SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG;
                CompletionStage future = BNiagaraNetworkSystemIndexer.runAsync((BSystemIndexService)this.getSystemIndexService(), (String)deviceExt.getDevice().getName(), () -> deviceExt.executeGlobalIndex(this.getOperationalIndexQueries(), stationLog, cx)).handle((r, t) -> {
                    SystemIndexLog systemIndexLog = log;
                    synchronized (systemIndexLog) {
                        log.combine(stationLog);
                    }
                    if (t != null) {
                        if (deviceExt.getReachableStationStatus().isDown()) {
                            downStations.add(stationName);
                            if (log.isLoggingEnabled()) {
                                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.down", new String[]{stationName});
                            }
                        } else {
                            Throwable cause;
                            Throwable throwable = cause = t instanceof LocalizableRuntimeException ? t : t.getCause();
                            if (cause instanceof LocalizableRuntimeException && "niagaraDriver".equals(((LocalizableRuntimeException)cause).getLexiconModule()) && "niagaraSystemIndex.illegalImportAndExport".equals(((LocalizableRuntimeException)cause).getLexiconKey())) {
                                totalEligibleStations.decrementAndGet();
                            } else {
                                failedStations.add(stationName);
                            }
                        }
                    } else {
                        totalSuccessful.incrementAndGet();
                    }
                    return r;
                });
                futures.add((CompletableFuture<Void>)future);
            } else {
                downStations.add(stationName);
                if (log.isLoggingEnabled()) {
                    log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.down", new String[]{stationName});
                }
            }
        } else if (deviceExt.isDown() || deviceExt.getReachableStationStatus().isDown()) {
            downStations.add(stationName);
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.down", new String[]{stationName});
            }
        } else if (deviceExt.getGlobalIndexFaultCause().equals(INDEX_EXPORT_ERROR_MSG)) {
            totalEligibleStations.decrementAndGet();
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexFailure.exportExists", new String[]{stationName});
            }
        } else {
            totalSuccessful.incrementAndGet();
            if (log.isLoggingEnabled()) {
                log.message("niagaraSystemIndex", "niagaraSystemIndex.indexSkipped.upToDate", new String[]{stationName});
            }
        }
    }

    private static String getLexiconTextForStations(List<String> stationNames) {
        if (stationNames.isEmpty()) {
            return "";
        }
        int numDown = stationNames.size();
        int max = Math.min(numDown, 5);
        StringJoiner joiner = new StringJoiner(", \n");
        for (int i = 0; i < max; ++i) {
            joiner.add(stationNames.get(i));
        }
        if (numDown > 5) {
            joiner.add(lex.getText("niagaraSystemIndex.globalIndexFailure.more", new Object[]{numDown - 5}));
        }
        return joiner.toString();
    }

    protected String getIndexDescription(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.globalIndexer");
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BNiagaraNetworkSystemIndexSource.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    public BIcon getIcon() {
        return icon;
    }

    protected String checkFatalFault() {
        for (String[] limitPair : LICENSE_LIMIT_PAIRS) {
            boolean isLicensed = true;
            for (String licenseLimit : limitPair) {
                int limit;
                try {
                    limit = LicenseUtil.parseLimit((Feature)this.getSystemIndexService().getLicenseFeature(), (String)licenseLimit);
                }
                catch (Exception e) {
                    limit = 0;
                }
                if (limit > 0) continue;
                isLicensed = false;
                break;
            }
            if (!isLicensed) continue;
            return null;
        }
        LOG.warning(() -> "Global Niagara Network System Indexer is unlicensed");
        return GLOBAL_UNLICENSED;
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"Global Niagara Network System Index Statistics", 2);
            long numStationIndexes = NUM_STATION_INDEX_EXECUTES.get();
            out.prop((Object)"Total index attempts on individual NiagaraStations by global initiation", (Object)String.valueOf(numStationIndexes));
            long totalStationIndexExecution = TOTAL_STATION_INDEX_EXECUTE_TIME.get();
            long avgIndexerExecute = numStationIndexes > 0L ? totalStationIndexExecution / numStationIndexes : 0L;
            out.prop((Object)"Avg individual NiagaraStation Index time by global initiation", (Object)BRelTime.make((long)avgIndexerExecute));
            long min = minStationIndexExecuteTime != Long.MAX_VALUE ? minStationIndexExecuteTime : 0L;
            out.prop((Object)"Min individual NiagaraStation Index time by global initiation", (Object)BRelTime.make((long)min));
            out.prop((Object)"Instance of Min NiagaraStation Index time by global initiation", (Object)minIndexExecuteStation);
            out.prop((Object)"Max individual NiagaraStation Index time by global initiation", (Object)BRelTime.make((long)maxStationIndexExecuteTime));
            out.prop((Object)"Instance of Max NiagaraStation Index time by global initiation", (Object)maxIndexExecuteStation);
            out.endProps();
        }
        super.spy(out);
    }

    static void updateStatistics(BComponent indexComponent, long duration) {
        NUM_STATION_INDEX_EXECUTES.incrementAndGet();
        TOTAL_STATION_INDEX_EXECUTE_TIME.addAndGet(duration);
        if (duration <= minStationIndexExecuteTime) {
            minStationIndexExecuteTime = duration;
            minIndexExecuteStation = indexComponent.toDisplayPathString(null);
        }
        if (duration >= maxStationIndexExecuteTime) {
            maxStationIndexExecuteTime = duration;
            maxIndexExecuteStation = indexComponent.toDisplayPathString(null);
        }
    }

    static {
        StringJoiner sj = new StringJoiner("\n");
        for (Object[] objectArray : LICENSE_LIMIT_PAIRS) {
            sj.add(ArrayUtil.join((Object[])objectArray, (String)", "));
        }
        LEXICON_ARG = sj.toString();
        GLOBAL_UNLICENSED = lex.getText("niagaraSystemIndex.globalIndexUnlicensed", new Object[]{LEXICON_ARG});
        NUM_STATION_INDEX_EXECUTES = new AtomicLong();
        TOTAL_STATION_INDEX_EXECUTE_TIME = new AtomicLong();
        minStationIndexExecuteTime = Long.MAX_VALUE;
        minIndexExecuteStation = "none";
        maxIndexExecuteStation = "none";
    }
}

