/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils.auth;

import com.tridium.awsUtils.AwsUtils;
import com.tridium.awsUtils.BAwsService;
import com.tridium.awsUtils.auth.AwsAccessCredentials;
import com.tridium.awsUtils.auth.AwsAuthException;
import com.tridium.awsUtils.auth.BAwsAccessKey;
import com.tridium.awsUtils.auth.BAwsStoredAccessKey;
import com.tridium.awsUtils.auth.IAccessKeyIdSupplier;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.KeyRingFactory;
import com.tridium.nre.security.SecretChars;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public final class AwsAuthUtils {
    private static final File KEY_RING_DIR = new File(Sys.getNiagaraUserHome() + File.separator + "security" + File.separator + "awsUtils" + File.separator);
    private static final Lexicon LEX = Lexicon.make(AwsAuthUtils.class);
    private static final Object SYNC = new Object();
    private static final String KEY_PREFIX = "aws";
    private static KeyRing keyRing;
    public static final Logger LOG;

    private AwsAuthUtils() {
    }

    public static BAwsStoredAccessKey saveToKeyRing(BAwsAccessKey accessKey) throws AwsAuthException {
        KeyRing keyRing = AwsAuthUtils.getAwsKeyRing();
        String accessKeyValue = AccessController.doPrivileged(() -> ((BPassword)accessKey.getAccessKey()).getValue());
        if (accessKeyValue == null || accessKeyValue.isEmpty()) {
            throw new AwsAuthException(LEX.getText("missing.keyring.value"));
        }
        try {
            String alias = AwsAuthUtils.getKeyRingAlias(accessKey);
            keyRing.setKey(alias, accessKeyValue.getBytes(StandardCharsets.UTF_8), false);
        }
        catch (Exception e) {
            throw new AwsAuthException(LEX.getText("failed.keyring.entry"), e);
        }
        BAwsStoredAccessKey stored = new BAwsStoredAccessKey();
        stored.setAccessKeyId(accessKey.getAccessKeyId());
        stored.setStored(true);
        return stored;
    }

    public static String loadFromKeyRing(BAwsStoredAccessKey stored) throws AwsAuthException {
        AwsUtils.checkAwsPermission();
        KeyRing keyRing = AwsAuthUtils.getAwsKeyRing();
        String accessKeyId = AwsAuthUtils.getKeyRingAlias(stored);
        try {
            byte[] value = keyRing.getKey(accessKeyId);
            if (value != null) {
                return new String(value, StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            throw new AwsAuthException(LEX.getText("missing.keyring.entry", new Object[]{accessKeyId}));
        }
        throw new AwsAuthException(LEX.getText("missing.keyring.entry", new Object[]{accessKeyId}));
    }

    public static void purge(BAwsStoredAccessKey storedAccessKey) {
        try {
            AwsAuthUtils.removeFromKeyRing(storedAccessKey);
            storedAccessKey.setStored(false);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to purge Access Key: " + storedAccessKey.getAccessKeyId(), e);
        }
    }

    public static void removeFromKeyRing(BAwsStoredAccessKey stored) throws Exception {
        AwsAuthUtils.removeFromKeyRing(AwsAuthUtils.getKeyRingAlias(stored));
    }

    public static void removeFromKeyRing(String alias) throws Exception {
        KeyRing keyRing = AwsAuthUtils.getAwsKeyRing();
        keyRing.removeKey(alias);
    }

    public static void rollKeyMaterial(long maxAge) {
        try {
            KeyRing keyRing = AwsAuthUtils.getAwsKeyRing();
            AccessController.doPrivileged(() -> keyRing.checkRollKeyMaterial(maxAge));
        }
        catch (AwsAuthException e) {
            LOG.log(Level.SEVERE, "Failed to check awsUtils key material", e);
        }
    }

    private static String getKeyRingAlias(Object obj) throws AwsAuthException {
        String accessKeyId = null;
        if (obj instanceof IAccessKeyIdSupplier) {
            accessKeyId = ((IAccessKeyIdSupplier)obj).getAccessKeyId();
        }
        if (accessKeyId == null || accessKeyId.isEmpty()) {
            throw new AwsAuthException(LEX.getText("missing.keyring.accessKeyId"));
        }
        return "aws." + accessKeyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyRing getAwsKeyRing() throws AwsAuthException {
        Object object = SYNC;
        synchronized (object) {
            if (keyRing == null) {
                try {
                    keyRing = AccessController.doPrivileged(() -> KeyRingFactory.getInstance((File)KEY_RING_DIR, (String)".awsUtils.kr", (String)".km").getKeyRing());
                }
                catch (Exception e) {
                    throw new AwsAuthException("Failed to load AWS keyring", e);
                }
            }
            return keyRing;
        }
    }

    public static AwsAccessCredentials getCredentials(String region, String accessKeyId, Context cx) throws AwsAuthException {
        AwsUtils.checkAwsPermission();
        if (accessKeyId == null || accessKeyId.isEmpty()) {
            throw new AwsAuthException(LEX.getText("missing.keyring.accessKeyId"));
        }
        Optional<BAwsStoredAccessKey> accessKey = AwsAuthUtils.lookupAccessKey(accessKeyId, cx);
        if (!accessKey.isPresent()) {
            throw new AwsAuthException(LEX.getText("missing.keyring.entry", new Object[]{accessKeyId}));
        }
        return new AwsAccessCredentials(accessKey.get().getAccessKeyId(), new SecretChars(AwsAuthUtils.loadFromKeyRing(accessKey.get()).toCharArray(), true), region);
    }

    private static Optional<BAwsStoredAccessKey> lookupAccessKey(String accessKeyId, Context cx) {
        BAwsService service = (BAwsService)Sys.getService((Type)BAwsService.TYPE).as(BAwsService.class);
        if (cx != null && cx.getUser().getPermissionsFor((BIProtected)service).hasAdminRead()) {
            return Arrays.stream(service.getAccessKeys().getChildren(BAwsStoredAccessKey.class)).filter(key -> key.getAccessKeyId().equals(accessKeyId)).findFirst();
        }
        return Optional.empty();
    }

    static {
        LOG = Logger.getLogger("awsAuth");
    }
}

