/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils.auth;

import com.tridium.awsUtils.BAwsService;
import com.tridium.awsUtils.auth.BAwsStoredAccessKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
public final class BAwsAuthRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BAwsAuthRpc.class);
    public static final String ACCESS_KEY_IDS = "getAccessKeyIds";

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox), @Transport(type=TransportType.box)})
    public static List<String> getAccessKeyIds(Context cx) {
        try {
            BUser contextUser;
            BAwsService awsService = (BAwsService)Sys.getService((Type)BAwsService.TYPE).as(BAwsService.class);
            BUser bUser = contextUser = cx != null ? cx.getUser() : null;
            if (contextUser == null || !contextUser.getPermissionsFor((BIProtected)awsService).hasAdminRead()) {
                BAwsService.AWS_LOG.warning("User does not have read permissions on the AWS Service");
                return Collections.emptyList();
            }
            return Arrays.stream(awsService.getAccessKeys().getChildren(BAwsStoredAccessKey.class)).filter(accessKey -> contextUser.getPermissionsFor((BIProtected)accessKey).hasAdminRead()).map(accessKey -> accessKey.getAccessKeyId()).collect(Collectors.toList());
        }
        catch (ServiceNotFoundException e) {
            throw new IllegalArgumentException("No AwsService found on station");
        }
    }
}

