/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils.rest;

import com.tridium.awsUtils.AwsUtils;
import com.tridium.awsUtils.BAwsService;
import com.tridium.awsUtils.auth.AwsAccessCredentials;
import com.tridium.awsUtils.rest.AwsRestException;
import com.tridium.awsUtils.rest.requests.AwsV4SignedHttpRequestFactory;
import com.tridium.awsUtils.rest.requests.IAwsRequest;
import com.tridium.crypto.core.cert.DefaultExemptionApprover;
import com.tridium.crypto.core.cert.NoOpHostnameVerifier;
import com.tridium.crypto.core.io.CoreClientTrustManager;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.spy.SpyWriter;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class AwsRestClient {
    private final AwsAccessCredentials credentials;
    private static ExecutorService executor;
    private static OkHttpClient baseClient;
    private static final Object SYNC;
    private static final AtomicInteger requestCount;
    private static final AtomicInteger goodCount;
    private static final AtomicInteger failedCount;
    private static final AtomicInteger timedOutCount;
    private static final AtomicInteger badResponseCount;
    private static final String REQUEST_TIMEOUT_PROP = "aws.rest.timeout.millis";
    private static final int REQUEST_TIMEOUT_MILLIS;

    public AwsRestClient(AwsAccessCredentials credentials) {
        this.credentials = credentials;
        AwsRestClient.createExecutor();
    }

    public Optional<String> send(IAwsRequest requestParams) throws AwsRestException {
        AwsUtils.checkAwsPermission();
        try {
            Future<Optional> future = executor.submit(() -> {
                Request request = new AwsV4SignedHttpRequestFactory(this.credentials, requestParams).buildRequest();
                OkHttpClient requestSpecificClient = AwsRestClient.getHttpClient();
                String responseBody = AwsRestClient.send(requestParams, request, requestSpecificClient);
                goodCount.incrementAndGet();
                return Optional.ofNullable(responseBody);
            });
            Optional optional = future.get(REQUEST_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
            return optional;
        }
        catch (InterruptedException | ExecutionException e) {
            failedCount.incrementAndGet();
            if (e.getCause() instanceof AwsRestException) {
                throw (AwsRestException)e.getCause();
            }
            throw new AwsRestException(BAwsService.LEX.getText("aws.rest.failed"), requestParams, e);
        }
        catch (TimeoutException e) {
            timedOutCount.incrementAndGet();
            throw new AwsRestException(BAwsService.LEX.getText("aws.rest.timeout"), requestParams, e);
        }
        finally {
            requestCount.incrementAndGet();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String send(IAwsRequest requestParams, Request request, OkHttpClient requestSpecificClient) throws AwsRestException {
        try (Response response = requestSpecificClient.newCall(request).execute();){
            String body = response.body() != null ? response.body().string() : "";
            int respCode = response.code();
            if (BAwsService.AWS_LOG.isLoggable(Level.FINE)) {
                BAwsService.AWS_LOG.fine(BAwsService.LEX.getText("aws.rest.resp", new Object[]{requestParams.getDescriptionForLogs(), respCode}));
                if (!body.isEmpty()) {
                    String logSafe = body.substring(0, Math.min(body.length(), 10));
                    BAwsService.AWS_LOG.fine(BAwsService.LEX.getText("aws.rest.body", new Object[]{body.length(), logSafe, respCode}));
                }
            }
            if (respCode >= 300) {
                badResponseCount.incrementAndGet();
                String awsMessage = AwsRestClient.extractAwsErrorMessage(body);
                throw new AwsRestException(BAwsService.LEX.getText("aws.rest.resp.bad", new Object[]{awsMessage.isEmpty() ? BAwsService.LEX.getText("aws.rest.resp.unknown") : awsMessage}), respCode, requestParams);
            }
            String string = body;
            return string;
        }
        catch (IOException e) {
            throw new AwsRestException(BAwsService.LEX.getText("aws.rest.failed"), requestParams, e);
        }
    }

    private static OkHttpClient getHttpClient() throws PrivilegedActionException {
        return AccessController.doPrivileged(() -> {
            Object object = SYNC;
            synchronized (object) {
                if (baseClient == null) {
                    baseClient = new OkHttpClient.Builder().build();
                }
            }
            OkHttpClient.Builder clientBuilder = baseClient.newBuilder();
            try {
                ISecurityInfoProvider secInfo = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
                CoreClientTrustManager trustManager = CoreClientTrustManager.make((ISecurityInfoProvider)secInfo, () -> new DefaultExemptionApprover());
                clientBuilder.sslSocketFactory(AwsRestClient.getSocketFactory(), (X509TrustManager)trustManager).hostnameVerifier((HostnameVerifier)new NoOpHostnameVerifier());
            }
            catch (IOException e) {
                throw new IOException("Failed to initialize socket factory", e);
            }
            return clientBuilder.build();
        });
    }

    private static SSLSocketFactory getSocketFactory() throws IOException {
        try {
            ICryptoManager cryptoManager = CertManagerFactory.getInstance();
            return (SSLSocketFactory)cryptoManager.getClientSocketFactory(ClientTlsParameters.DEFAULT);
        }
        catch (Exception e) {
            throw new IOException("Unable to get client socket factory: " + e.getMessage());
        }
    }

    public static void resetCounts() {
        Stream.of(requestCount, goodCount, failedCount, timedOutCount, badResponseCount).forEach(counter -> counter.set(0));
    }

    public static void appendCounts(SpyWriter out) {
        out.startProps("AWS REST API Usage Metrics (since last restart)");
        out.prop((Object)"Request Count", requestCount.get());
        out.prop((Object)"Good Count", goodCount.get());
        out.prop((Object)"Failed to send Count", failedCount.get());
        out.prop((Object)"Timed Out Count", timedOutCount.get());
        out.prop((Object)"Bad Response Count", badResponseCount.get());
        out.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = SYNC;
        synchronized (object) {
            if (executor != null) {
                executor.shutdown();
                executor = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createExecutor() {
        Object object = SYNC;
        synchronized (object) {
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "AwsRestSender"));
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (executor != null) {
                        executor.shutdown();
                    }
                }));
            }
        }
    }

    private static String extractAwsErrorMessage(String message) {
        try {
            JSONObject json = new JSONObject(message);
            return json.getString("message");
        }
        catch (JSONException e) {
            return message;
        }
    }

    static {
        SYNC = new Object();
        requestCount = new AtomicInteger();
        goodCount = new AtomicInteger();
        failedCount = new AtomicInteger();
        timedOutCount = new AtomicInteger();
        badResponseCount = new AtomicInteger();
        REQUEST_TIMEOUT_MILLIS = Integer.parseInt(AccessController.doPrivileged(() -> System.getProperty(REQUEST_TIMEOUT_PROP, String.valueOf(10000))));
    }
}

