/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils.rest.requests;

import com.tridium.awsUtils.BAwsService;
import com.tridium.awsUtils.rest.requests.IIoTAwsRequest;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.json.JSONWriter;
import java.util.logging.Level;
import javax.baja.nre.security.IX509CertificateEntry;

public class AwsRegisterCaCertRequest
implements IIoTAwsRequest {
    private static final String provisioningTemplate = "{ \"Parameters\" : { \"AWS::IoT::Certificate::Country\" : { \"Type\" : \"String\" }, \"AWS::IoT::Certificate::Id\" : { \"Type\" : \"String\" }, \"AWS::IoT::Certificate::CommonName\" : { \"Type\" : \"String\" } }, \"Resources\" : { \"thing\" : { \"Type\" : \"AWS::IoT::Thing\", \"Properties\" : { \"ThingName\" : {\"Ref\" : \"AWS::IoT::Certificate::CommonName\"}, \"AttributePayload\" : { \"version\" : \"v1\", \"country\" : {\"Ref\" : \"AWS::IoT::Certificate::Country\"}} } }, \"certificate\" : { \"Type\" : \"AWS::IoT::Certificate\", \"Properties\" : { \"CertificateId\": {\"Ref\" : \"AWS::IoT::Certificate::Id\"},\"Status\" : \"ACTIVE\"} }, \"policy\" : {\"Type\" : \"AWS::IoT::Policy\", \"Properties\" : { \"PolicyDocument\" : \"{\\\"Version\\\": \\\"2012-10-17\\\",\\\"Statement\\\": [{\\\"Effect\\\":\\\"Allow\\\",\\\"Action\\\": [\\\"iot:Connect\\\",\\\"iot:Publish\\\",\\\"iot:Subscribe\\\",\\\"iot:Receive\\\",\\\"iot:GetRetainedMessage\\\",\\\"iot:ListRetainedMessages\\\",\\\"iot:RetainPublish\\\"],\\\"Resource\\\" : [\\\"*\\\"]}]}\" } } } }";
    private final IX509CertificateEntry caCert;
    private final NX509Certificate signedVerificationCert;
    private final String roleArn;

    public AwsRegisterCaCertRequest(IX509CertificateEntry caCert, NX509Certificate signedVerificationCert, String roleArn) {
        this.caCert = caCert;
        this.signedVerificationCert = signedVerificationCert;
        this.roleArn = roleArn;
    }

    @Override
    public String getDescriptionForLogs() {
        return "CA Certificate Registration";
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public String getRequestPath() {
        return "/cacertificate";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPayload() {
        StringBuilder json = new StringBuilder();
        JSONWriter jsonWriter = new JSONWriter((Appendable)json);
        try {
            jsonWriter.object().key("caCertificate").value((Object)this.caCert.getCertificate(0).encodeToString()).key("registrationConfig").object().key("roleArn").value((Object)this.roleArn).key("templateBody").value((Object)provisioningTemplate).endObject().key("tags").array().object().key("Key").value((Object)"CreatedBy").key("Value").value((Object)"NiagaraJITP").endObject().endArray().key("verificationCertificate").value((Object)this.signedVerificationCert.encodeToString());
        }
        catch (Exception e) {
            BAwsService.AWS_LOG.log(Level.SEVERE, "Failed to encode certificate value in payload of " + this.getDescriptionForLogs(), e);
        }
        finally {
            jsonWriter.endObject();
        }
        return json.toString();
    }

    @Override
    public String getCanonicalQueryString() {
        return "allowAutoRegistration=true&setAsActive=true";
    }
}

