/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.ccn.BCcnDeviceFolder;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnByteList;
import com.tridium.ccn.components.BCcnControllerEntry;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTableList;
import com.tridium.ccn.enums.BCcnBaudRateEnum;
import com.tridium.ccn.enums.BCcnDeviceTypeEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import com.tridium.ccn.job.BCcnAddTablesJob;
import com.tridium.ccn.job.BCcnLearnTablesJob;
import com.tridium.ccn.messages.CcnFetchDeviceDataRequest;
import com.tridium.ccn.messages.CcnPointConfigDownloadRequest;
import com.tridium.ccn.messages.CcnPointConfigUploadRequest;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnRequestMessage;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnPointDeviceExt;
import com.tridium.ccn.tables.BCcnAHTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.CcnAlarmUtil;
import com.tridium.ccn.util.CcnRspDTUtil;
import com.tridium.ccn.util.CcnRspDevUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.platCcn.CcnDataWrapper;
import com.tridium.platCcn.CcnTableDef;
import com.tridium.platCcn.CcnUnsolicitedMsg;
import java.util.HashMap;
import java.util.Vector;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BDownloadParameters;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="busNo", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(0, 238)")}), @NiagaraProperty(name="elemNo", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(0, 238)")}), @NiagaraProperty(name="deviceName", type="String", defaultValue="CcnDevice"), @NiagaraProperty(name="duplicateDeviceName", type="String", defaultValue="CcnDevice", flags=4), @NiagaraProperty(name="picType", type="String", defaultValue="", flags=65), @NiagaraProperty(name="applicationVersion", type="String", defaultValue="", flags=65), @NiagaraProperty(name="deviceStatus", type="String", defaultValue="BCcnDevice.OFFLINE", flags=1), @NiagaraProperty(name="deviceDescription", type="String", defaultValue=" ", flags=65), @NiagaraProperty(name="location", type="String", defaultValue="", flags=65), @NiagaraProperty(name="partNo", type="String", defaultValue="", flags=65), @NiagaraProperty(name="modelNo", type="String", defaultValue="", flags=65), @NiagaraProperty(name="serialNo", type="String", defaultValue="", flags=65), @NiagaraProperty(name="referenceNo", type="String", defaultValue="", flags=65), @NiagaraProperty(name="platformNo", type="String", defaultValue="", flags=65), @NiagaraProperty(name="osVersion", type="String", defaultValue="", flags=65), @NiagaraProperty(name="deviceType", type="BCcnDeviceTypeEnum", defaultValue="BCcnDeviceTypeEnum.Unknown", flags=1), @NiagaraProperty(name="primaryBaudRate", type="BCcnBaudRateEnum", defaultValue="BCcnBaudRateEnum.Baud9600", flags=65), @NiagaraProperty(name="secondaryBaudRate", type="BCcnBaudRateEnum", defaultValue="BCcnBaudRateEnum.Baud9600", flags=65), @NiagaraProperty(name="maxTableNumber", type="int", defaultValue="0", flags=64, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0))")}), @NiagaraProperty(name="tableLearnCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="learnStatus", type="String", defaultValue="Idle", flags=1), @NiagaraProperty(name="tableCreateCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="deviceTime", type="BAbsTime", defaultValue="BAbsTime.make()", flags=65), @NiagaraProperty(name="devicePingStatus", type="String", defaultValue="", flags=65), @NiagaraProperty(name="overWriteEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="lrnUsrCfgPic10", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnStaDspPic11", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnMaintPic12", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnSvcCfgPic13", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnUsrCfgPoc14", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnMaintPoc15", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnSvcCfgPoc16", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnSetPtsPic17", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnSetPtsPoc18", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnAlmHstPic43", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnTimSchDTT614", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnStaDspTT500", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnTimSchTT503", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnSetPtsTT504", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="lrnHolSchTT505", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="isEnhancedVersion", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="statusDisplay", type="boolean", defaultValue="true"), @NiagaraProperty(name="userConfiguration", type="boolean", defaultValue="true"), @NiagaraProperty(name="maintenance", type="boolean", defaultValue="true"), @NiagaraProperty(name="serviceConfiguration", type="boolean", defaultValue="true"), @NiagaraProperty(name="setPoints", type="boolean", defaultValue="true"), @NiagaraProperty(name="timeSchedules", type="boolean", defaultValue="true"), @NiagaraProperty(name="alarmHistory", type="boolean", defaultValue="true"), @NiagaraProperty(name="holiday", type="boolean", defaultValue="true"), @NiagaraProperty(name="learnedTables", type="BFolder", defaultValue="new BFolder()", flags=7), @NiagaraProperty(name="points", type="BCcnPointDeviceExt", defaultValue="new BCcnPointDeviceExt()"), @NiagaraProperty(name="pollProxyExtCount", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="tableAccessRights", type="BCcnByteList", defaultValue="new BCcnByteList()", flags=4), @NiagaraProperty(name="minimumWriteInterval", type="long", defaultValue="60000")})
@NiagaraActions(value={@NiagaraAction(name="submitTableDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="submitAddTablesJob", parameterType="BCcnTableList", defaultValue="new BCcnTableList()", returnType="BOrd", flags=4), @NiagaraAction(name="fetch")})
public class BCcnDevice
extends BBasicDevice {
    @Generated
    public static final Property busNo = BCcnDevice.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)238));
    @Generated
    public static final Property elemNo = BCcnDevice.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((int)0, (int)238));
    @Generated
    public static final Property deviceName = BCcnDevice.newProperty((int)0, (String)"CcnDevice", null);
    @Generated
    public static final Property duplicateDeviceName = BCcnDevice.newProperty((int)4, (String)"CcnDevice", null);
    @Generated
    public static final Property picType = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property applicationVersion = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property deviceStatus = BCcnDevice.newProperty((int)1, (String)"Off-Line", null);
    @Generated
    public static final Property deviceDescription = BCcnDevice.newProperty((int)65, (String)" ", null);
    @Generated
    public static final Property location = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property partNo = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property modelNo = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property serialNo = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property referenceNo = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property platformNo = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property osVersion = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property deviceType = BCcnDevice.newProperty((int)1, (BValue)BCcnDeviceTypeEnum.Unknown, null);
    @Generated
    public static final Property primaryBaudRate = BCcnDevice.newProperty((int)65, (BValue)BCcnBaudRateEnum.Baud9600, null);
    @Generated
    public static final Property secondaryBaudRate = BCcnDevice.newProperty((int)65, (BValue)BCcnBaudRateEnum.Baud9600, null);
    @Generated
    public static final Property maxTableNumber = BCcnDevice.newProperty((int)64, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property tableLearnCount = BCcnDevice.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property learnStatus = BCcnDevice.newProperty((int)1, (String)"Idle", null);
    @Generated
    public static final Property tableCreateCount = BCcnDevice.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property deviceTime = BCcnDevice.newProperty((int)65, (BValue)BAbsTime.make(), null);
    @Generated
    public static final Property devicePingStatus = BCcnDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property overWriteEnabled = BCcnDevice.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property lrnUsrCfgPic10 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnStaDspPic11 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnMaintPic12 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnSvcCfgPic13 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnUsrCfgPoc14 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnMaintPoc15 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnSvcCfgPoc16 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnSetPtsPic17 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnSetPtsPoc18 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnAlmHstPic43 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnTimSchDTT614 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnStaDspTT500 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnTimSchTT503 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnSetPtsTT504 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property lrnHolSchTT505 = BCcnDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property isEnhancedVersion = BCcnDevice.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property statusDisplay = BCcnDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property userConfiguration = BCcnDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property maintenance = BCcnDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property serviceConfiguration = BCcnDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property setPoints = BCcnDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property timeSchedules = BCcnDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property alarmHistory = BCcnDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property holiday = BCcnDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property learnedTables = BCcnDevice.newProperty((int)7, (BValue)new BFolder(), null);
    @Generated
    public static final Property points = BCcnDevice.newProperty((int)0, (BValue)new BCcnPointDeviceExt(), null);
    @Generated
    public static final Property pollProxyExtCount = BCcnDevice.newProperty((int)4, (int)0, null);
    @Generated
    public static final Property tableAccessRights = BCcnDevice.newProperty((int)4, (BValue)new BCcnByteList(), null);
    @Generated
    public static final Property minimumWriteInterval = BCcnDevice.newProperty((int)0, (int)60000, null);
    @Generated
    public static final Action submitTableDiscoveryJob = BCcnDevice.newAction((int)4, null);
    @Generated
    public static final Action submitAddTablesJob = BCcnDevice.newAction((int)4, (BValue)new BCcnTableList(), null);
    @Generated
    public static final Action fetch = BCcnDevice.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnDevice.class);
    BCcnControllerEntry entry;
    BCcnDeviceFolder devFolder;
    BCcnNetwork objNetwork;
    private Vector<BCcnTable> vTable;
    private boolean abort;
    private BAlarmService alarmServ;
    private static final String OFFLINE = "Off-Line";
    private static final String ONLINE = "On-Line";
    private static final boolean pingForTimeAsOpposedToDate = true;
    private static final BIcon icon = BIcon.std((String)"device.png");
    private static final Log ccnNetworkLog = Log.getLog((String)"CCNNetworkLog");

    @Generated
    public int getBusNo() {
        return this.getInt(busNo);
    }

    @Generated
    public void setBusNo(int v) {
        this.setInt(busNo, v, null);
    }

    @Generated
    public int getElemNo() {
        return this.getInt(elemNo);
    }

    @Generated
    public void setElemNo(int v) {
        this.setInt(elemNo, v, null);
    }

    @Generated
    public String getDeviceName() {
        return this.getString(deviceName);
    }

    @Generated
    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    @Generated
    public String getDuplicateDeviceName() {
        return this.getString(duplicateDeviceName);
    }

    @Generated
    public void setDuplicateDeviceName(String v) {
        this.setString(duplicateDeviceName, v, null);
    }

    @Generated
    public String getPicType() {
        return this.getString(picType);
    }

    @Generated
    public void setPicType(String v) {
        this.setString(picType, v, null);
    }

    @Generated
    public String getApplicationVersion() {
        return this.getString(applicationVersion);
    }

    @Generated
    public void setApplicationVersion(String v) {
        this.setString(applicationVersion, v, null);
    }

    @Generated
    public String getDeviceStatus() {
        return this.getString(deviceStatus);
    }

    @Generated
    public void setDeviceStatus(String v) {
        this.setString(deviceStatus, v, null);
    }

    @Generated
    public String getDeviceDescription() {
        return this.getString(deviceDescription);
    }

    @Generated
    public void setDeviceDescription(String v) {
        this.setString(deviceDescription, v, null);
    }

    @Generated
    public String getLocation() {
        return this.getString(location);
    }

    @Generated
    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    @Generated
    public String getPartNo() {
        return this.getString(partNo);
    }

    @Generated
    public void setPartNo(String v) {
        this.setString(partNo, v, null);
    }

    @Generated
    public String getModelNo() {
        return this.getString(modelNo);
    }

    @Generated
    public void setModelNo(String v) {
        this.setString(modelNo, v, null);
    }

    @Generated
    public String getSerialNo() {
        return this.getString(serialNo);
    }

    @Generated
    public void setSerialNo(String v) {
        this.setString(serialNo, v, null);
    }

    @Generated
    public String getReferenceNo() {
        return this.getString(referenceNo);
    }

    @Generated
    public void setReferenceNo(String v) {
        this.setString(referenceNo, v, null);
    }

    @Generated
    public String getPlatformNo() {
        return this.getString(platformNo);
    }

    @Generated
    public void setPlatformNo(String v) {
        this.setString(platformNo, v, null);
    }

    @Generated
    public String getOsVersion() {
        return this.getString(osVersion);
    }

    @Generated
    public void setOsVersion(String v) {
        this.setString(osVersion, v, null);
    }

    @Generated
    public BCcnDeviceTypeEnum getDeviceType() {
        return (BCcnDeviceTypeEnum)this.get(deviceType);
    }

    @Generated
    public void setDeviceType(BCcnDeviceTypeEnum v) {
        this.set(deviceType, (BValue)v, null);
    }

    @Generated
    public BCcnBaudRateEnum getPrimaryBaudRate() {
        return (BCcnBaudRateEnum)this.get(primaryBaudRate);
    }

    @Generated
    public void setPrimaryBaudRate(BCcnBaudRateEnum v) {
        this.set(primaryBaudRate, (BValue)v, null);
    }

    @Generated
    public BCcnBaudRateEnum getSecondaryBaudRate() {
        return (BCcnBaudRateEnum)this.get(secondaryBaudRate);
    }

    @Generated
    public void setSecondaryBaudRate(BCcnBaudRateEnum v) {
        this.set(secondaryBaudRate, (BValue)v, null);
    }

    @Generated
    public int getMaxTableNumber() {
        return this.getInt(maxTableNumber);
    }

    @Generated
    public void setMaxTableNumber(int v) {
        this.setInt(maxTableNumber, v, null);
    }

    @Generated
    public int getTableLearnCount() {
        return this.getInt(tableLearnCount);
    }

    @Generated
    public void setTableLearnCount(int v) {
        this.setInt(tableLearnCount, v, null);
    }

    @Generated
    public String getLearnStatus() {
        return this.getString(learnStatus);
    }

    @Generated
    public void setLearnStatus(String v) {
        this.setString(learnStatus, v, null);
    }

    @Generated
    public int getTableCreateCount() {
        return this.getInt(tableCreateCount);
    }

    @Generated
    public void setTableCreateCount(int v) {
        this.setInt(tableCreateCount, v, null);
    }

    @Generated
    public BAbsTime getDeviceTime() {
        return (BAbsTime)this.get(deviceTime);
    }

    @Generated
    public void setDeviceTime(BAbsTime v) {
        this.set(deviceTime, (BValue)v, null);
    }

    @Generated
    public String getDevicePingStatus() {
        return this.getString(devicePingStatus);
    }

    @Generated
    public void setDevicePingStatus(String v) {
        this.setString(devicePingStatus, v, null);
    }

    @Generated
    public boolean getOverWriteEnabled() {
        return this.getBoolean(overWriteEnabled);
    }

    @Generated
    public void setOverWriteEnabled(boolean v) {
        this.setBoolean(overWriteEnabled, v, null);
    }

    @Generated
    public boolean getLrnUsrCfgPic10() {
        return this.getBoolean(lrnUsrCfgPic10);
    }

    @Generated
    public void setLrnUsrCfgPic10(boolean v) {
        this.setBoolean(lrnUsrCfgPic10, v, null);
    }

    @Generated
    public boolean getLrnStaDspPic11() {
        return this.getBoolean(lrnStaDspPic11);
    }

    @Generated
    public void setLrnStaDspPic11(boolean v) {
        this.setBoolean(lrnStaDspPic11, v, null);
    }

    @Generated
    public boolean getLrnMaintPic12() {
        return this.getBoolean(lrnMaintPic12);
    }

    @Generated
    public void setLrnMaintPic12(boolean v) {
        this.setBoolean(lrnMaintPic12, v, null);
    }

    @Generated
    public boolean getLrnSvcCfgPic13() {
        return this.getBoolean(lrnSvcCfgPic13);
    }

    @Generated
    public void setLrnSvcCfgPic13(boolean v) {
        this.setBoolean(lrnSvcCfgPic13, v, null);
    }

    @Generated
    public boolean getLrnUsrCfgPoc14() {
        return this.getBoolean(lrnUsrCfgPoc14);
    }

    @Generated
    public void setLrnUsrCfgPoc14(boolean v) {
        this.setBoolean(lrnUsrCfgPoc14, v, null);
    }

    @Generated
    public boolean getLrnMaintPoc15() {
        return this.getBoolean(lrnMaintPoc15);
    }

    @Generated
    public void setLrnMaintPoc15(boolean v) {
        this.setBoolean(lrnMaintPoc15, v, null);
    }

    @Generated
    public boolean getLrnSvcCfgPoc16() {
        return this.getBoolean(lrnSvcCfgPoc16);
    }

    @Generated
    public void setLrnSvcCfgPoc16(boolean v) {
        this.setBoolean(lrnSvcCfgPoc16, v, null);
    }

    @Generated
    public boolean getLrnSetPtsPic17() {
        return this.getBoolean(lrnSetPtsPic17);
    }

    @Generated
    public void setLrnSetPtsPic17(boolean v) {
        this.setBoolean(lrnSetPtsPic17, v, null);
    }

    @Generated
    public boolean getLrnSetPtsPoc18() {
        return this.getBoolean(lrnSetPtsPoc18);
    }

    @Generated
    public void setLrnSetPtsPoc18(boolean v) {
        this.setBoolean(lrnSetPtsPoc18, v, null);
    }

    @Generated
    public boolean getLrnAlmHstPic43() {
        return this.getBoolean(lrnAlmHstPic43);
    }

    @Generated
    public void setLrnAlmHstPic43(boolean v) {
        this.setBoolean(lrnAlmHstPic43, v, null);
    }

    @Generated
    public boolean getLrnTimSchDTT614() {
        return this.getBoolean(lrnTimSchDTT614);
    }

    @Generated
    public void setLrnTimSchDTT614(boolean v) {
        this.setBoolean(lrnTimSchDTT614, v, null);
    }

    @Generated
    public boolean getLrnStaDspTT500() {
        return this.getBoolean(lrnStaDspTT500);
    }

    @Generated
    public void setLrnStaDspTT500(boolean v) {
        this.setBoolean(lrnStaDspTT500, v, null);
    }

    @Generated
    public boolean getLrnTimSchTT503() {
        return this.getBoolean(lrnTimSchTT503);
    }

    @Generated
    public void setLrnTimSchTT503(boolean v) {
        this.setBoolean(lrnTimSchTT503, v, null);
    }

    @Generated
    public boolean getLrnSetPtsTT504() {
        return this.getBoolean(lrnSetPtsTT504);
    }

    @Generated
    public void setLrnSetPtsTT504(boolean v) {
        this.setBoolean(lrnSetPtsTT504, v, null);
    }

    @Generated
    public boolean getLrnHolSchTT505() {
        return this.getBoolean(lrnHolSchTT505);
    }

    @Generated
    public void setLrnHolSchTT505(boolean v) {
        this.setBoolean(lrnHolSchTT505, v, null);
    }

    @Generated
    public boolean getIsEnhancedVersion() {
        return this.getBoolean(isEnhancedVersion);
    }

    @Generated
    public void setIsEnhancedVersion(boolean v) {
        this.setBoolean(isEnhancedVersion, v, null);
    }

    @Generated
    public boolean getStatusDisplay() {
        return this.getBoolean(statusDisplay);
    }

    @Generated
    public void setStatusDisplay(boolean v) {
        this.setBoolean(statusDisplay, v, null);
    }

    @Generated
    public boolean getUserConfiguration() {
        return this.getBoolean(userConfiguration);
    }

    @Generated
    public void setUserConfiguration(boolean v) {
        this.setBoolean(userConfiguration, v, null);
    }

    @Generated
    public boolean getMaintenance() {
        return this.getBoolean(maintenance);
    }

    @Generated
    public void setMaintenance(boolean v) {
        this.setBoolean(maintenance, v, null);
    }

    @Generated
    public boolean getServiceConfiguration() {
        return this.getBoolean(serviceConfiguration);
    }

    @Generated
    public void setServiceConfiguration(boolean v) {
        this.setBoolean(serviceConfiguration, v, null);
    }

    @Generated
    public boolean getSetPoints() {
        return this.getBoolean(setPoints);
    }

    @Generated
    public void setSetPoints(boolean v) {
        this.setBoolean(setPoints, v, null);
    }

    @Generated
    public boolean getTimeSchedules() {
        return this.getBoolean(timeSchedules);
    }

    @Generated
    public void setTimeSchedules(boolean v) {
        this.setBoolean(timeSchedules, v, null);
    }

    @Generated
    public boolean getAlarmHistory() {
        return this.getBoolean(alarmHistory);
    }

    @Generated
    public void setAlarmHistory(boolean v) {
        this.setBoolean(alarmHistory, v, null);
    }

    @Generated
    public boolean getHoliday() {
        return this.getBoolean(holiday);
    }

    @Generated
    public void setHoliday(boolean v) {
        this.setBoolean(holiday, v, null);
    }

    @Generated
    public BFolder getLearnedTables() {
        return (BFolder)this.get(learnedTables);
    }

    @Generated
    public void setLearnedTables(BFolder v) {
        this.set(learnedTables, (BValue)v, null);
    }

    @Generated
    public BCcnPointDeviceExt getPoints() {
        return (BCcnPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BCcnPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public int getPollProxyExtCount() {
        return this.getInt(pollProxyExtCount);
    }

    @Generated
    public void setPollProxyExtCount(int v) {
        this.setInt(pollProxyExtCount, v, null);
    }

    @Generated
    public BCcnByteList getTableAccessRights() {
        return (BCcnByteList)this.get(tableAccessRights);
    }

    @Generated
    public void setTableAccessRights(BCcnByteList v) {
        this.set(tableAccessRights, (BValue)v, null);
    }

    @Generated
    public long getMinimumWriteInterval() {
        return this.getLong(minimumWriteInterval);
    }

    @Generated
    public void setMinimumWriteInterval(long v) {
        this.setLong(minimumWriteInterval, v, null);
    }

    @Generated
    public BOrd submitTableDiscoveryJob() {
        return (BOrd)this.invoke(submitTableDiscoveryJob, null, null);
    }

    @Generated
    public BOrd submitAddTablesJob(BCcnTableList parameter) {
        return (BOrd)this.invoke(submitAddTablesJob, (BValue)parameter, null);
    }

    @Generated
    public void fetch() {
        this.invoke(fetch, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnDevice() {
    }

    public BCcnDevice(BCcnControllerEntry newEntry) {
        this.entry = newEntry;
        this.setBusNo(this.entry.getBusNo());
        this.setElemNo(this.entry.getElemNo());
        this.setDeviceName(this.entry.getDevName());
        this.setDuplicateDeviceName(this.entry.getDevName());
        this.setDeviceType(BCcnDeviceTypeEnum.make(this.entry.getDevType()));
    }

    public final BCcnNetwork getCcnNetwork() {
        return (BCcnNetwork)this.getNetwork();
    }

    public BCcnDeviceFolder getDeviceFolder() {
        if (this.devFolder == null) {
            for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BCcnDeviceFolder)) continue;
                this.devFolder = (BCcnDeviceFolder)parent;
                break;
            }
        }
        return this.devFolder;
    }

    public BCcnNetwork getCarrierNetwork() {
        if (this.objNetwork == null) {
            for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BCcnNetwork)) continue;
                this.objNetwork = (BCcnNetwork)parent;
                break;
            }
        }
        return this.objNetwork;
    }

    public BOrd doSubmitTableDiscoveryJob() {
        BCcnLearnTablesJob job = new BCcnLearnTablesJob(this);
        return job.submit(null);
    }

    public BOrd doSubmitAddTablesJob(BCcnTableList tableList) {
        BCcnAddTablesJob job = new BCcnAddTablesJob(this, tableList);
        return job.submit(null);
    }

    public void doFetch() {
        this.getCcnNetwork().getCcnComm().ccnAsyncRequest().submitRequest(new CcnFetchDeviceDataRequest(this, this.getCcnNetwork()));
    }

    public void started() throws Exception {
        super.started();
        if (this.isDeviceFID()) {
            this.loadTableGroupsForFID();
        }
        this.reviewLicense();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public void changed(Property changedProp, Context cx) {
        super.changed(changedProp, cx);
        if (!this.isRunning()) {
            return;
        }
        if (changedProp.getName().equalsIgnoreCase("statusDisplay")) {
            if (!this.isDeviceFID()) {
                this.setLrnStaDspPic11(((BBoolean)this.get("statusDisplay")).getBoolean());
            } else {
                this.setLrnStaDspTT500(((BBoolean)this.get("statusDisplay")).getBoolean());
            }
        } else if (changedProp.getName().equalsIgnoreCase("userConfiguration")) {
            this.setLrnUsrCfgPic10(((BBoolean)this.get("userConfiguration")).getBoolean());
            this.setLrnUsrCfgPoc14(((BBoolean)this.get("userConfiguration")).getBoolean());
        } else if (changedProp.getName().equalsIgnoreCase("maintenance")) {
            this.setLrnMaintPic12(((BBoolean)this.get("maintenance")).getBoolean());
            this.setLrnMaintPoc15(((BBoolean)this.get("maintenance")).getBoolean());
        } else if (changedProp.getName().equalsIgnoreCase("setPoints")) {
            if (!this.isDeviceFID()) {
                this.setLrnSetPtsPic17(((BBoolean)this.get("setPoints")).getBoolean());
                this.setLrnSetPtsPoc18(((BBoolean)this.get("setPoints")).getBoolean());
            } else {
                this.setLrnSetPtsTT504(((BBoolean)this.get("setPoints")).getBoolean());
            }
        } else if (changedProp.getName().equalsIgnoreCase("timeSchedules")) {
            if (!this.isDeviceFID()) {
                this.setLrnUsrCfgPoc14(((BBoolean)this.get("userConfiguration")).getBoolean());
                this.setLrnTimSchDTT614(((BBoolean)this.get("timeSchedules")).getBoolean());
            } else {
                this.setLrnTimSchTT503(((BBoolean)this.get("timeSchedules")).getBoolean());
            }
        } else if (changedProp.getName().equalsIgnoreCase("serviceConfiguration")) {
            this.setLrnSvcCfgPic13(((BBoolean)this.get("serviceConfiguration")).getBoolean());
            this.setLrnSvcCfgPoc16(((BBoolean)this.get("serviceConfiguration")).getBoolean());
        } else if (changedProp.getName().equalsIgnoreCase("alarmHistory")) {
            this.setLrnAlmHstPic43(((BBoolean)this.get("alarmHistory")).getBoolean());
        } else if (changedProp.getName().equalsIgnoreCase("holiday")) {
            this.setLrnHolSchTT505(((BBoolean)this.get("holiday")).getBoolean());
        } else if (changedProp.getName().equalsIgnoreCase("lrnUsrCfgPic10") || changedProp.getName().equalsIgnoreCase("lrnMaintPic12") || changedProp.getName().equalsIgnoreCase("lrnSvcCfgPic13") || changedProp.getName().equalsIgnoreCase("lrnUsrCfgPoc14") || changedProp.getName().equalsIgnoreCase("lrnMaintPoc15") || changedProp.getName().equalsIgnoreCase("lrnSvcCfgPoc16")) {
            if (((BBoolean)this.get(changedProp)).getBoolean() && !this.getIsEnhancedVersion()) {
                throw new CcnRuntimeException(6488275, this.getSummaryString() + "Sorry, station not licensed to set " + changedProp.getName() + " to true.");
            }
        } else if (changedProp.getName().equalsIgnoreCase("busNo") || changedProp.getName().equalsIgnoreCase("elemNo")) {
            this.doPing();
        }
    }

    public boolean isParentLegal(BComponent parent) throws LocalizableRuntimeException {
        if (parent instanceof BCcnNetwork || parent instanceof BCcnDeviceFolder) {
            return true;
        }
        throw new LocalizableRuntimeException("ccn", "CcnDevice.Drop");
    }

    public boolean isChildLegal(BComponent child) throws LocalizableRuntimeException {
        if (child instanceof BCcnDevice) {
            throw new LocalizableRuntimeException("ccn", "CcnDevice.ChildDrop");
        }
        return true;
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    protected IFuture postUpload(BUploadParameters params, Context cx) {
        try {
            this.doUpload(params, cx);
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected IFuture postDownload(BDownloadParameters params, Context cx) {
        try {
            this.doDownload(params, cx);
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void doUpload(BUploadParameters params, Context cx) throws Exception {
        switch (this.readyUploadDownload()) {
            case 0: {
                break;
            }
            case 1: {
                throw new LocalizableRuntimeException("ccn", "CcnUpload.error1");
            }
            case 2: {
                throw new LocalizableRuntimeException("ccn", "CcnUpload.error2");
            }
            default: {
                throw new LocalizableRuntimeException("ccn", "CcnUpload.error3");
            }
        }
        CcnPointConfigUploadRequest req = new CcnPointConfigUploadRequest(this);
        this.getCcnNetwork().getCcnComm().ccnAsyncRequest().submitRequest(req);
    }

    public void doDownload(BDownloadParameters params, Context cx) throws Exception {
        switch (this.readyUploadDownload()) {
            case 0: {
                break;
            }
            case 1: {
                throw new LocalizableRuntimeException("ccn", "CcnDownload.error1");
            }
            case 2: {
                throw new LocalizableRuntimeException("ccn", "CcnDownload.error2");
            }
            default: {
                throw new LocalizableRuntimeException("ccn", "CcnDownload.error3");
            }
        }
        this.vTable = new Vector();
        this.getExistingTableArray((BComponent)this, this.vTable);
        BCcnTable[] tableArray = new BCcnTable[this.vTable.size()];
        this.vTable.copyInto((Object[])tableArray);
        CcnPointConfigDownloadRequest req = new CcnPointConfigDownloadRequest(tableArray, this);
        this.getCcnNetwork().getCcnComm().ccnAsyncRequest().submitRequest(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPing() {
        String pingStat = "swept under rug";
        try {
            if (this.getCcnNetwork().isDiscoveryInProgress()) {
                pingStat = "skipped, discovery in progress";
            } else if (this.amIOutOfService()) {
                pingStat = "skipped, device is out of service";
                this.pingFail(pingStat);
                this.setDeviceStatus(OFFLINE);
            } else {
                CcnResponseMessage rsp = this.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(this.getPingMessage());
                if (rsp == null) {
                    pingStat = "error, no response to ping " + BCcnDevice.descPingType() + " request";
                    this.pingFail(pingStat);
                    this.setDeviceStatus(OFFLINE);
                } else if (rsp.getResponseBuffer().getResponseCommand() == 6) {
                    this.pingOk();
                    this.setStatus(BStatus.ok);
                    this.setDeviceStatus(ONLINE);
                    try {
                        this.processPingResponse(rsp);
                        pingStat = "succeeded and parsed " + BCcnDevice.descPingType() + " from ping message";
                    }
                    catch (CcnException e) {
                        pingStat = "succeeded but could not parse " + BCcnDevice.descPingType() + " because:" + (Object)((Object)e);
                    }
                } else {
                    this.pingOk();
                    try {
                        pingStat = "received " + BCcnDevice.descPingType() + " response but with NAK " + CcnRspTableUtil.parseRejectStatus(rsp);
                    }
                    catch (CcnException e) {
                        pingStat = "received " + BCcnDevice.descPingType() + " response but with command " + rsp.getResponseCommand();
                    }
                }
            }
        }
        catch (Throwable t) {
            pingStat = "could not complete last ping: " + t;
        }
        finally {
            this.setDevicePingStatus(pingStat);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isDeviceFID() {
        return this.getPicType().equalsIgnoreCase("203UC") || this.getPicType().equalsIgnoreCase("201X");
    }

    public void loadTableGroupsForFID() {
        this.setFlags(this.getSlot("userConfiguration"), 4);
        this.setFlags(this.getSlot("maintenance"), 4);
        this.setFlags(this.getSlot("serviceConfiguration"), 4);
        this.setFlags(this.getSlot("alarmHistory"), 4);
    }

    private void reviewLicense() {
        boolean limitedCcnDriver = false;
        if (!this.getCcnNetwork().getIsFullyLicensed()) {
            limitedCcnDriver = true;
            this.setLrnUsrCfgPic10(false);
            this.setLrnMaintPic12(false);
            this.setLrnSvcCfgPic13(false);
            this.setLrnUsrCfgPoc14(false);
            this.setLrnMaintPoc15(false);
            this.setLrnSvcCfgPoc16(false);
        } else {
            limitedCcnDriver = false;
        }
        this.setIsEnhancedVersion(!limitedCcnDriver);
    }

    public int readyUploadDownload() {
        if (this.getApplicationVersion() == null) {
            if (ccnNetworkLog.isTraceOn()) {
                ccnNetworkLog.trace("Requested download for " + (Object)((Object)this) + " cannot be performed... it's applicationVersion() == null");
            }
            return 2;
        }
        CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)this.getElemNo(), (byte)this.getBusNo(), null, 32, 1, 6, 0, 0));
        CcnResponseMessage rsp = this.getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
        if (rsp == null) {
            return 1;
        }
        if (rsp.getResponseCommand() != 6) {
            return 2;
        }
        try {
            if (CcnRspDevUtil.getPICType(rsp).equalsIgnoreCase("203UC") || CcnRspDevUtil.getPICType(rsp).equalsIgnoreCase("201X")) {
                return 0;
            }
            if (this.getPicType().trim().equals(CcnRspDevUtil.getPICType(rsp).trim()) && this.getApplicationVersion().trim().equals(CcnRspDevUtil.getPICApplSwVerNum(rsp).trim())) {
                return 0;
            }
        }
        catch (CcnException e) {
            ccnNetworkLog.error("ReadyUploadDownload, fetchBlock6: ERROR: " + (Object)((Object)e));
        }
        return 2;
    }

    public String getSummaryString() {
        return this.getType() + "`" + this.getName() + "`";
    }

    public boolean areYouOutOfService() {
        return this.amIOutOfService();
    }

    private boolean amIOutOfService() {
        boolean commActive = this.getCcnNetwork().getComm().isCommStarted();
        boolean netEnable = this.getCcnNetwork().getEnabled();
        boolean ccnDeviceEnabled = this.getEnabled();
        int address = this.getElemNo();
        int bus = this.getBusNo();
        boolean addressInRange = address > 0 && address < 239;
        boolean busInRange = bus >= 0 && bus < 239;
        return !ccnDeviceEnabled || !commActive || !netEnable || !addressInRange || !busInRange;
    }

    private CcnRequestMessage getPingMessage() {
        CcnRequestMessage ret = null;
        ret = this.getPingTimeMessage();
        return ret;
    }

    private CcnRequestMessage getPingTimeMessage() {
        return this.getDateTimeMessage(CcnRspDTUtil.TIME_BLOCK);
    }

    private CcnRequestMessage getPingDateMessage() {
        return this.getDateTimeMessage(CcnRspDTUtil.DATE_BLOCK);
    }

    private static String descPingType() {
        return "time";
    }

    private CcnRequestMessage getDateTimeMessage(int tableBlock) {
        short tableType = 33;
        byte tableInst = 1;
        CcnTableDef dateTimeTable = new CcnTableDef((byte)this.getElemNo(), (byte)this.getBusNo(), null, tableType, tableInst, (byte)tableBlock, 0, 0);
        return new CcnReadTableRequest(dateTimeTable);
    }

    private void processPingResponse(CcnResponseMessage pingRsp) throws CcnException {
        BAbsTime pingDateTime = this.getDeviceTime();
        this.setDeviceTime(pingDateTime);
    }

    public boolean isDsCcnTableEntryLicensed(BCcnTableEntry tableListEntry) {
        return this.getIsEnhancedVersion() || !BCcnDevice.isTableTypeRestricted(tableListEntry.getTableType(), tableListEntry.getTableTypeString());
    }

    private static boolean isTableTypeRestricted(int tableType, String tableTypeString) {
        return tableType == 16 || tableType == 18 || tableType == 19 || tableType == 20 && !tableTypeString.equals("Time_Schedules") || tableType == 21 || tableType == 22;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public void getExistingTableArray(BComponent ccnDevice, Vector<BCcnTable> v) {
        BComponent[] children = ccnDevice.getChildComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof BCcnTable) {
                BCcnTable child = (BCcnTable)children[i];
                if (child instanceof BCcnPicTable || child instanceof BCcnPocTable) {
                    if (child.getTableType() < 16 || child.getTableType() > 24) {
                        if (child instanceof BCcnPicTable) {
                            String warningMessage = "CcnPicTable";
                        } else {
                            String string = "CcnPocTable";
                        }
                    } else {
                        v.addElement(child);
                        if (child instanceof BCcnPocTable) {
                            this.getExistingTableArray(child, v);
                        }
                    }
                } else if (child instanceof BCcnAHTable) {
                    if (child.getTableType() == 67 && child.getTableInstance() == 1) {
                        v.addElement(child);
                    }
                } else {
                    v.addElement(child);
                }
            }
            this.getExistingTableArray(children[i], v);
        }
    }

    public boolean isDeviceStatusOk() {
        return !this.isDown() && !this.isDisabled() && !this.isFatalFault() && !this.isFault();
    }

    public void unsolicitedAlarmReceived(CcnUnsolicitedMsg alarmMsg) throws CcnException {
        this.addAlarm(BString.make((String)CcnAlarmUtil.getAlarmConsoleSummary(alarmMsg, ((BCcnNetwork)this.getNetwork()).getDisplayMetric())), BString.make((String)(CcnAlarmUtil.getTypeDesc((CcnDataWrapper)alarmMsg) + " - " + CcnAlarmUtil.getSourceDesc((CcnDataWrapper)alarmMsg))), BString.make((String)CcnAlarmUtil.getFormattedValue((CcnDataWrapper)alarmMsg, false, ((BCcnNetwork)this.getNetwork()).getDisplayMetric())));
    }

    public void addAlarm(BString alarmText, BString alarmType, BString alarmValue) {
        try {
            if (this.alarmServ == null) {
                this.alarmServ = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            }
            BFacets niagaraAlarmFacets = BFacets.make(BCcnDevice.ccnHashMap(alarmText, alarmType, alarmValue));
            BAlarmRecord rec = new BAlarmRecord(BUuid.make());
            rec.setSource(BOrdList.make((BOrd)this.getAlarmSourceInfo().getNavOrd()));
            rec.setAlarmClass(this.getAlarmSourceInfo().getAlarmClass());
            rec.setAlarmData(niagaraAlarmFacets);
            this.alarmServ.routeAlarm(rec);
        }
        catch (Exception e) {
            ccnNetworkLog.error("Exception occurred when adding Alarm", (Throwable)e);
        }
    }

    private static HashMap<String, BString> ccnHashMap(BString alarmText, BString alarmType, BString alarmValue) {
        HashMap<String, BString> map = new HashMap<String, BString>();
        map.put("alarmText", alarmText);
        map.put("alarmType", alarmType);
        map.put("alarmValue", alarmValue);
        return map;
    }
}

