/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnTunnelProcess;
import com.tridium.ccn.CcnUdpRoutingTable;
import com.tridium.ccn.UDPRoutingTableEntry;
import com.tridium.ccn.UDPUnsolicitedReceiveProcesser;
import com.tridium.ccn.messages.CcnResponseMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.baja.nre.util.ByteArrayUtil;

class CcnTunnelBack
extends CcnTunnelProcess {
    private Vector<DatagramPacket> iPackets = new Vector(20);
    private int iNextPacketId = 0;
    private static final int CCN_UDP_SEND_PORT = 50006;

    public CcnTunnelBack(BCcnTunnelHelper lCcnTunnelHelper, CcnUdpRoutingTable lRoutingTable) {
        super(lCcnTunnelHelper, lRoutingTable, "CcnTxTnl", 50006, 'B');
    }

    private synchronized int getNextUdpPacketId() {
        return this.iNextPacketId++ % 256;
    }

    private byte[] convertCcnToUdp(CcnResponseMessage lRsp, UDPUnsolicitedReceiveProcesser lUrp) {
        ByteArrayOutputStream byteArrayMaker = new ByteArrayOutputStream();
        byteArrayMaker.write(this.getNextUdpPacketId());
        byteArrayMaker.write(lUrp.iSourceAddr);
        byteArrayMaker.write(lUrp.iSourceBus);
        byteArrayMaker.write(lUrp.iDestAddr);
        byteArrayMaker.write(lUrp.iDestBus);
        byteArrayMaker.write(lRsp.getBlockLen());
        byteArrayMaker.write(lUrp.iPID);
        byteArrayMaker.write(3);
        byteArrayMaker.write(lRsp.getResponseCommand());
        byte[] ccnMsgData = lRsp.getData();
        byteArrayMaker.write(ccnMsgData, 0, ccnMsgData.length);
        return byteArrayMaker.toByteArray();
    }

    public void putQueue(CcnResponseMessage ccnRsp, UDPUnsolicitedReceiveProcesser lUrp) {
        int clientAddress = lUrp.iSourceAddr;
        UDPRoutingTableEntry rte = (UDPRoutingTableEntry)this.iRoutingTable.get(clientAddress);
        boolean unknownHost = false;
        if (rte != null) {
            try {
                byte[] packetData = this.convertCcnToUdp(ccnRsp, lUrp);
                int packetLength = packetData.length;
                DatagramPacket p = new DatagramPacket(packetData, packetLength, rte.getInetAddress(), rte.iUdpPort);
                this.putQueue(p);
            }
            catch (UnknownHostException uhe) {
                unknownHost = true;
            }
        } else {
            unknownHost = true;
        }
        if (unknownHost) {
            this.debugLn("Unable to route packet back to UDP client. Client address, " + clientAddress + " not in Jace routing table.");
        }
    }

    public synchronized void putQueue(DatagramPacket lPacket) {
        this.iPackets.addElement(lPacket);
        this.stopResting();
    }

    private synchronized DatagramPacket getNextPacketToSend() throws NoNextPacketToSendException {
        DatagramPacket nextPacketToSend = null;
        if (this.iPackets.size() <= 0) {
            throw new NoNextPacketToSendException();
        }
        nextPacketToSend = this.iPackets.firstElement();
        this.iPackets.removeElement(nextPacketToSend);
        return nextPacketToSend;
    }

    private boolean readAck02() throws IOException {
        byte[] dataAck02 = new byte[10];
        DatagramPacket p = new DatagramPacket(dataAck02, 10);
        this.iSocket.setSoTimeout(this.iCcnTunnelHelper.getTunnelRxResponseTimeout());
        try {
            this.iSocket.receive(p);
        }
        catch (InterruptedIOException iIOe) {
            p = null;
        }
        return p != null;
    }

    @Override
    protected String getDebugIntro() {
        return "IP Tx: ";
    }

    private void debugTx(DatagramPacket pkt) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(pkt.getData(), 0, pkt.getLength());
        this.debugLn("" + ByteArrayUtil.toHexString((byte[])out.toByteArray()) + " ");
    }

    private void sendUdpPacket(DatagramPacket pkt) throws UdpSendFailureException {
        try {
            for (int i = 0; i < this.iCcnTunnelHelper.getTunnelRxRetryCount() + 1; ++i) {
                this.debugTx(pkt);
                this.tunnelLog.trace(System.currentTimeMillis() + "::Sending packet 2 started");
                this.iSocket.send(pkt);
                this.tunnelLog.trace(System.currentTimeMillis() + "::Sending packet 2 finished");
                if (!this.readAck02()) {
                    this.debugLn("Attempt No " + i + " - Transmission not acknowledged..");
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new UdpSendFailureException(pkt, e);
        }
    }

    @Override
    protected boolean isDebugOn() {
        return this.iCcnTunnelHelper.getTunnelTxDebugOn();
    }

    @Override
    protected boolean isDisplayDots() {
        return this.iCcnTunnelHelper.getTunnelTxDisplayDots();
    }

    @Override
    protected void setStatus(String text) {
        this.iCcnTunnelHelper.setTunnelTxStatus(text);
    }

    @Override
    protected void cycle() {
        try {
            this.setStatus("Checking for TX packet in Q");
            DatagramPacket nextToSend = this.getNextPacketToSend();
            this.setStatus("Sending packet, " + CcnTunnelBack.getPacketString(nextToSend));
            this.sendUdpPacket(nextToSend);
            this.setStatus("Packet Sent, " + CcnTunnelBack.getPacketString(nextToSend));
        }
        catch (NoNextPacketToSendException e) {
            this.setStatus("No TX packets in Q");
            this.briefRest();
        }
        catch (UdpSendFailureException e) {
            this.setStatus("Tunnel Tx Failure. See station standard out.");
            System.out.println(e);
            this.briefRest();
        }
    }

    private static final String getPacketString(DatagramPacket pkt) {
        return "packet  DATA='" + ByteArrayUtil.toHexString((byte[])pkt.getData()) + "'";
    }

    class UdpSendFailureException
    extends Exception {
        private IOException iE;
        private DatagramPacket iP;

        public UdpSendFailureException(DatagramPacket lP, IOException lE) {
            this.iP = lP;
            this.iE = lE;
        }

        @Override
        public String toString() {
            return "Unable to send " + CcnTunnelBack.getPacketString(this.iP) + " because of " + this.iE;
        }
    }

    class NoNextPacketToSendException
    extends Exception {
        NoNextPacketToSendException() {
        }
    }
}

