/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.CcnTunnelProcess;
import com.tridium.ccn.CcnUdpRoutingTable;
import com.tridium.ccn.ClientNotInRoutingTableException;
import com.tridium.ccn.ClientSameAddressAsJaceException;
import com.tridium.ccn.UDPRoutingTableEntry;
import com.tridium.ccn.UDPUnsolicitedReceiveProcesser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import javax.baja.nre.util.ByteArrayUtil;

class CcnTunnelUp
extends CcnTunnelProcess {
    public static final int CCN_UDP_UNSOLICITED_RX_PORT = 50005;
    private CcnTunnelBack iCcnTunnelBack;

    public CcnTunnelUp(BCcnTunnelHelper lCcnTunnelHelper, CcnTunnelBack lCcnTunnelBack, CcnUdpRoutingTable lRoutingTable) {
        super(lCcnTunnelHelper, lRoutingTable, "CcnRxTnl", 50005, 'U');
        this.iCcnTunnelBack = lCcnTunnelBack;
    }

    @Override
    protected String getDebugIntro() {
        return "IP Rx: ";
    }

    @Override
    protected boolean isDebugOn() {
        return this.iCcnTunnelHelper.getTunnelRxDebugOn();
    }

    @Override
    protected boolean isDisplayDots() {
        return this.iCcnTunnelHelper.getTunnelRxDisplayDots();
    }

    @Override
    protected void setStatus(String text) {
        this.iCcnTunnelHelper.setTunnelRxStatus(text);
    }

    @Override
    protected void cycle() {
        this.receiveIncomingUdp();
    }

    private void debugRx(DatagramPacket rxP) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(rxP.getData(), 0, rxP.getLength());
        this.debugLn("" + ByteArrayUtil.toHexString((byte[])out.toByteArray()) + " ");
    }

    private void receiveIncomingUdp() {
        try {
            DatagramPacket packet = new DatagramPacket(new byte[256], 256);
            this.setStatus("Waiting to receive next UDP/IP transmission.");
            this.iSocket.setSoTimeout(this.iCcnTunnelHelper.getTunnelRxResponseTimeout());
            this.iSocket.receive(packet);
            if (packet.getLength() > 0) {
                this.setStatus("Received " + packet.getLength() + " bytes of data over IP.");
                this.processTunnelRx(packet);
            }
        }
        catch (ClientSameAddressAsJaceException e) {
            this.debugLn("" + e);
        }
        catch (ClientNotInRoutingTableException e) {
            this.debugLn("" + e);
        }
        catch (UDPRoutingTableEntry rte) {
            this.iRoutingTable.giveEntry(rte);
        }
        catch (InterruptedIOException e) {
            this.setStatus("Receive timeout.");
        }
        catch (SocketException e) {
            this.setStatus("Received SocketException " + e);
            this.briefRest();
        }
        catch (IOException e) {
            this.debugLn("Received IOException " + e);
            this.setStatus("IOException.");
            this.briefRest();
        }
    }

    private void processTunnelRx(DatagramPacket packet) {
        this.debugRx(packet);
        new UDPUnsolicitedReceiveProcesser(packet, this.iSocket, this.iCcnTunnelHelper, this.iCcnTunnelHelper.ccnNetwork.getElemAddress(), this.iCcnTunnelHelper.ccnNetwork.getBusAddress(), this.isDebugOn());
    }
}

