/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.UDPUnsolicitedReceiveProcesser;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.messages.CcnSendByteArrayRequest;
import com.tridium.ccn.util.AsynchronousRequest;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;

class TunnelUdp2CcnRequest
implements AsynchronousRequest {
    private UDPUnsolicitedReceiveProcesser iUrp;
    private CcnTunnelBack iTunnelBack;
    Log tunnelLog = Log.getLog((String)"CCNTunnelLog");

    public TunnelUdp2CcnRequest(UDPUnsolicitedReceiveProcesser lUrp, CcnTunnelBack lTunnelBack) {
        this.iUrp = lUrp;
        this.iTunnelBack = lTunnelBack;
    }

    @Override
    public void execute() {
        this.tunnelLog.trace(System.currentTimeMillis() + ":: CCN Request = " + ByteArrayUtil.toHexString((byte[])this.iUrp.getCcnMessageBytesForCcnTransmission()));
        CcnResponseMessage rsp = this.iUrp.iTunnelHelper.getCcnAsyncReq().sendAsyncRequest(new CcnSendByteArrayRequest(this.iUrp.getCcnMessageBytesForCcnTransmission()));
        if (rsp == null) {
            this.tunnelLog.trace(System.currentTimeMillis() + ":: Udp message routed to CCN but got no response from CCN!");
            this.tunnelLog.trace("CCN Request = " + ByteArrayUtil.toHexString((byte[])this.iUrp.getCcnMessageBytesForCcnTransmission()));
            return;
        }
        this.iTunnelBack.putQueue(rsp, this.iUrp);
    }
}

