/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn;

import com.tridium.ccn.BCcnTunnelHelper;
import com.tridium.ccn.CcnTunnelBack;
import com.tridium.ccn.exceptions.CcnRuntimeException;
import java.io.ByteArrayInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.baja.log.Log;
import javax.baja.sys.Clock;

class UDPMessageProcessor {
    protected DatagramPacket iPacket;
    protected DatagramSocket iSocket;
    protected CcnTunnelBack iTunnelBack;
    protected BCcnTunnelHelper iTunnelHelper;
    protected int iUdpPacketId;
    protected int iDestAddr;
    protected int iDestBus;
    protected int iSourceAddr;
    protected int iSourceBus;
    protected int iMsgDataLen;
    protected int iPID;
    protected int iExt;
    protected int iCmd;
    protected int iMyAddr;
    protected int iMyBus;
    protected boolean iDebug;
    private static final int MIN_PACKET_LENGTH = 9;
    private InetAddress iPacketAddress;
    private int iPacketPort = -1;
    Log tunnelLog = Log.getLog((String)"CCNTunnelLog");

    public UDPMessageProcessor(DatagramPacket lPacket, CcnTunnelBack lTunnelBack, BCcnTunnelHelper lTunnelHelper, int lMyAddr, int lMyBus, boolean lDebug) {
        this.debugf("Entered method UDPMessageProcessor <init>");
        this.iPacket = lPacket;
        this.checkPacketDataLength();
        this.iTunnelBack = lTunnelBack;
        this.iTunnelHelper = lTunnelHelper;
        this.iSocket = null;
        this.iMyAddr = lMyAddr;
        this.iMyBus = lMyBus;
        this.iDebug = lDebug;
        this.parsePacketBasics();
    }

    public UDPMessageProcessor(DatagramPacket lPacket, DatagramSocket lSocket, BCcnTunnelHelper lTunnelHelper, int lMyAddr, int lMyBus, boolean lDebug) {
        this.debugf("Entered method UDPMessageProcessor <init>");
        this.iPacket = lPacket;
        this.checkPacketDataLength();
        this.iTunnelBack = null;
        this.iTunnelHelper = lTunnelHelper;
        this.iSocket = lSocket;
        this.iMyAddr = lMyAddr;
        this.iMyBus = lMyBus;
        this.iDebug = lDebug;
        this.parsePacketBasics();
    }

    public InetAddress getPacketAddress() {
        if (this.iPacketAddress == null) {
            this.iPacketAddress = this.iPacket.getAddress();
        }
        return this.iPacketAddress;
    }

    public int getPacketPort() {
        if (this.iPacketPort < 0) {
            this.iPacketPort = this.iPacket.getPort();
        }
        return this.iPacketPort;
    }

    protected String getUdpIdSummary() {
        String s = "";
        s = s + "*** UDP FROM: " + this.getPacketAddress() + "\n]";
        s = s + "    PORT: " + this.getPacketPort() + "\n";
        return s;
    }

    protected String getCcnMsgSummary() {
        String s = "";
        s = s + "*** CCN SRC ADDR: " + this.iSourceAddr + "\n";
        s = s + "            BUS : " + this.iSourceBus + "\n";
        s = s + "        MSG CMD : " + this.iCmd + "\n";
        return s;
    }

    private byte[] getCcnMessageBytes() {
        int totalCcnMessageLength = this.iPacket.getLength() - 1;
        byte[] udpBytes = this.iPacket.getData();
        byte[] ccnMessageBytes = new byte[totalCcnMessageLength];
        int i = 0;
        int j = 1;
        while (i < totalCcnMessageLength) {
            ccnMessageBytes[i] = udpBytes[j];
            ++i;
            ++j;
        }
        return ccnMessageBytes;
    }

    protected byte[] getCcnMessageBytesForCcnTransmission() {
        byte[] ccnMessageBytes = this.getCcnMessageBytes();
        ccnMessageBytes[2] = (byte)this.iMyAddr;
        ccnMessageBytes[3] = (byte)this.iMyBus;
        return ccnMessageBytes;
    }

    protected String getIdSummary() {
        return this.getUdpIdSummary() + this.getCcnMsgSummary();
    }

    private void checkPacketDataLength() {
        if (this.iPacket.getLength() < 9) {
            throw new CcnRuntimeException(6488178, "!!CcnTunnel received UDP/IP message that is too short to possibly be a valid tunnel message.");
        }
    }

    public int yourAddressPlease() {
        return this.iMyAddr;
    }

    public int yourBusPlease() {
        return this.iMyBus;
    }

    public void debugf(String s) {
        if (this.iDebug) {
            String clazz = this.getClass().getName();
            this.tunnelLog.trace(clazz + " : " + s + " : [" + Clock.ticks() + "]");
        }
    }

    public void sendPacket(DatagramPacket p) {
        this.debugf("Entered method sendPacket");
        try {
            this.iSocket.send(p);
        }
        catch (Exception e) {
            this.debugf("Unable to send UDP packet because: " + e);
        }
    }

    private void parsePacketBasics() {
        ByteArrayInputStream dataInStream = new ByteArrayInputStream(this.iPacket.getData());
        this.iUdpPacketId = dataInStream.read();
        this.debugf("parsePacketBasics : iUdpPacketId = " + this.iUdpPacketId);
        this.iDestAddr = dataInStream.read();
        this.debugf("parsePacketBasics : iDestAddr = " + this.iDestAddr);
        this.iDestBus = dataInStream.read();
        this.debugf("parsePacketBasics : iDestBus = " + this.iDestBus);
        this.iSourceAddr = dataInStream.read();
        this.debugf("parsePacketBasics : iSourceAddr = " + this.iSourceAddr);
        this.iSourceBus = dataInStream.read();
        this.debugf("parsePacketBasics : iSourceBus = " + this.iSourceBus);
        this.iMsgDataLen = dataInStream.read();
        this.debugf("parsePacketBasics : iMsgDataLen = " + this.iMsgDataLen);
        this.iPID = dataInStream.read();
        this.debugf("parsePacketBasics : iPID = " + this.iPID);
        this.iExt = dataInStream.read();
        this.debugf("parsePacketBasics : iExt = " + this.iExt);
        this.iCmd = dataInStream.read();
        this.debugf("parsePacketBasics : iCmd = " + this.iCmd);
    }
}

