/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.messages.CcnAsyncRequest;
import com.tridium.ccn.messages.CcnWriteTableRequest;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspDTUtil;
import javax.baja.log.Log;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;

public class CcnBroadcastDateTimeRequest
implements AsynchronousRequest {
    public static final byte DATE_TIME_BROADCAST_ADDR = -15;
    public static final byte DATE_TIME_BROADCAST_BUS = -15;
    public static final byte HOLIDAY_FLAGS = 0;
    private BAbsTime currentDateTime = null;
    private CcnAsyncRequest ccnAsyncReq = null;
    private boolean shouldSyncDate = false;
    private static final int JAVA_SUNDAY = 0;
    private static final int CCN_SUNDAY = 7;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnBroadcastDateTimeRequest(CcnAsyncRequest newCcnAsyncReq, boolean shouldSyncDate) {
        this.ccnMessageLog.trace("CcnBroadcastDateTimeRequest invoked..." + BAbsTime.now() + "::Clock is::" + Clock.time());
        this.currentDateTime = Clock.time();
        this.ccnAsyncReq = newCcnAsyncReq;
        this.shouldSyncDate = shouldSyncDate;
    }

    @Override
    public void execute() {
        this.syncTime();
        if (this.shouldSyncDate) {
            this.syncDate();
        }
    }

    private void syncTime() {
        this.ccnAsyncReq.sendAsyncRequest(new CcnWriteTableRequest(CcnRspDTUtil.getDefTimeBlock(), this.getSyncTimeData()));
    }

    private void syncDate() {
        this.ccnAsyncReq.sendAsyncRequest(new CcnWriteTableRequest(CcnRspDTUtil.getDefDateBlock(), this.getSyncDateData()));
    }

    private byte[] getSyncDateData() {
        byte[] dateBlock = new byte[]{(byte)this.currentDateTime.getDay(), (byte)this.currentDateTime.getMonth().getMonthOfYear(), (byte)(this.currentDateTime.getYear() % 100)};
        return dateBlock;
    }

    private byte[] getSyncTimeData() {
        byte[] timeBlock = new byte[]{(byte)this.currentDateTime.getHour(), (byte)this.currentDateTime.getMinute(), (byte)(0 | this.getCcnDayOfWeek())};
        return timeBlock;
    }

    private byte getCcnDayOfWeek() {
        byte javaDayOfWeek = (byte)this.currentDateTime.getWeekday().getOrdinal();
        int ccnDayOfWeek = javaDayOfWeek == 0 ? 7 : (int)javaDayOfWeek;
        return (byte)(ccnDayOfWeek & 0xFF);
    }
}

