/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnAddDataTablesJob;
import com.tridium.ccn.messages.CcnCreatePointsRequest;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnDataTableWithTimeSchedule;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspDataUtil;
import com.tridium.ccn.util.CcnUtil;
import java.util.Vector;
import javax.baja.job.BJobState;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnCreateDataTablesRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnPointEntry[] pointEntries;
    private BCcnPointEntry pointEntry;
    private BCcnAddDataTablesJob job;
    private BCcnDataTable dataTable;
    private BCcnDataTableWithTimeSchedule dataTableWithTimeSchedule;
    private BCcnDataTable refreshedTable;
    private Vector<BCcnDataTable> dataTablesAdded;
    private Vector<Object> pointsVector;
    private boolean refresh = false;
    private boolean fetch = false;
    private boolean upload = false;
    private String function;
    private final BCcnPocTable newPocTable;
    private final BCcnTableEntry[] learnedDataTableEntries;
    private final BCcnDevice ccnDevice;
    private final BCcnNetwork ccnNetwork;
    private static final Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnCreateDataTablesRequest(BCcnPocTable table, BCcnTableEntry[] tableList, BCcnAddDataTablesJob learnJob) {
        this.newPocTable = table;
        this.learnedDataTableEntries = tableList;
        this.job = learnJob;
        this.ccnDevice = this.newPocTable.getCcnDevice();
        this.ccnNetwork = this.ccnDevice.getCcnNetwork();
        this.function = "Create";
    }

    public CcnCreateDataTablesRequest(BCcnPocTable table, BCcnTableEntry[] tableList, BCcnDataTable newRefreshedTable, boolean newRefresh, boolean newFetch, boolean newUpload) {
        this.newPocTable = table;
        this.learnedDataTableEntries = tableList;
        this.ccnDevice = this.newPocTable.getCcnDevice();
        this.ccnNetwork = this.ccnDevice.getCcnNetwork();
        this.refreshedTable = newRefreshedTable;
        this.refresh = newRefresh;
        this.fetch = newFetch;
        this.upload = newUpload;
        this.function = this.upload ? "Upload" : "Create";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnCreateDataTable.add");
        }
        if (!this.upload) {
            this.newPocTable.setLearnStatus(TextUtil.capitalize((String)this.function) + "-> Start process...");
            if (this.job != null) {
                this.job.log().message(TextUtil.capitalize((String)this.function) + "-> Start process...");
            }
        }
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnCreateDataTablesRequest: " + TextUtil.capitalize((String)this.function) + "-> Start process...");
        }
        boolean curPocOverwriteState = false;
        if (this.refreshedTable != null || this.fetch || this.upload) {
            curPocOverwriteState = this.newPocTable.getOverwriteExisting();
            this.newPocTable.setOverwriteExisting(true);
        }
        try {
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnCreateDataTablesRequest: tables " + this.learnedDataTableEntries.length);
            }
            this.dataTablesAdded = new Vector();
            for (int iCount = 0; iCount < this.learnedDataTableEntries.length; ++iCount) {
                int dataTableStrBlock;
                BCcnTableEntry ccnDataTable = this.learnedDataTableEntries[iCount];
                int dataTableType = ccnDataTable.getTableType();
                int dataTableInstance = ccnDataTable.getTableInstance();
                String dataTableName = ccnDataTable.getTableName().trim();
                int blockCount = ccnDataTable.getBlockCount();
                int dataTableEndBlock = dataTableStrBlock = this.newPocTable.getDataTableBlock();
                if (this.job != null) {
                    this.job.progress((100 * iCount + 1) / (this.learnedDataTableEntries.length + 1));
                }
                if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                    this.job.setJobState(BJobState.canceled);
                    break;
                }
                if (dataTableStrBlock == 255) {
                    dataTableStrBlock = this.newPocTable.getDataTableStartBlock();
                    dataTableEndBlock = this.newPocTable.getDataTableEndBlock();
                }
                for (int jCount = dataTableStrBlock; jCount <= dataTableEndBlock; ++jCount) {
                    int iPointCount;
                    CcnResponseMessage dataBlockResponse;
                    int dataTableBlock = jCount;
                    boolean isNewDataTable = false;
                    this.pointsVector = new Vector();
                    if (dataTableType != 1556 || dataTableBlock != 2) {
                        BCcnDataTable existingDataTable = CcnCreateDataTablesRequest.findCcnDataTable(this.newPocTable, dataTableName, dataTableBlock);
                        if (existingDataTable == null) {
                            isNewDataTable = true;
                            this.dataTable = new BCcnDataTable(ccnDataTable);
                            if (dataTableName.length() == 0) {
                                dataTableName = "T";
                            }
                            if (!Character.isLetter(dataTableName.charAt(0))) {
                                dataTableName = "T_" + dataTableName;
                            }
                            if (dataTableStrBlock != dataTableEndBlock && jCount == dataTableStrBlock) {
                                dataTableName = dataTableName + "_1";
                            }
                            dataTableName = CcnUtil.makeValidName(dataTableName);
                            this.newPocTable.setDataTableCreateCount(this.newPocTable.getDataTableCreateCount() + 1);
                            this.dataTablesAdded.addElement(this.dataTable);
                            if (this.newPocTable.get(dataTableName) == null) {
                                this.newPocTable.add(dataTableName, (BValue)this.dataTable);
                            }
                        } else {
                            this.dataTable = existingDataTable;
                        }
                        if (!isNewDataTable && !this.newPocTable.getOverwriteExisting()) continue;
                        this.dataTable.setPreMetricDisplay(this.ccnNetwork.getDisplayMetric());
                        this.dataTable.setCurMetricDisplay(this.ccnNetwork.getDisplayMetric());
                        this.dataTable.setTableType(dataTableType);
                        this.dataTable.setTableTypeString(this.dataTable.getGroup().getTableGroupDescription());
                        this.dataTable.setTableInstance(dataTableInstance);
                        this.dataTable.setTableNum(ccnDataTable.getTableNum());
                        this.dataTable.setDataBlock(dataTableBlock);
                        this.dataTable.setTableName(ccnDataTable.getTableName());
                        this.dataTable.setTableBlockCount(blockCount);
                        this.dataTable.setPointLearnCount(ccnDataTable.getPointCount());
                        dataBlockResponse = new CcnResponseMessage();
                        dataBlockResponse = CcnUtil.interrogateDataTableForPointData(this.ccnDevice, dataTableType, dataTableInstance, dataTableBlock);
                        if (dataBlockResponse == null) continue;
                        this.pointEntries = new BCcnPointEntry[this.newPocTable.getPointLearnCount()];
                        if (ccnMessageLog.isTraceOn()) {
                            ccnMessageLog.trace("CcnCreateDataTablesRequest: convertBlockDataToDataTableData: tt | ti | pnts | len: " + Integer.toHexString(dataTableType) + " | " + dataTableInstance + " | " + this.pointEntries.length + " | " + dataBlockResponse.getBlockLen());
                        }
                        this.convertBlockDataToDataTableData(dataTableType, dataBlockResponse, dataTableBlock);
                        for (iPointCount = 0; iPointCount < this.pointEntries.length; ++iPointCount) {
                            if (this.pointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
                            this.addLearnedPoints(this.dataTable, this.pointEntries[iPointCount]);
                        }
                        this.dataTable.setPointLearnCount(this.pointEntries.length);
                        continue;
                    }
                    BCcnDataTableWithTimeSchedule existingTimeScheduleTable = CcnCreateDataTablesRequest.findCcnDataTableWithTimeSchedule(this.newPocTable, dataTableName, dataTableBlock);
                    if (existingTimeScheduleTable == null) {
                        isNewDataTable = true;
                        this.dataTableWithTimeSchedule = new BCcnDataTableWithTimeSchedule(ccnDataTable);
                        if (dataTableName.length() == 0) {
                            dataTableName = "T";
                        }
                        if (!Character.isLetter(dataTableName.charAt(0))) {
                            dataTableName = "T_" + dataTableName;
                        }
                        dataTableName = CcnUtil.makeValidName(dataTableName);
                        this.newPocTable.setDataTableCreateCount(this.newPocTable.getDataTableCreateCount() + 1);
                        this.dataTablesAdded.addElement(this.dataTableWithTimeSchedule);
                        this.newPocTable.add(dataTableName, (BValue)this.dataTableWithTimeSchedule);
                    } else {
                        this.dataTableWithTimeSchedule = existingTimeScheduleTable;
                    }
                    if (!isNewDataTable && !this.newPocTable.getOverwriteExisting()) continue;
                    this.dataTableWithTimeSchedule.setPreMetricDisplay(this.ccnDevice.getCcnNetwork().getDisplayMetric());
                    this.dataTableWithTimeSchedule.setCurMetricDisplay(this.ccnDevice.getCcnNetwork().getDisplayMetric());
                    this.dataTableWithTimeSchedule.setTableType(dataTableType);
                    this.dataTableWithTimeSchedule.setTableTypeString("Time_Schedules");
                    this.dataTableWithTimeSchedule.setTableInstance(dataTableInstance);
                    this.dataTableWithTimeSchedule.setTableNum(ccnDataTable.getTableNum());
                    this.dataTableWithTimeSchedule.setDataBlock(dataTableBlock);
                    this.dataTableWithTimeSchedule.setTableName(ccnDataTable.getTableName());
                    this.dataTableWithTimeSchedule.setTableBlockCount(blockCount);
                    this.dataTableWithTimeSchedule.setPointLearnCount(ccnDataTable.getPointCount());
                    dataBlockResponse = new CcnResponseMessage();
                    if (ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnCreateDataTablesRequest: interrogateDataTableForPointData: bus | elem | tt | ti | blk: " + this.ccnDevice.getBusNo() + " | " + this.ccnDevice.getElemNo() + " | " + Integer.toHexString(dataTableType) + " | " + dataTableInstance + " | " + dataTableBlock);
                    }
                    if ((dataBlockResponse = CcnUtil.interrogateDataTableForPointData(this.ccnDevice, dataTableType, dataTableInstance, dataTableBlock)) == null) continue;
                    this.pointEntries = new BCcnPointEntry[this.newPocTable.getPointLearnCount()];
                    if (ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnCreateDataTablesRequest: convertBlockDataToDataTableData: tt | ti | pnts | len: " + Integer.toHexString(dataTableType) + " | " + dataTableInstance + " | " + this.pointEntries.length + " | " + dataBlockResponse.getBlockLen());
                    }
                    this.convertBlockDataToDataTableData(dataTableType, dataBlockResponse, dataTableBlock);
                    for (iPointCount = 0; iPointCount < this.pointEntries.length; ++iPointCount) {
                        if (this.pointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
                        this.addLearnedPointsToDataTableTimeSchedule(this.pointEntries[iPointCount]);
                    }
                    BCcnTimeScheduleEntry[] timeScheduleEntries = CcnRspDataUtil.buildTimeSchedules(this.pointEntries);
                    this.dataTableWithTimeSchedule.getTimeScheduleList().setTimeScheduleList(timeScheduleEntries);
                    if (ccnMessageLog.isTraceOn()) {
                        ccnMessageLog.trace("CcnCreateDataTablesRequest: setPointLearnCount: cnt | len: " + this.newPocTable.getPointLearnCount() + " | " + this.pointEntries.length);
                    }
                    this.dataTableWithTimeSchedule.setPointLearnCount(this.pointEntries.length);
                }
            }
        }
        catch (Exception e) {
            ccnMessageLog.error("Exception occurred while executing CcnCreateDataTablesRequest", (Throwable)e);
        }
        finally {
            if (this.refreshedTable != null || this.fetch || this.upload) {
                this.newPocTable.setOverwriteExisting(curPocOverwriteState);
                this.fetch = false;
            }
            if (!this.upload) {
                this.newPocTable.setLearnStatus(TextUtil.capitalize((String)this.function) + "-> Complete");
                if (this.job != null) {
                    this.job.log().message(TextUtil.capitalize((String)this.function) + "-> Complete");
                }
                this.newPocTable.setLearnStatus("Idle");
            }
            if (ccnMessageLog.isTraceOn()) {
                ccnMessageLog.trace("CcnCreateDataTablesRequest: " + TextUtil.capitalize((String)this.function) + "-> Complete");
            }
        }
        if (this.refresh && this.refreshedTable != null) {
            CcnCreateDataTablesRequest.updateCreatedPoints(this.refreshedTable);
            this.refresh = false;
            this.refreshedTable = null;
        }
    }

    private static void updateCreatedPoints(BCcnDataTable table) {
        table.setLearnStatus("Update created points...");
        Vector<BCcnProxyExt> vObject = new Vector<BCcnProxyExt>();
        table.getExistingObjectArray(table, vObject);
        if (vObject.size() <= 0) {
            table.setLearnStatus("Idle");
            return;
        }
        Object[] objectArray = new BCcnProxyExt[vObject.size()];
        vObject.copyInto(objectArray);
        BCcnPointEntry[] pointList = table.getPointList().getPointList();
        Vector<BCcnPointEntry> vPointList = new Vector<BCcnPointEntry>();
        for (int j = 0; j < objectArray.length; ++j) {
            boolean matchFound = false;
            for (int k = 0; k < pointList.length; ++k) {
                if (pointList[k].getFieldIndex() != ((BCcnProxyExt)objectArray[j]).getFieldIndex() || !pointList[k].getFieldName().equalsIgnoreCase(((BCcnProxyExt)objectArray[j]).getFieldName())) continue;
                vPointList.addElement(pointList[k]);
                matchFound = true;
                break;
            }
            if (j < pointList.length && matchFound) continue;
            BCcnInputProxy child = (BCcnInputProxy)objectArray[j];
            child.setFault(true);
        }
        BCcnPointEntry[] aPointList = new BCcnPointEntry[vPointList.size()];
        vPointList.copyInto((Object[])aPointList);
        CcnCreatePointsRequest reqCreatePoints = new CcnCreatePointsRequest(table, aPointList, true, true);
        reqCreatePoints.execute();
    }

    private static BCcnDataTable findCcnDataTable(BComponent poc, String name, int block) {
        BComponent[] childrenHandles = poc.getChildComponents();
        for (int i = 0; i < childrenHandles.length; ++i) {
            BComponent nextChild = childrenHandles[i];
            if (!(nextChild instanceof BCcnDataTable)) continue;
            BCcnDataTable tab1 = (BCcnDataTable)nextChild;
            String tName = tab1.getTableName();
            int tBlock = tab1.getDataBlock();
            if (!tName.equalsIgnoreCase(name) || tBlock != block) continue;
            return tab1;
        }
        return null;
    }

    private static BCcnDataTableWithTimeSchedule findCcnDataTableWithTimeSchedule(BComponent poc, String name, int block) {
        BComponent[] childrenHandles = poc.getChildComponents();
        for (int i = 0; i < childrenHandles.length; ++i) {
            BComponent nextChild = childrenHandles[i];
            if (!(nextChild instanceof BCcnDataTableWithTimeSchedule)) continue;
            BCcnDataTableWithTimeSchedule tab1 = (BCcnDataTableWithTimeSchedule)nextChild;
            String tName = tab1.getTableName();
            int tBlock = tab1.getDataBlock();
            if (!tName.equalsIgnoreCase(name) || tBlock != block) continue;
            return tab1;
        }
        return null;
    }

    void addLearnedPointsToDataTableTimeSchedule(BCcnPointEntry panel) {
        boolean isPointLearntAlready = false;
        BCcnPointEntry[] learnedPoints = (BCcnPointEntry[])this.dataTableWithTimeSchedule.getPointList().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < learnedPoints.length; ++i) {
            if (!learnedPoints[i].getFieldName().equalsIgnoreCase(panel.getFieldName())) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready) {
            this.dataTableWithTimeSchedule.getPointList().add(SlotPath.escape((String)(panel.getFieldName().trim() + "_" + panel.getPointDataType() + "_" + panel.getDescription() + "_" + panel.getConfigFlags() + "_" + panel.getDiscreteTextOffset())), (BValue)panel);
        }
    }

    void addLearnedPoints(BCcnDataTable dataTable, BCcnPointEntry panel) {
        boolean isPointLearntAlready = false;
        BCcnPointEntry[] learnedPoints = (BCcnPointEntry[])dataTable.getPointList().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < learnedPoints.length; ++i) {
            if (!learnedPoints[i].getFieldName().equalsIgnoreCase(panel.getFieldName()) || !learnedPoints[i].getDescription().equalsIgnoreCase(panel.getDescription()) || learnedPoints[i].getValueBlock() != panel.getValueBlock()) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready && panel != null) {
            String strPtEntry = SlotPath.escape((String)(panel.getFieldIndex() + panel.getFieldName().trim() + "_" + panel.getPointDataType() + "_" + panel.getDescription() + "_" + panel.getConfigFlags() + "_" + panel.getDiscreteTextOffset()));
            if (dataTable.getPointList().get(strPtEntry) != null) {
                dataTable.getPointList().remove(strPtEntry);
            }
            dataTable.getPointList().add(strPtEntry, (BValue)new BCcnPointEntry(panel.getFieldIndex(), SlotPath.escape((String)panel.getFieldName()).trim(), panel.getPointDataType(), this.ccnDevice.getCcnNetwork().getDisplayMetric(), panel.getDisplayDigits(), panel.getFieldByteCount(), panel.getDiscreteTextOffset(), panel.getConfigFlags(), panel.getUnits(), panel.getPointValue(), panel.getValueBlock(), panel.getValueBlockOffset(), panel.getAlrmStatus().getOrdinal(), panel.getForceLevel().getOrdinal(), panel.getLoLimit(), panel.getLoLimitBlock(), panel.getLoLimitBlockOffset(), panel.getHiLimit(), panel.getHiLimitBlock(), panel.getHiLimitBlockOffset(), panel.getVariableNo(), panel.getDescription(), panel.getForceableFlag(), panel.getPointType()));
        }
    }

    private void convertBlockDataToDataTableData(int tableType, CcnResponseMessage dataBlockResponse, int dataBlock) {
        int tableFieldCount = this.pointEntries.length;
        int dataBlock_FieldIndex = 0;
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnCreateDataTablesRequest: convertBlockDataToDataTableData: tt | cnt: " + Integer.toHexString(tableType) + " | " + tableFieldCount);
        }
        BCcnPointEntry[] pointMasters = (BCcnPointEntry[])this.newPocTable.getLearnedSplPoints().getChildren(BCcnPointEntry.class);
        if (ccnMessageLog.isTraceOn()) {
            ccnMessageLog.trace("CcnCreateDataTablesRequest: convertBlockDataToDataTableData point entries length: " + tableFieldCount + " master entries length: " + pointMasters.length);
        }
        int highestCommonIndex = Math.min(tableFieldCount, pointMasters.length);
        for (int i = 0; i < highestCommonIndex; ++i) {
            this.pointEntry = new BCcnPointEntry(pointMasters[i]);
            this.pointEntry.setValueBlock((byte)dataBlock);
            int newIndex = CcnCreateDataTablesRequest.getDataBlockData(tableType, tableFieldCount, this.pointEntry, dataBlockResponse, dataBlock_FieldIndex);
            if (newIndex == -1) break;
            dataBlock_FieldIndex = newIndex;
            this.pointEntries[i] = this.pointEntry;
        }
    }

    private static int getDataBlockData(int tableType, int fieldIndex, BCcnPointEntry entry, CcnResponseMessage response, int index) {
        if (response == null || response.getResponseCommand() != 6) {
            return -1;
        }
        int len = response.getBlockLen() - 3;
        int dataLength = entry.getFieldByteCount();
        if (index + dataLength <= len) {
            try {
                entry.setPointValue(CcnRspDataUtil.getValue(response, index, entry));
                entry.setValueBlockOffset(index);
            }
            catch (CcnException e) {
                ccnMessageLog.error("Exception occurred while updating BCcnPointEntry " + (Object)((Object)entry), (Throwable)((Object)e));
            }
            return index += dataLength;
        }
        return -1;
    }
}

