/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.enums.BCcnTableGroupTypeEnum;
import com.tridium.ccn.job.BCcnLearnPICPointsJob;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnRspPocUtil;
import com.tridium.ccn.util.CcnUtil;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;

public class CcnLearnPICPointsRequest
implements AsynchronousRequest,
CcnMessageConst {
    BCcnDevice ccnDevice;
    BCcnPicTable ccnTable;
    BCcnPointEntry[] pointEntries;
    BCcnPointEntry pointEntry;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");
    BCcnLearnPICPointsJob job;

    public CcnLearnPICPointsRequest(BCcnPicTable ccnTable, BCcnDevice ccnDevice, BCcnLearnPICPointsJob job) {
        this.ccnTable = ccnTable;
        this.ccnDevice = ccnDevice;
        this.job = job;
    }

    public CcnLearnPICPointsRequest(BCcnPicTable ccnTable, BCcnDevice ccnDevice) {
        this.ccnTable = ccnTable;
        this.ccnDevice = ccnDevice;
    }

    @Override
    public void execute() {
        if (!this.ccnDevice.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnLearnPoint.add");
        }
        int blockCount = this.ccnTable.getTableBlockCount();
        int tableType = this.ccnTable.getTableType();
        int tableInstance = this.ccnTable.getTableInstance();
        String tableTypeString = this.ccnTable.getGroup().getTableGroupDescription();
        CcnResponseMessage[] picBlockResponses = new CcnResponseMessage[blockCount];
        picBlockResponses = this.interrogateTableForPointData(this.ccnTable, this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), tableType, tableInstance, blockCount, tableTypeString);
        this.pointEntries = null;
        this.pointEntries = new BCcnPointEntry[this.ccnTable.getPointLearnCount()];
        if (picBlockResponses != null) {
            CcnUtil.convertBlockDataToTableData(this.ccnDevice, this.pointEntries, null, tableType, picBlockResponses, this.ccnTable, 0);
        }
        for (int iPointCount = 0; iPointCount < this.pointEntries.length; ++iPointCount) {
            if (this.job != null) {
                this.job.progress((100 * iPointCount + 1) / (this.pointEntries.length + 1));
            }
            if (this.pointEntries[iPointCount].getFieldName().trim().equalsIgnoreCase("")) continue;
            this.addLearnedPoints(this.ccnTable, this.pointEntries[iPointCount]);
        }
        this.ccnTable.setPointLearnCount(this.pointEntries.length);
    }

    void addLearnedPoints(BCcnPicTable picTable, BCcnPointEntry panel) {
        boolean isPointLearntAlready = false;
        BCcnPointEntry[] learnedPoints = (BCcnPointEntry[])picTable.getPointList().getChildren(BCcnPointEntry.class);
        for (int i = 0; i < learnedPoints.length; ++i) {
            if (!learnedPoints[i].getFieldName().equalsIgnoreCase(panel.getFieldName()) || !learnedPoints[i].getDescription().equalsIgnoreCase(panel.getDescription()) || learnedPoints[i].getValueBlock() != panel.getValueBlock() || learnedPoints[i].getFieldIndex() != panel.getFieldIndex()) continue;
            isPointLearntAlready = true;
            break;
        }
        if (!isPointLearntAlready && panel != null) {
            picTable.getPointList().add(SlotPath.escape((String)(panel.getFieldIndex() + panel.getFieldName().trim() + "_" + panel.getPointDataType() + "_" + panel.getDescription() + "_" + panel.getConfigFlags() + "_" + panel.getDiscreteTextOffset())), (BValue)new BCcnPointEntry(panel.getFieldIndex(), SlotPath.escape((String)panel.getFieldName()).trim(), panel.getPointDataType(), this.ccnDevice.getCcnNetwork().getDisplayMetric(), panel.getDisplayDigits(), panel.getFieldByteCount(), panel.getDiscreteTextOffset(), panel.getConfigFlags(), panel.getUnits(), panel.getPointValue(), panel.getValueBlock(), panel.getValueBlockOffset(), panel.getAlrmStatus().getOrdinal(), panel.getForceLevel().getOrdinal(), panel.getLoLimit(), panel.getLoLimitBlock(), panel.getLoLimitBlockOffset(), panel.getHiLimit(), panel.getHiLimitBlock(), panel.getHiLimitBlockOffset(), panel.getVariableNo(), panel.getDescription(), panel.getForceableFlag(), panel.getPointType()));
        }
    }

    public CcnResponseMessage[] interrogateTableForPointData(BCcnTable ccnTable, int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlockCount, String tableTypeString) {
        CcnResponseMessage[] curBlockResponses = new CcnResponseMessage[curBlockCount];
        try {
            BCcnTableGroupTypeEnum tableGroupType = null;
            if (!this.ccnDevice.isDeviceFID()) {
                if (curTableType == 16) {
                    tableGroupType = BCcnTableGroupTypeEnum.UserConfiguration;
                } else if (curTableType == 17) {
                    tableGroupType = BCcnTableGroupTypeEnum.StatusDisplay;
                } else if (curTableType == 19 || curTableType == 22) {
                    tableGroupType = BCcnTableGroupTypeEnum.ServiceConfiguration;
                } else if (curTableType == 23 || curTableType == 24) {
                    tableGroupType = BCcnTableGroupTypeEnum.SetPoints;
                } else if (curTableType == 18 || curTableType == 21) {
                    tableGroupType = BCcnTableGroupTypeEnum.Maintenance;
                } else if (curTableType == 67) {
                    tableGroupType = BCcnTableGroupTypeEnum.AlarmHistory;
                } else if (curTableType == 20) {
                    if (ccnTable.getTableName().equalsIgnoreCase("SPSCHPOC")) {
                        tableGroupType = BCcnTableGroupTypeEnum.TimeSchedules;
                    } else {
                        CcnResponseMessage tt14_rsp = this.getBlockDataFromTable(this.ccnDevice.getBusNo(), this.ccnDevice.getElemNo(), curTableType, curTableInstance, 6);
                        if (tt14_rsp != null) {
                            this.ccnMessageLog.trace("<CcnCreateTablesRequest: test for 0x14... responseCommand: " + tt14_rsp.getResponseCommand() + "\nresponseBuffer: " + new String(tt14_rsp.getResponseBuffer().getResponseData()));
                        }
                        if (tt14_rsp == null || tt14_rsp.getResponseCommand() != 6) {
                            return null;
                        }
                        int dataTableType = CcnRspPocUtil.getDataTableType(tt14_rsp);
                        tableGroupType = dataTableType == 1556 ? BCcnTableGroupTypeEnum.TimeSchedules : BCcnTableGroupTypeEnum.UserConfiguration;
                    }
                }
            } else if (curTableType == 1281) {
                tableGroupType = BCcnTableGroupTypeEnum.StatusDisplay;
            } else if (curTableType == 1283) {
                tableGroupType = BCcnTableGroupTypeEnum.TimeSchedules;
            } else if (curTableType == 1284) {
                tableGroupType = BCcnTableGroupTypeEnum.SetPoints;
            } else if (curTableType == 1285) {
                tableGroupType = BCcnTableGroupTypeEnum.Holiday;
            }
            if (tableGroupType != null && !tableGroupType.getTag().equalsIgnoreCase(tableTypeString)) {
                return null;
            }
        }
        catch (Exception tableGroupType) {
            // empty catch block
        }
        if (!this.ccnDevice.isDeviceFID()) {
            for (int j = 2; j <= curBlockCount; ++j) {
                if ((20 <= curTableType && curTableType <= 22 || curTableType == 24) && (j == 5 || j == 9)) continue;
                this.ccnDevice.getCcnNetwork().setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = this.getBlockDataFromTable(curBusNo, curElemNo, curTableType, curTableInstance, j);
            }
        } else {
            for (int j = 1; j <= curBlockCount; ++j) {
                if (j == 1 && curTableType != 1281) continue;
                this.ccnDevice.getCcnNetwork().setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = this.getBlockDataFromTable(curBusNo, curElemNo, curTableType, curTableInstance, j);
                if (curBlockResponses[j - 1] != null) continue;
                return null;
            }
        }
        return curBlockResponses;
    }

    private CcnResponseMessage getBlockDataFromTable(int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlock) {
        CcnResponseMessage rsp = new CcnResponseMessage();
        BCcnNetwork ccnNetwork = this.ccnDevice.getCcnNetwork();
        for (int i = 0; i < 3; ++i) {
            rsp = new CcnResponseMessage();
            CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, (short)curTableType, (byte)curTableInstance, (byte)curBlock, 0, 0));
            rsp = ccnNetwork.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (rsp != null && rsp.getResponseCommand() == 21) {
                return rsp;
            }
            if (rsp == null || rsp.getResponseCommand() != 6 || curBlock != rsp.getBlock() || curTableInstance != rsp.getTableInstance() || curTableType != rsp.getTableType()) continue;
            return rsp;
        }
        if (rsp != null) {
            this.ccnMessageLog.trace("\n****  createTablesRequest... return from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock + " blockLen= " + rsp.getBlockLen());
        }
        if (rsp == null) {
            this.ccnMessageLog.error("\n****  createTablesRequest... getBlockDataFromTable failed to get block from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock);
        }
        return rsp;
    }
}

