/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.point;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.messages.CcnChangeTableNameRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnOutputProxy;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BCcnFidOutputProxy
extends BCcnOutputProxy {
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnFidOutputProxy.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnFidOutputProxy() {
    }

    public BCcnFidOutputProxy(BCcnPointEntry entry) {
        super(entry);
        this.setDuplicatePointName(entry.getFieldName());
    }

    public void changed(Property changedProp, Context cx) {
        super.changed(changedProp, cx);
        if (!this.isRunning()) {
            return;
        }
        if (changedProp.getName().equalsIgnoreCase("fieldName")) {
            String newValue = this.getFieldName();
            if (newValue.trim().length() == 0 || !Character.isLetter(newValue.charAt(0))) {
                newValue = "P";
            }
            if (newValue.length() > 8) {
                newValue = newValue.substring(0, 8);
            }
            if (this.writeTableName(newValue)) {
                this.ccnPointsLog.trace("<CcnTable: asyncPropertyChange CcnChangeTableNameRequest name commit : " + newValue);
                this.setDuplicatePointName(newValue);
            }
            return;
        }
    }

    public boolean writeTableName(String name) {
        this.ccnPointsLog.trace(this.getDebugSummaryString() + "<CcnFidOutput: writeTableName - change the 0x501 table instance name associated with this point from: " + this.getFieldName() + " to: " + name);
        byte[] newName = name.getBytes();
        int busNum = this.getCcnDevice().getBusNo();
        int localAddr = this.getCcnDevice().getElemNo();
        int tableType = this.getTable().getTableType();
        int tableInstance = this.getFieldIndex() + 1;
        boolean blockNo = false;
        CcnTableDef tblDef = new CcnTableDef((byte)localAddr, (byte)busNum, newName, (short)tableType, (byte)tableInstance, (byte)(blockNo ? 1 : 0), 0, 0);
        CcnChangeTableNameRequest req = new CcnChangeTableNameRequest(tblDef);
        CcnResponseMessage rsp = this.getCcnDevice().getCcnNetwork().getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
        if (rsp != null) {
            this.ccnPointsLog.trace(this.getDebugSummaryString() + "rsp.getResponseCommand()=" + rsp.getResponseCommand() + "rsp.getBlockLen()=" + rsp.getBlockLen());
        }
        if (rsp == null) {
            this.ccnPointsLog.error("\n****  CcnFidOutput: " + this.getDebugSummaryString() + "CcnChangeTableNameRequest name change failed... response: " + (Object)((Object)rsp));
            return false;
        }
        if (rsp.getResponseCommand() == 21) {
            this.ccnPointsLog.trace("\n****  CcnFidOutput: " + this.getDebugSummaryString() + "CcnChangeTableNameRequest name change failed... response command: " + rsp.getResponseCommand() + " len: " + rsp.getBlockLen() + " responseBuffer: " + new String(ByteArrayUtil.toHexString((byte[])rsp.getResponseBuffer().getResponseData())));
            return false;
        }
        this.ccnPointsLog.trace("\n****  CcnFidOutput: " + this.getDebugSummaryString() + "CcnChangeTableNameRequest name change successfully completed");
        this.setFieldName(name);
        return true;
    }
}

