/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.point.BCcnPointDeviceExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.CcnUtil;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fieldIndex", type="int", defaultValue="0"), @NiagaraProperty(name="fieldName", type="String", defaultValue=""), @NiagaraProperty(name="fieldValue", type="String", defaultValue=""), @NiagaraProperty(name="pointDataType", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="dataTypeEnum", type="String", defaultValue="", flags=1), @NiagaraProperty(name="displayType", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="displayDigits", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="fieldByteCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="discreteTextOffset", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="configFlags", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="units", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="unitsEnum", type="String", defaultValue="", flags=1), @NiagaraProperty(name="valueBlock", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="valueBlockOffset", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="fieldStatus", type="String", defaultValue="", flags=1), @NiagaraProperty(name="forceLevel", type="String", defaultValue="", flags=1), @NiagaraProperty(name="loLimit", type="String", defaultValue="", flags=1), @NiagaraProperty(name="hiLimit", type="String", defaultValue="", flags=1), @NiagaraProperty(name="loLimitBlock", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="hiLimitBlock", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="loLimitBlockOffset", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="hiLimitBlockOffset", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="variableNo", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="description", type="String", defaultValue="", flags=1), @NiagaraProperty(name="forceableFlag", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="deviceType", type="int", defaultValue="0"), @NiagaraProperty(name="ctrlSensType", type="int", defaultValue="0"), @NiagaraProperty(name="duplicatePointName", type="String", defaultValue="", flags=4), @NiagaraProperty(name="eUC", type="String", defaultValue="", flags=4)})
public class BCcnProxyExt
extends BBasicProxyExt
implements CcnMessageConst {
    @Generated
    public static final Property fieldIndex = BCcnProxyExt.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property fieldName = BCcnProxyExt.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property fieldValue = BCcnProxyExt.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property pointDataType = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property dataTypeEnum = BCcnProxyExt.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property displayType = BCcnProxyExt.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property displayDigits = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property fieldByteCount = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property discreteTextOffset = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property configFlags = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property units = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property unitsEnum = BCcnProxyExt.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property valueBlock = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property valueBlockOffset = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property fieldStatus = BCcnProxyExt.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property forceLevel = BCcnProxyExt.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property loLimit = BCcnProxyExt.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property hiLimit = BCcnProxyExt.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property loLimitBlock = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property hiLimitBlock = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property loLimitBlockOffset = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property hiLimitBlockOffset = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property variableNo = BCcnProxyExt.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property description = BCcnProxyExt.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property forceableFlag = BCcnProxyExt.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property deviceType = BCcnProxyExt.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property ctrlSensType = BCcnProxyExt.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property duplicatePointName = BCcnProxyExt.newProperty((int)4, (String)"", null);
    @Generated
    public static final Property eUC = BCcnProxyExt.newProperty((int)4, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnProxyExt.class);
    private boolean added = false;
    private BCcnPocTable tParent = null;
    private BCcnPointEntry entry = null;
    private BCcnTable table = null;
    protected boolean pollOnceAtStartup = true;
    Log ccnPointsLog = Log.getLog((String)"CCNPointsLog");
    Log ccnTimeLog = Log.getLog((String)"CcnPerformanceLog");
    boolean isRegistered = false;

    @Generated
    public int getFieldIndex() {
        return this.getInt(fieldIndex);
    }

    @Generated
    public void setFieldIndex(int v) {
        this.setInt(fieldIndex, v, null);
    }

    @Generated
    public String getFieldName() {
        return this.getString(fieldName);
    }

    @Generated
    public void setFieldName(String v) {
        this.setString(fieldName, v, null);
    }

    @Generated
    public String getFieldValue() {
        return this.getString(fieldValue);
    }

    @Generated
    public void setFieldValue(String v) {
        this.setString(fieldValue, v, null);
    }

    @Generated
    public int getPointDataType() {
        return this.getInt(pointDataType);
    }

    @Generated
    public void setPointDataType(int v) {
        this.setInt(pointDataType, v, null);
    }

    @Generated
    public String getDataTypeEnum() {
        return this.getString(dataTypeEnum);
    }

    @Generated
    public void setDataTypeEnum(String v) {
        this.setString(dataTypeEnum, v, null);
    }

    @Generated
    public boolean getDisplayType() {
        return this.getBoolean(displayType);
    }

    @Generated
    public void setDisplayType(boolean v) {
        this.setBoolean(displayType, v, null);
    }

    @Generated
    public int getDisplayDigits() {
        return this.getInt(displayDigits);
    }

    @Generated
    public void setDisplayDigits(int v) {
        this.setInt(displayDigits, v, null);
    }

    @Generated
    public int getFieldByteCount() {
        return this.getInt(fieldByteCount);
    }

    @Generated
    public void setFieldByteCount(int v) {
        this.setInt(fieldByteCount, v, null);
    }

    @Generated
    public int getDiscreteTextOffset() {
        return this.getInt(discreteTextOffset);
    }

    @Generated
    public void setDiscreteTextOffset(int v) {
        this.setInt(discreteTextOffset, v, null);
    }

    @Generated
    public int getConfigFlags() {
        return this.getInt(configFlags);
    }

    @Generated
    public void setConfigFlags(int v) {
        this.setInt(configFlags, v, null);
    }

    @Generated
    public int getUnits() {
        return this.getInt(units);
    }

    @Generated
    public void setUnits(int v) {
        this.setInt(units, v, null);
    }

    @Generated
    public String getUnitsEnum() {
        return this.getString(unitsEnum);
    }

    @Generated
    public void setUnitsEnum(String v) {
        this.setString(unitsEnum, v, null);
    }

    @Generated
    public int getValueBlock() {
        return this.getInt(valueBlock);
    }

    @Generated
    public void setValueBlock(int v) {
        this.setInt(valueBlock, v, null);
    }

    @Generated
    public int getValueBlockOffset() {
        return this.getInt(valueBlockOffset);
    }

    @Generated
    public void setValueBlockOffset(int v) {
        this.setInt(valueBlockOffset, v, null);
    }

    @Generated
    public String getFieldStatus() {
        return this.getString(fieldStatus);
    }

    @Generated
    public void setFieldStatus(String v) {
        this.setString(fieldStatus, v, null);
    }

    @Generated
    public String getForceLevel() {
        return this.getString(forceLevel);
    }

    @Generated
    public void setForceLevel(String v) {
        this.setString(forceLevel, v, null);
    }

    @Generated
    public String getLoLimit() {
        return this.getString(loLimit);
    }

    @Generated
    public void setLoLimit(String v) {
        this.setString(loLimit, v, null);
    }

    @Generated
    public String getHiLimit() {
        return this.getString(hiLimit);
    }

    @Generated
    public void setHiLimit(String v) {
        this.setString(hiLimit, v, null);
    }

    @Generated
    public int getLoLimitBlock() {
        return this.getInt(loLimitBlock);
    }

    @Generated
    public void setLoLimitBlock(int v) {
        this.setInt(loLimitBlock, v, null);
    }

    @Generated
    public int getHiLimitBlock() {
        return this.getInt(hiLimitBlock);
    }

    @Generated
    public void setHiLimitBlock(int v) {
        this.setInt(hiLimitBlock, v, null);
    }

    @Generated
    public int getLoLimitBlockOffset() {
        return this.getInt(loLimitBlockOffset);
    }

    @Generated
    public void setLoLimitBlockOffset(int v) {
        this.setInt(loLimitBlockOffset, v, null);
    }

    @Generated
    public int getHiLimitBlockOffset() {
        return this.getInt(hiLimitBlockOffset);
    }

    @Generated
    public void setHiLimitBlockOffset(int v) {
        this.setInt(hiLimitBlockOffset, v, null);
    }

    @Generated
    public int getVariableNo() {
        return this.getInt(variableNo);
    }

    @Generated
    public void setVariableNo(int v) {
        this.setInt(variableNo, v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public boolean getForceableFlag() {
        return this.getBoolean(forceableFlag);
    }

    @Generated
    public void setForceableFlag(boolean v) {
        this.setBoolean(forceableFlag, v, null);
    }

    @Generated
    public int getDeviceType() {
        return this.getInt(deviceType);
    }

    @Generated
    public void setDeviceType(int v) {
        this.setInt(deviceType, v, null);
    }

    @Generated
    public int getCtrlSensType() {
        return this.getInt(ctrlSensType);
    }

    @Generated
    public void setCtrlSensType(int v) {
        this.setInt(ctrlSensType, v, null);
    }

    @Generated
    public String getDuplicatePointName() {
        return this.getString(duplicatePointName);
    }

    @Generated
    public void setDuplicatePointName(String v) {
        this.setString(duplicatePointName, v, null);
    }

    @Generated
    public String getEUC() {
        return this.getString(eUC);
    }

    @Generated
    public void setEUC(String v) {
        this.setString(eUC, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnProxyExt() {
    }

    public BCcnProxyExt(BCcnPointEntry entry) {
        this.entry = entry;
    }

    public final BCcnNetwork getCcnNetwork() {
        return (BCcnNetwork)this.getNetwork();
    }

    public final BCcnDevice getCcnDevice() {
        return (BCcnDevice)this.getDevice();
    }

    public final BCcnPointDeviceExt getCcnPointDeviceExt() {
        return (BCcnPointDeviceExt)this.getDeviceExt();
    }

    public Type getDeviceExtType() {
        return BCcnPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        int dataType = this.getPointDataType();
        if (this.getForceableFlag()) {
            switch (CcnUtil.getControlPointType(dataType)) {
                case 1: 
                case 2: 
                case 5: 
                case 9: {
                    return BReadWriteMode.readWrite;
                }
                case 10: 
                case 11: 
                case 14: 
                case 18: {
                    return BReadWriteMode.readonly;
                }
            }
            return BReadWriteMode.readonly;
        }
        if (this.getTable() != null && (this.getTable().isConfigurationType() || this.getTable().isSetpointType())) {
            switch (CcnUtil.getControlPointType(dataType)) {
                case 1: 
                case 2: 
                case 5: 
                case 9: {
                    return BReadWriteMode.readWrite;
                }
                case 10: 
                case 11: 
                case 14: 
                case 18: {
                    return BReadWriteMode.readonly;
                }
            }
            return BReadWriteMode.readonly;
        }
        switch (CcnUtil.getControlPointType(dataType)) {
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 18: {
                return BReadWriteMode.readonly;
            }
        }
        return BReadWriteMode.readonly;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isRunning()) {
            this.ccnPointsLog.message("The control point is not running - return");
            return;
        }
        try {
            this.setTuningPolicyName("BCcnPointTuningPolicy");
        }
        catch (Exception ex) {
            this.ccnPointsLog.message("Not able to set Point TuningPolicy");
        }
        if (!this.added) {
            this.table = this.getTable();
            if (this.table == null) {
                return;
            }
            this.table.addToPointArrays(this, this.getFieldIndex());
            this.added = true;
        }
    }

    public void stopped() throws Exception {
        try {
            this.table = this.getTable();
            if (this.table == null) {
                return;
            }
            this.table.removeFromPointArrays(this.getFieldIndex());
            if (this.table instanceof BCcnPicTable) {
                ((BCcnPicTable)this.table).setPointCreateCount(((BCcnPicTable)this.table).getPointCreateCount() - 1);
            } else if (this.table instanceof BCcnDataTable) {
                ((BCcnDataTable)this.table).setPointCreateCount(((BCcnDataTable)this.table).getPointCreateCount() - 1);
            } else if (this.table instanceof BCcnFidTable) {
                ((BCcnFidTable)this.table).setPointCreateCount(((BCcnFidTable)this.table).getPointCreateCount() - 1);
            }
            BCcnDevice device = this.getCcnDevice();
            if (device == null) {
                return;
            }
            this.setValueOutOfService(true);
            super.stopped();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSubscribed(Context cx) throws Exception {
        super.readSubscribed(cx);
        this.pollPointsRegister();
    }

    public void readUnsubscribed(Context cx) throws Exception {
        super.readUnsubscribed(cx);
        this.pollPointsUnRegister();
    }

    public void pollPointsRegister() {
        if (this.isRegistered) {
            return;
        }
        this.getTable().registerPollProxyExt(this);
        this.isRegistered = true;
    }

    public void pollPointsUnRegister() {
        this.getTable().unregisterPollProxyExt(this);
        this.isRegistered = false;
    }

    public boolean isParentLegal(BComponent[] parentage) throws LocalizableRuntimeException {
        for (int i = 0; i < parentage.length; ++i) {
            if (!(parentage[i] instanceof BCcnPicTable) && !(parentage[i] instanceof BCcnDataTable) && !(parentage[i] instanceof BCcnFidTable)) continue;
            return true;
        }
        throw new LocalizableRuntimeException("ccn", "CcnProxy.Drop");
    }

    public void setValueOutOfService(boolean flag) {
    }

    public boolean isDiscrete() {
        return (this.getConfigFlags() & 0x80) == 128;
    }

    public BCcnPointEntry makePointEntry() {
        BCcnPointEntry[] pointEntries;
        if (this.getTable() != null && (pointEntries = (BCcnPointEntry[])this.getTable().getPointList().getChildren(BCcnPointEntry.class)) != null && pointEntries.length > 0) {
            for (int i = 0; i < pointEntries.length; ++i) {
                if (pointEntries[i].getFieldIndex() != this.getFieldIndex()) continue;
                return pointEntries[i];
            }
        }
        return null;
    }

    public BCcnTable getTable() {
        if (this.table == null) {
            for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BCcnPicTable) && !(parent instanceof BCcnDataTable) && !(parent instanceof BCcnFidTable)) continue;
                this.table = (BCcnTable)parent;
                break;
            }
        }
        return this.table;
    }

    public String getDebugSummaryString() {
        BCcnTable t = this.table;
        BCcnDevice d = t.getCcnDevice();
        return " bus,elem,devName,tableName,ptName = " + d.getBusNo() + "," + d.getElemNo() + "," + t.getTableName() + "," + this.getFieldName() + " ";
    }

    public boolean isCommandable() {
        if (this.getForceableFlag()) {
            return !this.getForceLevel().equals("Service tool command ON") && !this.getForceLevel().equals("Internal safety override") && !this.getForceLevel().equals("Service tool override");
        }
        return false;
    }

    public BCcnPocTable getParentPoc() {
        if (this.tParent == null) {
            for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BCcnPocTable)) continue;
                this.tParent = (BCcnPocTable)parent;
                break;
            }
        }
        return this.tParent;
    }

    public boolean isFromLink(BLink[] links, int fwForceLevel) {
        boolean isFromLink = false;
        for (int tempCount = 0; tempCount < links.length; ++tempCount) {
            String linkName = links[tempCount].getTargetSlotName();
            String linkNum = linkName.substring(2);
            if (Integer.parseInt(linkNum) != fwForceLevel) continue;
            isFromLink = true;
            break;
        }
        return isFromLink;
    }

    public void doSet(BCcnProxyExt proxyExt, BStatusValue out) {
    }

    public void writeForceValue(float outVal, boolean bVal, BStatusValue out) {
    }

    public void autoValue(BCcnProxyExt proxyExt, boolean isFromLink) {
    }
}

