/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.enums.BCcnDiscreteStateEnum;
import com.tridium.ccn.enums.BCcnTableGroupTypeEnum;
import com.tridium.ccn.enums.BCcnUnitMappingEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspPicUtil;
import com.tridium.ccn.util.CcnRspTableUtil;
import com.tridium.ccn.util.CcnStringNumberConverter;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class CcnRspPicPocUtil
extends CcnRspTableUtil
implements CcnErrorCodes {
    public static int[] EXPECTED_PICPOC_TBL_TYPES = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24};

    public static String getFieldName(CcnResponseMessage rsp, int index) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (2 <= blockNo && blockNo <= 4) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int sBtye = CcnRspPicPocUtil.getStartOffset(index, 12) + 0;
            int nBytes = 8;
            return new String(CcnRspPicPocUtil.getSubByteArray(buf, sBtye, nBytes));
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getFieldName");
    }

    public static byte getDataType(CcnResponseMessage rsp, int index) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (2 <= blockNo && blockNo <= 4) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int sBtye = CcnRspPicPocUtil.getStartOffset(index, 12) + 8;
            return (byte)(buf[sBtye] & 0x7F);
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getDataType");
    }

    public static boolean getDisplayType(CcnResponseMessage rsp, int index) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (2 <= blockNo && blockNo <= 4) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int sBtye = CcnRspPicPocUtil.getStartOffset(index, 12) + 8;
            boolean displayType = false;
            if ((buf[sBtye] & 0x80) != 0) {
                displayType = true;
            }
            return displayType;
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getDisplayType");
    }

    public static byte getDisplayDigits(CcnResponseMessage rsp, int dataType, int index) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (2 <= blockNo && blockNo <= 4) {
            if (dataType == 12 || 16 <= dataType && dataType <= 34 || dataType == 51) {
                return 0;
            }
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int sBtye = CcnRspPicPocUtil.getStartOffset(index, 12) + 9;
            return buf[sBtye];
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getDisplayDigits");
    }

    public static byte getFieldByteCount(CcnResponseMessage rsp, byte dataType, int index) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (2 <= blockNo && blockNo <= 4) {
            byte dataLength;
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            switch (dataType) {
                case 0: 
                case 1: 
                case 9: 
                case 25: 
                case 49: 
                case 50: {
                    dataLength = 1;
                    break;
                }
                case 2: 
                case 10: 
                case 12: {
                    dataLength = 2;
                    break;
                }
                case 7: 
                case 48: 
                case 51: {
                    dataLength = 4;
                    break;
                }
                case 16: 
                case 17: 
                case 32: 
                case 33: 
                case 34: {
                    int sBtye = CcnRspPicPocUtil.getStartOffset(index, 12) + 9;
                    dataLength = buf[sBtye];
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    dataLength = 8;
                    break;
                }
                default: {
                    dataLength = 0;
                }
            }
            return dataLength;
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getFieldByteCount");
    }

    public static byte getDiscreteTextOffset(CcnResponseMessage rsp, int index) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (2 <= blockNo && blockNo <= 4) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int sBtye = CcnRspPicPocUtil.getStartOffset(index, 12) + 9;
            return buf[sBtye];
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getDiscreteTextOffset");
    }

    public static byte getConfigFlags(CcnResponseMessage rsp, int index) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (2 <= blockNo && blockNo <= 4) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int sBtye = CcnRspPicPocUtil.getStartOffset(index, 12) + 10;
            return buf[sBtye];
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getConfigFlags");
    }

    public static int getUnits(CcnResponseMessage rsp, int index) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (2 <= blockNo && blockNo <= 4) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int sBtye = CcnRspPicPocUtil.getStartOffset(index, 12) + 11;
            return buf[sBtye] & 0xFF;
        }
        throw new CcnException(6488167, "PicTable - Need block 2, 3, 4 to getUnits");
    }

    public static String getLimit(CcnResponseMessage rsp, int index, BCcnPointEntry entry) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (7 == blockNo || 8 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return CcnRspPicPocUtil.getNextValue(buf, index, entry);
        }
        throw new CcnException(6488167, "PicTable - Need block 7 or 8 to getLimit");
    }

    public static String getNextValue(byte[] buf, int index, BCcnPointEntry entry) {
        String stData;
        int bData = 0;
        int iData = 0;
        float fData = 0.0f;
        int dataType = entry.getPointDataType();
        int dataLength = entry.getFieldByteCount();
        int displayDigitsFrac = 0;
        if (!entry.isDiscrete()) {
            displayDigitsFrac = entry.getDisplayDigits() & 0xF;
        }
        int displayFlags = (entry.getDisplayDigits() & 0xF0) >> 4;
        index += 3;
        switch (dataType) {
            case 0: {
                String stDataNew;
                iData = buf[index];
                if (iData < 0) {
                    iData = 256 + iData;
                }
                if ((stDataNew = Integer.toBinaryString(iData)).length() == displayFlags) {
                    stData = stDataNew;
                    break;
                }
                String stDataFiller = "00000000";
                stDataFiller = stDataFiller.substring(stDataFiller.length() - displayFlags);
                stData = stDataFiller + stDataNew;
                stData = stData.substring(stData.length() - displayFlags);
                break;
            }
            case 1: 
            case 25: 
            case 49: 
            case 50: {
                iData = buf[index];
                if (iData < 0) {
                    iData = 256 + iData;
                }
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 2: {
                iData = buf[index] << 8 | buf[index + 1] & 0xFF;
                if (iData < 0) {
                    iData = 65536 + iData;
                }
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 6: {
                int man = buf[index + 1] << 8 | buf[index + 2] & 0xFF;
                byte exp = buf[index];
                fData = (float)((double)man * Math.pow(10.0, exp));
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(displayDigitsFrac);
                nf.setMinimumFractionDigits(displayDigitsFrac);
                ((DecimalFormat)nf).setGroupingSize(20);
                stData = nf.format(fData);
                break;
            }
            case 7: 
            case 48: {
                iData = buf[index] << 24 & 0xFF000000;
                iData |= buf[index + 1] << 16 & 0xFF0000;
                iData |= buf[index + 2] << 8 & 0xFF00;
                fData = Float.intBitsToFloat(iData |= buf[index + 3] & 0xFF);
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(displayDigitsFrac);
                nf.setMinimumFractionDigits(displayDigitsFrac);
                ((DecimalFormat)nf).setGroupingSize(20);
                stData = ((DecimalFormat)nf).format(fData);
                break;
            }
            case 9: {
                iData = bData = buf[index];
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 10: {
                iData = buf[index] << 8 | buf[index + 1] & 0xFF;
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 12: {
                byte hrs = buf[index];
                byte min = buf[index + 1];
                stData = hrs < 10 ? "0" + hrs : "" + hrs;
                stData = min < 10 ? stData + ":0" + min : stData + ":" + min;
                if (!stData.equalsIgnoreCase("24:00")) break;
                stData = "00:00";
                break;
            }
            case 17: {
                for (int i = 0; i < dataLength; ++i) {
                    byte di = buf[index + i];
                    int d2 = di >> 4 & 0xF;
                    int d1 = di & 0xF;
                    iData = iData * 100 + d2 * 10 + d1;
                }
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 16: 
            case 32: 
            case 33: 
            case 34: {
                stData = new String(CcnRspPicPocUtil.getSubByteArray(buf, index, dataLength));
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                stData = new String(CcnRspPicPocUtil.getSubByteArray(buf, index, 8));
                break;
            }
            case 51: {
                byte hrs1 = buf[index];
                byte min1 = buf[index + 1];
                byte hrs2 = buf[index + 2];
                byte min2 = buf[index + 3];
                String st1 = hrs1 < 10 ? "0" + hrs1 : "" + hrs1;
                st1 = min1 < 10 ? st1 + ":0" + min1 : st1 + ":" + min1;
                String st2 = hrs2 < 10 ? "0" + hrs2 : "" + hrs2;
                st2 = min2 < 10 ? st2 + ":0" + min2 : st2 + ":" + min2;
                stData = "" + st1 + " " + st2;
                break;
            }
            default: {
                stData = "Invalid data type";
            }
        }
        if (entry.isDiscrete()) {
            if (stData.trim().indexOf("1") == -1) {
                return "0";
            }
            return "1";
        }
        if (entry.getDisplayType() && (dataType == 1 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 9 || dataType == 10 || dataType == 17 || dataType == 48)) {
            stData = CcnRspPicUtil.toMetric(entry.getDisplayDigits(), entry.getUnits(), stData);
        }
        return stData.trim();
    }

    public static String getNextValue(byte[] buf, int index, BCcnProxyExt proxy) {
        String stData;
        int bData = 0;
        int iData = 0;
        float fData = 0.0f;
        int dataType = proxy.getPointDataType();
        int dataLength = proxy.getFieldByteCount();
        int displayDigitsFrac = 0;
        if (!proxy.isDiscrete()) {
            displayDigitsFrac = proxy.getDisplayDigits() & 0xF;
        }
        int displayFlags = (proxy.getDisplayDigits() & 0xF0) >> 4;
        index += 3;
        switch (dataType) {
            case 0: {
                String stDataNew;
                iData = buf[index];
                if (iData < 0) {
                    iData = 256 + iData;
                }
                if ((stDataNew = Integer.toBinaryString(iData)).length() == displayFlags) {
                    stData = stDataNew;
                    break;
                }
                String stDataFiller = "00000000";
                stDataFiller = stDataFiller.substring(stDataFiller.length() - displayFlags);
                stData = stDataFiller + stDataNew;
                stData = stData.substring(stData.length() - displayFlags);
                break;
            }
            case 1: 
            case 25: 
            case 49: 
            case 50: {
                iData = buf[index];
                if (iData < 0) {
                    iData = 256 + iData;
                }
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 2: {
                iData = buf[index] << 8 | buf[index + 1] & 0xFF;
                if (iData < 0) {
                    iData = 65536 + iData;
                }
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 6: {
                int man = buf[index + 1] << 8 | buf[index + 2] & 0xFF;
                byte exp = buf[index];
                fData = (float)((double)man * Math.pow(10.0, exp));
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(displayDigitsFrac);
                nf.setMinimumFractionDigits(displayDigitsFrac);
                ((DecimalFormat)nf).setGroupingSize(20);
                stData = nf.format(fData);
                break;
            }
            case 7: 
            case 48: {
                iData = buf[index] << 24 & 0xFF000000;
                iData |= buf[index + 1] << 16 & 0xFF0000;
                iData |= buf[index + 2] << 8 & 0xFF00;
                fData = Float.intBitsToFloat(iData |= buf[index + 3] & 0xFF);
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(displayDigitsFrac);
                nf.setMinimumFractionDigits(displayDigitsFrac);
                ((DecimalFormat)nf).setGroupingSize(20);
                stData = ((DecimalFormat)nf).format(fData);
                break;
            }
            case 9: {
                iData = bData = buf[index];
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 10: {
                iData = buf[index] << 8 | buf[index + 1] & 0xFF;
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 12: {
                byte hrs = buf[index];
                byte min = buf[index + 1];
                stData = hrs < 10 ? "0" + hrs : "" + hrs;
                stData = min < 10 ? stData + ":0" + min : stData + ":" + min;
                if (!stData.equalsIgnoreCase("24:00")) break;
                stData = "00:00";
                break;
            }
            case 17: {
                for (int i = 0; i < dataLength; ++i) {
                    byte di = buf[index + i];
                    int d2 = di >> 4 & 0xF;
                    int d1 = di & 0xF;
                    iData = iData * 100 + d2 * 10 + d1;
                }
                stData = CcnRspPicPocUtil.integerImpliedDecimals(iData, displayDigitsFrac);
                break;
            }
            case 16: 
            case 32: 
            case 33: 
            case 34: {
                stData = new String(CcnRspPicPocUtil.getSubByteArray(buf, index, dataLength));
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                stData = new String(CcnRspPicPocUtil.getSubByteArray(buf, index, 8));
                break;
            }
            case 51: {
                byte hrs1 = buf[index];
                byte min1 = buf[index + 1];
                byte hrs2 = buf[index + 2];
                byte min2 = buf[index + 3];
                String st1 = hrs1 < 10 ? "0" + hrs1 : "" + hrs1;
                st1 = min1 < 10 ? st1 + ":0" + min1 : st1 + ":" + min1;
                String st2 = hrs2 < 10 ? "0" + hrs2 : "" + hrs2;
                st2 = min2 < 10 ? st2 + ":0" + min2 : st2 + ":" + min2;
                stData = "" + st1 + " " + st2;
                break;
            }
            default: {
                stData = "Invalid data type";
            }
        }
        if (proxy.isDiscrete()) {
            if (stData.trim().indexOf("1") == -1) {
                return "0";
            }
            return "1";
        }
        if (proxy.getDisplayType() && (dataType == 1 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 9 || dataType == 10 || dataType == 17 || dataType == 48)) {
            stData = CcnRspPicUtil.toMetric(proxy.getDisplayDigits(), proxy.getUnits(), stData);
        }
        return stData.trim();
    }

    private static String integerImpliedDecimals(int iData, int decimals) {
        if (decimals == 0) {
            return Integer.valueOf(iData).toString();
        }
        float tempf = iData;
        float divisor = (float)decimals * 10.0f;
        return Float.valueOf(tempf /= divisor).toString();
    }

    private static String integerImpliedDecimals(String sData, int decimals) {
        if (decimals == 0) {
            return sData;
        }
        float tempf = Float.valueOf(sData).floatValue();
        float multipler = (float)decimals * 10.0f;
        return Float.valueOf(tempf *= multipler).toString();
    }

    public static String toMetric(int displayDigits, int dataUnit, String _value) {
        if (_value == null || _value.trim().equals("")) {
            return _value;
        }
        double slopM = BCcnUnitMappingEnum.getSlopM(dataUnit);
        double offsetC = BCcnUnitMappingEnum.getOffsetC(dataUnit);
        int decimalAdjust = BCcnUnitMappingEnum.getDecimalAdjust(dataUnit);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits((displayDigits & 0xF) + decimalAdjust);
        nf.setMinimumFractionDigits((displayDigits & 0xF) + decimalAdjust);
        ((DecimalFormat)nf).setGroupingSize(20);
        Double valueD = Double.valueOf(_value);
        double mValue = valueD * slopM + offsetC;
        return nf.format(mValue);
    }

    public static String toImperial(int displayDigits, int dataUnit, String _value) {
        if (_value == null || _value.trim().equals("")) {
            return _value;
        }
        double slopM = BCcnUnitMappingEnum.getSlopM(dataUnit);
        double offsetC = BCcnUnitMappingEnum.getOffsetC(dataUnit);
        int decimalAdjust = BCcnUnitMappingEnum.getDecimalAdjust(dataUnit);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits((displayDigits & 0xF) - decimalAdjust);
        nf.setMinimumFractionDigits((displayDigits & 0xF) - decimalAdjust);
        ((DecimalFormat)nf).setGroupingSize(20);
        Double valueD = Double.valueOf(_value);
        double mValue = (valueD - offsetC) / slopM;
        return nf.format(mValue);
    }

    public static String convertToImperial(int configFlags, boolean displayType, int displayDigits, int units, String _value) {
        if ((configFlags & 0x80) == 128) {
            return _value;
        }
        if (displayType) {
            return CcnRspPicPocUtil.toImperial(displayDigits, units, _value);
        }
        return _value;
    }

    public static String convertToImperial(BCcnProxyExt entry) {
        String newValue = entry.getFieldValue();
        int dataType = entry.getPointDataType();
        if (entry.isDiscrete()) {
            if (newValue.equalsIgnoreCase("1")) {
                return "1";
            }
            if (newValue.equalsIgnoreCase("0")) {
                return "0";
            }
        } else if (entry.getDisplayType() && (dataType == 1 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 9 || dataType == 10 || dataType == 17 || dataType == 48)) {
            return CcnRspPicPocUtil.toImperial(entry.getDisplayDigits(), entry.getUnits(), entry.getFieldValue());
        }
        return newValue;
    }

    public static String convertToImperial(BCcnPointEntry entry) {
        String newValue = entry.getPointValue();
        int dataType = entry.getPointDataType();
        if (entry.isDiscrete()) {
            if (newValue.equalsIgnoreCase("1")) {
                return "1";
            }
            if (newValue.equalsIgnoreCase("0")) {
                return "0";
            }
        } else if (entry.getDisplayType() && (dataType == 1 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 9 || dataType == 10 || dataType == 17 || dataType == 48)) {
            return CcnRspPicPocUtil.toImperial(entry.getDisplayDigits(), entry.getUnits(), entry.getPointValue());
        }
        return newValue;
    }

    public static boolean checkRange(String _val, BCcnProxyExt entry) {
        float fVal;
        int dataType = entry.getPointDataType();
        boolean bLoLimit = true;
        boolean bHiLimit = true;
        if (dataType == 12) {
            int mm;
            int hh;
            if (_val.indexOf(":") != -1) {
                hh = Integer.parseInt(_val.substring(0, _val.indexOf(":")));
                mm = Integer.parseInt(_val.substring(_val.indexOf(":") + 1));
            } else {
                int tempInt = Float.valueOf(_val).intValue();
                hh = tempInt / 100;
                mm = tempInt % 100;
            }
            if (hh > 24 || hh < 0 || mm > 60 || mm < 0) {
                return false;
            }
            return hh != 24 || mm <= 0;
        }
        if (dataType == 51) {
            int mm2;
            int hh2;
            int mm1;
            int hh1;
            if (_val.indexOf(":") != -1) {
                int p1 = _val.indexOf(":");
                int p2 = _val.indexOf(" ");
                int p3 = _val.lastIndexOf(":");
                hh1 = Integer.parseInt(_val.substring(0, p1));
                mm1 = Integer.parseInt(_val.substring(p1 + 1, p2).trim());
                hh2 = Integer.parseInt(_val.substring(p2 + 1, p3).trim());
                mm2 = Integer.parseInt(_val.substring(p3 + 1));
            } else {
                int tempInt = Float.valueOf(_val).intValue();
                hh1 = tempInt / 10000 / 100;
                mm1 = tempInt / 10000 % 100;
                hh2 = tempInt % 10000 / 100;
                mm2 = tempInt % 10000 % 100;
            }
            return hh1 <= 24 && hh1 >= 0 && hh2 <= 24 && hh2 >= 0 && mm1 <= 60 && mm1 >= 0 && mm2 <= 60 && mm2 >= 0;
        }
        if ((entry.getConfigFlags() & 0x80) == 128) {
            return true;
        }
        if (dataType == 0) {
            return true;
        }
        if (entry.getLoLimit() != null && !entry.getLoLimit().trim().equals("")) {
            if (dataType == 1 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 9 || dataType == 10 || dataType == 25 || dataType == 48 || dataType == 49 || dataType == 50) {
                float loLimit;
                fVal = CcnStringNumberConverter.getFloat(_val);
                bLoLimit = !(fVal < (loLimit = CcnStringNumberConverter.getFloat(entry.getLoLimit())));
            }
        } else {
            bLoLimit = true;
        }
        if (entry.getHiLimit() != null && !entry.getHiLimit().trim().equals("")) {
            if (dataType == 1 || dataType == 2 || dataType == 6 || dataType == 7 || dataType == 9 || dataType == 10 || dataType == 25 || dataType == 48 || dataType == 49 || dataType == 50) {
                float hiLimit;
                fVal = CcnStringNumberConverter.getFloat(_val);
                bHiLimit = !(fVal > (hiLimit = CcnStringNumberConverter.getFloat(entry.getHiLimit())));
            }
        } else {
            bHiLimit = true;
        }
        return bLoLimit && bHiLimit;
    }

    public static String getDescription(CcnResponseMessage rsp, int index) throws CcnException {
        CcnRspPicPocUtil.checkTableType(rsp.getTableType(), EXPECTED_PICPOC_TBL_TYPES);
        int blockNo = CcnRspPicPocUtil.parseBlockNo(rsp);
        if (10 <= blockNo && blockNo <= 15) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            int sBtye = CcnRspPicPocUtil.getStartOffset(index, 24) + 0;
            int nBytes = 24;
            return new String(CcnRspPicPocUtil.getSubByteArray(buf, sBtye, nBytes));
        }
        throw new CcnException(6488167, "PicPocTable - Need block 10-15 to getDescription");
    }

    protected static int getStartOffset(int index, int size) throws CcnException {
        if (0 <= index && index <= 59) {
            return 3 + index % (240 / size) * size;
        }
        throw new CcnException(6488269, "Field index must be between 0-59");
    }

    public static String getActiveText(int discreteTextOffset) {
        return CcnEnumsUtil.setProperDiscreteOffset(BCcnDiscreteStateEnum.parseId(discreteTextOffset, 1));
    }

    public static String getInActiveText(int discreteTextOffset) {
        return CcnEnumsUtil.setProperDiscreteOffset(BCcnDiscreteStateEnum.parseId(discreteTextOffset, 0));
    }

    public static byte[] mergeNewValue(byte[] data, int offset, int dataType, int dataLength, String newValue, byte[] bArray, BCcnPointEntry tempPoint) {
        offset += 3;
        switch (dataType) {
            case 0: {
                if (newValue != null) {
                    data[offset] = (byte)Integer.parseInt(newValue, 2);
                    break;
                }
                data[offset] = bArray[0];
                break;
            }
            case 1: 
            case 9: 
            case 25: 
            case 49: 
            case 50: {
                if (newValue != null) {
                    int displayDigitsFrac = 0;
                    if (!tempPoint.isDiscrete()) {
                        displayDigitsFrac = tempPoint.getDisplayDigits() & 0xF;
                    }
                    String tNewValue = CcnRspPicPocUtil.integerImpliedDecimals(newValue, displayDigitsFrac);
                    data[offset] = (byte)CcnStringNumberConverter.getInt(tNewValue);
                    break;
                }
                data[offset] = bArray[0];
                break;
            }
            case 2: 
            case 10: {
                if (newValue != null) {
                    int displayDigitsFrac = 0;
                    if (!tempPoint.isDiscrete()) {
                        displayDigitsFrac = tempPoint.getDisplayDigits() & 0xF;
                    }
                    String tNewValue = CcnRspPicPocUtil.integerImpliedDecimals(newValue, displayDigitsFrac);
                    int iValue = CcnStringNumberConverter.getInt(tNewValue);
                    data[offset] = (byte)(iValue >> 8 & 0xFF);
                    data[offset + 1] = (byte)(iValue & 0xFF);
                    break;
                }
                data[offset] = bArray[0];
                data[offset + 1] = bArray[1];
                break;
            }
            case 7: 
            case 48: {
                if (newValue != null) {
                    Float fData = Float.valueOf(CcnStringNumberConverter.getFloat(newValue));
                    int intBit = Float.floatToIntBits(fData.floatValue());
                    data[offset] = (byte)(intBit >> 24 & 0xFF);
                    data[offset + 1] = (byte)(intBit >> 16 & 0xFF);
                    data[offset + 2] = (byte)(intBit >> 8 & 0xFF);
                    data[offset + 3] = (byte)(intBit & 0xFF);
                    break;
                }
                data[offset] = bArray[0];
                data[offset + 1] = bArray[1];
                data[offset + 2] = bArray[2];
                data[offset + 3] = bArray[3];
                break;
            }
            case 12: {
                if (newValue != null) {
                    String hh = newValue.substring(0, newValue.indexOf(":"));
                    String mm = newValue.substring(newValue.indexOf(":") + 1);
                    int iValue = Integer.valueOf(hh);
                    data[offset] = (byte)(iValue & 0xFF);
                    iValue = Integer.valueOf(mm);
                    data[offset + 1] = (byte)(iValue & 0xFF);
                    break;
                }
                data[offset] = bArray[0];
                data[offset + 1] = bArray[1];
                break;
            }
            case 17: {
                if (newValue != null) {
                    int displayDigitsFrac = 0;
                    if (!tempPoint.isDiscrete()) {
                        displayDigitsFrac = tempPoint.getDisplayDigits() & 0xF;
                    }
                    String tNewValue = CcnRspPicPocUtil.integerImpliedDecimals(newValue, displayDigitsFrac);
                    int iNewValue = Integer.parseInt(tNewValue, 16);
                    for (int i = 0; i < dataLength; ++i) {
                        data[offset + i] = (byte)(iNewValue >> (dataLength - i - 1) * 8 & 0xFF);
                    }
                } else {
                    for (int i = 0; i < dataLength; ++i) {
                        data[offset + i] = bArray[i];
                    }
                }
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 33: 
            case 34: {
                int sLen = dataLength;
                if (newValue != null) {
                    int i;
                    byte[] newByte = newValue.getBytes();
                    if (newByte.length < dataLength) {
                        sLen = newByte.length;
                    }
                    for (i = 0; i < sLen; ++i) {
                        data[offset + i] = newByte[i];
                    }
                    for (i = sLen; i < dataLength; ++i) {
                        data[offset + i] = 0;
                    }
                } else {
                    int i;
                    if (bArray.length < dataLength) {
                        sLen = bArray.length;
                    }
                    for (i = 0; i < sLen; ++i) {
                        data[offset + i] = bArray[i];
                    }
                    for (i = sLen; i < dataLength; ++i) {
                        data[offset + i] = 0;
                    }
                }
                break;
            }
            case 51: {
                if (newValue != null) {
                    int p1 = newValue.indexOf(":");
                    int p2 = newValue.indexOf(" ");
                    int p3 = newValue.lastIndexOf(":");
                    String hh1 = newValue.substring(0, p1);
                    String mm1 = newValue.substring(p1 + 1, p2).trim();
                    String hh2 = newValue.substring(p2 + 1, p3).trim();
                    String mm2 = newValue.substring(p3 + 1);
                    newValue = hh1 + mm1 + hh2 + mm2;
                    int iValue = Integer.valueOf(newValue);
                    data[offset] = (byte)(iValue >> 24 & 0xFF);
                    data[offset + 1] = (byte)(iValue >> 16 & 0xFF);
                    data[offset + 2] = (byte)(iValue >> 8 & 0xFF);
                    data[offset + 3] = (byte)(iValue & 0xFF);
                    break;
                }
                data[offset] = bArray[0];
                data[offset + 1] = bArray[1];
                data[offset + 2] = bArray[2];
                data[offset + 3] = bArray[3];
                break;
            }
            default: {
                System.out.println("Invalid data type");
            }
        }
        return data;
    }

    public static byte[] mergeNewValue(byte[] data, int offset, int dataType, int dataLength, String newValue, byte[] bArray, BCcnProxyExt tempPoint) {
        offset += 3;
        switch (dataType) {
            case 0: {
                if (newValue != null) {
                    data[offset] = (byte)Integer.parseInt(newValue, 2);
                    break;
                }
                data[offset] = bArray[0];
                break;
            }
            case 1: 
            case 9: 
            case 25: 
            case 49: 
            case 50: {
                if (newValue != null) {
                    int displayDigitsFrac = 0;
                    if (!tempPoint.isDiscrete()) {
                        displayDigitsFrac = tempPoint.getDisplayDigits() & 0xF;
                    }
                    String tNewValue = CcnRspPicPocUtil.integerImpliedDecimals(newValue, displayDigitsFrac);
                    data[offset] = (byte)CcnStringNumberConverter.getInt(tNewValue);
                    break;
                }
                data[offset] = bArray[0];
                break;
            }
            case 2: 
            case 10: {
                if (newValue != null) {
                    int displayDigitsFrac = 0;
                    if (!tempPoint.isDiscrete()) {
                        displayDigitsFrac = tempPoint.getDisplayDigits() & 0xF;
                    }
                    String tNewValue = CcnRspPicPocUtil.integerImpliedDecimals(newValue, displayDigitsFrac);
                    int iValue = CcnStringNumberConverter.getInt(tNewValue);
                    data[offset] = (byte)(iValue >> 8 & 0xFF);
                    data[offset + 1] = (byte)(iValue & 0xFF);
                    break;
                }
                data[offset] = bArray[0];
                data[offset + 1] = bArray[1];
                break;
            }
            case 7: 
            case 48: {
                if (newValue != null) {
                    Float fData = Float.valueOf(CcnStringNumberConverter.getFloat(newValue));
                    int intBit = Float.floatToIntBits(fData.floatValue());
                    data[offset] = (byte)(intBit >> 24 & 0xFF);
                    data[offset + 1] = (byte)(intBit >> 16 & 0xFF);
                    data[offset + 2] = (byte)(intBit >> 8 & 0xFF);
                    data[offset + 3] = (byte)(intBit & 0xFF);
                    break;
                }
                data[offset] = bArray[0];
                data[offset + 1] = bArray[1];
                data[offset + 2] = bArray[2];
                data[offset + 3] = bArray[3];
                break;
            }
            case 12: {
                if (newValue != null) {
                    String hh = newValue.substring(0, newValue.indexOf(":"));
                    String mm = newValue.substring(newValue.indexOf(":") + 1);
                    int iValue = Integer.valueOf(hh);
                    data[offset] = (byte)(iValue & 0xFF);
                    iValue = Integer.valueOf(mm);
                    data[offset + 1] = (byte)(iValue & 0xFF);
                    break;
                }
                data[offset] = bArray[0];
                data[offset + 1] = bArray[1];
                break;
            }
            case 17: {
                if (newValue != null) {
                    int displayDigitsFrac = 0;
                    if (!tempPoint.isDiscrete()) {
                        displayDigitsFrac = tempPoint.getDisplayDigits() & 0xF;
                    }
                    String tNewValue = CcnRspPicPocUtil.integerImpliedDecimals(newValue, displayDigitsFrac);
                    int iNewValue = Integer.parseInt(tNewValue, 16);
                    for (int i = 0; i < dataLength; ++i) {
                        data[offset + i] = (byte)(iNewValue >> (dataLength - i - 1) * 8 & 0xFF);
                    }
                } else {
                    for (int i = 0; i < dataLength; ++i) {
                        data[offset + i] = bArray[i];
                    }
                }
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 33: 
            case 34: {
                int sLen = dataLength;
                if (newValue != null) {
                    int i;
                    byte[] newByte = newValue.getBytes();
                    if (newByte.length < dataLength) {
                        sLen = newByte.length;
                    }
                    for (i = 0; i < sLen; ++i) {
                        data[offset + i] = newByte[i];
                    }
                    for (i = sLen; i < dataLength; ++i) {
                        data[offset + i] = 0;
                    }
                } else {
                    int i;
                    if (bArray.length < dataLength) {
                        sLen = bArray.length;
                    }
                    for (i = 0; i < sLen; ++i) {
                        data[offset + i] = bArray[i];
                    }
                    for (i = sLen; i < dataLength; ++i) {
                        data[offset + i] = 0;
                    }
                }
                break;
            }
            case 51: {
                if (newValue != null) {
                    int p1 = newValue.indexOf(":");
                    int p2 = newValue.indexOf(" ");
                    int p3 = newValue.lastIndexOf(":");
                    String hh1 = newValue.substring(0, p1);
                    String mm1 = newValue.substring(p1 + 1, p2).trim();
                    String hh2 = newValue.substring(p2 + 1, p3).trim();
                    String mm2 = newValue.substring(p3 + 1);
                    newValue = hh1 + mm1 + hh2 + mm2;
                    int iValue = Integer.valueOf(newValue);
                    data[offset] = (byte)(iValue >> 24 & 0xFF);
                    data[offset + 1] = (byte)(iValue >> 16 & 0xFF);
                    data[offset + 2] = (byte)(iValue >> 8 & 0xFF);
                    data[offset + 3] = (byte)(iValue & 0xFF);
                    break;
                }
                data[offset] = bArray[0];
                data[offset + 1] = bArray[1];
                data[offset + 2] = bArray[2];
                data[offset + 3] = bArray[3];
                break;
            }
            default: {
                System.out.println("Invalid data type");
            }
        }
        return data;
    }

    public static String getTableTypeString(int tableType) {
        if (tableType == 16 || tableType == 20) {
            return BCcnTableGroupTypeEnum.UserConfiguration.getTag();
        }
        if (tableType == 17) {
            return BCcnTableGroupTypeEnum.StatusDisplay.getTag();
        }
        if (tableType == 19 || tableType == 22) {
            return BCcnTableGroupTypeEnum.ServiceConfiguration.getTag();
        }
        if (tableType == 23 || tableType == 24) {
            return BCcnTableGroupTypeEnum.SetPoints.getTag();
        }
        if (tableType == 18 || tableType == 21) {
            return BCcnTableGroupTypeEnum.Maintenance.getTag();
        }
        if (tableType == 67) {
            return BCcnTableGroupTypeEnum.AlarmHistory.getTag();
        }
        return BCcnTableGroupTypeEnum.Generic.getTag();
    }
}

