/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.enums.BCcnAlarmStatusEnum;
import com.tridium.ccn.enums.BCcnForceStatusEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspPicPocUtil;

public final class CcnRspPicUtil
extends CcnRspPicPocUtil
implements CcnErrorCodes {
    public static int[] EXPECTED_PIC_TBL_TYPES = new int[]{16, 17, 18, 19, 23};

    public static void setProxyReadStatus(byte status, BCcnProxyExt proxy) {
        int _status = status & 7;
        if (proxy instanceof BCcnInputProxy) {
            BCcnInputProxy inputProxy = (BCcnInputProxy)proxy;
            if (inputProxy.isDiscrete() && _status == 3) {
                _status += 2;
            }
            if (_status > 5) {
                _status = 0;
            }
            BCcnAlarmStatusEnum alarmStatusEnum = BCcnAlarmStatusEnum.make(_status);
            int _force = status >> 4 & 0xF;
            BCcnForceStatusEnum forceLevelEnum = BCcnForceStatusEnum.make(_force);
            inputProxy.setForceLevel(CcnEnumsUtil.setProperForceLevel(forceLevelEnum.getTag()));
            if (_force == 4) {
                inputProxy.setOverridden(true);
            } else {
                inputProxy.setOverridden(false);
            }
            String alarmStatus = alarmStatusEnum.getTag().equalsIgnoreCase("normal") ? "" : (alarmStatusEnum.getTag().equalsIgnoreCase("HardwareCommError") ? "COMM..." : alarmStatusEnum.getTag());
            inputProxy.setFieldStatus(alarmStatus);
        }
    }

    public static void setProxyReadValue(CcnResponseMessage rsp, int index, BCcnProxyExt proxy) {
        int blockNo;
        if (CcnRspPicUtil.isTableType(rsp.getTableType(), EXPECTED_PIC_TBL_TYPES) && proxy instanceof BCcnInputProxy && 5 == (blockNo = CcnRspPicUtil.parseBlockNo(rsp))) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            String strValue = CcnRspPicUtil.getNextValue(buf, index, proxy);
            ((BCcnInputProxy)proxy).setValue(strValue);
        }
    }

    public static String getValue(CcnResponseMessage rsp, int index, BCcnProxyExt entry) throws CcnException {
        CcnRspPicUtil.checkTableType(rsp.getTableType(), EXPECTED_PIC_TBL_TYPES);
        int blockNo = CcnRspPicUtil.parseBlockNo(rsp);
        if (5 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return CcnRspPicUtil.getNextValue(buf, index, entry);
        }
        throw new CcnException(6488167, "PicTable - Need block 5 to getValue");
    }

    public static String getValue(CcnResponseMessage rsp, int index, BCcnPointEntry entry) throws CcnException {
        CcnRspPicUtil.checkTableType(rsp.getTableType(), EXPECTED_PIC_TBL_TYPES);
        int blockNo = CcnRspPicUtil.parseBlockNo(rsp);
        if (5 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return CcnRspPicUtil.getNextValue(buf, index, entry);
        }
        throw new CcnException(6488167, "PicTable - Need block 5 to getValue");
    }

    public static void setStatus(CcnResponseMessage rsp, BCcnProxyExt proxy) throws CcnException {
        if (rsp != null && rsp.getResponseBuffer() != null && rsp.getResponseBuffer().getResponseData() != null) {
            CcnRspPicUtil.checkTableType(rsp.getTableType(), EXPECTED_PIC_TBL_TYPES);
            int blockNo = CcnRspPicUtil.parseBlockNo(rsp);
            if (6 == blockNo) {
                byte[] buf = rsp.getResponseBuffer().getResponseData();
                CcnRspPicUtil.setProxyReadStatus(buf[3 + proxy.getFieldIndex()], proxy);
            }
        }
    }

    public static byte getStatus(CcnResponseMessage rsp, int index) throws CcnException {
        CcnRspPicUtil.checkTableType(rsp.getTableType(), EXPECTED_PIC_TBL_TYPES);
        int blockNo = CcnRspPicUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return buf[3 + index];
        }
        throw new CcnException(6488167, "PicTable - Need block 6 to getStatus");
    }

    public static int getVariableNum(CcnResponseMessage rsp, int index) throws CcnException {
        CcnRspPicUtil.checkTableType(rsp.getTableType(), EXPECTED_PIC_TBL_TYPES);
        int blockNo = CcnRspPicUtil.parseBlockNo(rsp);
        if (9 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return ((buf[3 + index * 2] & 0xFF) << 8 | buf[3 + index * 2 + 1] & 0xFF) & 0xFFFF;
        }
        throw new CcnException(6488167, "PicTable - Need block 9 to getVariableNum");
    }
}

