/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.util.Queue;
import javax.baja.log.Log;

public abstract class MessageQueueHelper
implements Runnable {
    private Queue myQueue;
    private boolean stopService;
    private int fullCount = 0;
    private static final Log ccnNetworkLog = Log.getLog((String)"CCNNetworkLog");

    public void init() {
        this.myQueue = new Queue(this.getName(), this.getQueueSize());
    }

    public void start() {
        this.stopService = false;
        Thread thread = new Thread((Runnable)this, this.getName() + "Thread");
        thread.start();
    }

    public void stop() {
        this.stopService = true;
        try {
            this.myQueue.enqueue(null);
        }
        catch (Exception e) {
            ccnNetworkLog.error("Exception occurred requesting service stop", (Throwable)e);
        }
    }

    public void cleanup() {
        this.myQueue = null;
    }

    protected abstract String getName();

    protected abstract void processMsg(Object var1);

    protected int getQueueSize() {
        return 16;
    }

    protected void writeQueue(Object msg) {
        try {
            this.myQueue.enqueue(msg, false);
            this.fullCount = 0;
        }
        catch (Exception e) {
            ccnNetworkLog.error("Exception occurred writing message to Queue in MessageQueueHelper", (Throwable)e);
        }
    }

    @Override
    public void run() {
        block2: while (true) {
            try {
                while (true) {
                    Object msg = this.myQueue.dequeue();
                    if (this.stopService) break block2;
                    this.processMsg(msg);
                }
            }
            catch (Exception e) {
                ccnNetworkLog.error("Exception occurred processing message in MessageQueueHelper", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

