/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

public class Queue {
    private Object[] queue;
    private int queueSize;
    private int front = 0;
    private int back = 1;
    private String name;

    public Queue(String name, int queueSize) {
        this.name = name;
        this.queueSize = queueSize + 1;
        this.queue = new Object[this.queueSize];
    }

    public String getName() {
        return this.name;
    }

    public synchronized Object dequeue() {
        return this.dequeue(-1L);
    }

    public synchronized Object dequeue(long timeout) {
        Object object = null;
        while (this.isEmpty()) {
            try {
                if (timeout == -1L) {
                    this.wait();
                } else {
                    this.wait(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (timeout == -1L || !this.isEmpty()) continue;
            return null;
        }
        this.front = (this.front + 1) % this.queueSize;
        object = this.queue[this.front];
        this.queue[this.front] = null;
        this.notifyAll();
        return object;
    }

    public synchronized Object[] dequeueInBulk(long timeout) {
        if (this.isEmpty()) {
            Object[] result = new Object[]{this.dequeue(timeout)};
            if (result[0] == null) {
                return null;
            }
            return result;
        }
        int size = this.size();
        if (size < 1) {
            throw new IllegalArgumentException("Queue size is less than 1?");
        }
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.dequeue(0L);
        }
        return result;
    }

    public synchronized Object[] dequeueInBulk() {
        return this.dequeueInBulk(-1L);
    }

    public synchronized int size() {
        if (this.front == this.back) {
            return this.queueSize - 1;
        }
        if (this.back < this.front) {
            return this.back + (this.queueSize - 1) - this.front;
        }
        return this.back - (this.front + 1);
    }

    public synchronized void enqueue(Object object, boolean block) throws Exception {
        if (this.isFull()) {
            if (block) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Object[] args = new Object[]{this.name};
                    throw new Exception("Enqueue Interrupted");
                }
            } else {
                throw new Exception("Queue Full");
            }
        }
        this.queue[this.back] = object;
        this.back = (this.back + 1) % this.queueSize;
        this.notifyAll();
    }

    public void enqueue(Object object) throws Exception {
        this.enqueue(object, false);
    }

    public synchronized boolean isFull() {
        return this.front == this.back;
    }

    public synchronized boolean isEmpty() {
        return (this.front + 1) % this.queueSize == this.back;
    }
}

