/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.queryTable;

import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.status.BStatus;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class TypeSpecPath {
    public BTypeSpec typeSpec;
    public String path;
    public String alias;
    public BIQueryFilter defaultFilter;
    public BExpression function;
    public static final Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(TypeSpecPath.class).getModuleName());
    public static final TypeSpecPath NAME = new TypeSpecPath(BString.TYPE.getTypeSpec(), "name");
    public static final TypeSpecPath DISPLAY_NAME = new TypeSpecPath(BString.TYPE.getTypeSpec(), "displayName");
    public static final TypeSpecPath TO_DISPLAY_PATH_STRING = new TypeSpecPath(BString.TYPE.getTypeSpec(), "toDisplayPathString");
    public static final TypeSpecPath PARENT_TO_DISPLAY_PATH_STRING = new TypeSpecPath(BString.TYPE.getTypeSpec(), "parent.toDisplayPathString");
    public static final TypeSpecPath STATUS = new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "status");
    public static final TypeSpecPath SLOT_PATH = new TypeSpecPath(BString.TYPE.getTypeSpec(), "slotPath");
    public static final TypeSpecPath PARENT_COMPONENT_SLOT_PATH = new TypeSpecPath(BString.TYPE.getTypeSpec(), "parentComponent.slotPath");
    public static final TypeSpecPath PARENT_NAME = new TypeSpecPath(BString.TYPE.getTypeSpec(), "parent.name");

    public TypeSpecPath(Property p) {
        this(p.getType().getTypeSpec(), p.getName(), p.getDefaultDisplayName(null));
    }

    public TypeSpecPath(BTypeSpec typeSpec, String path) {
        this.typeSpec = typeSpec;
        this.path = path;
        this.setDefaultDisplayName(path);
    }

    public TypeSpecPath(BTypeSpec typeSpec, String path, String alias) {
        this.typeSpec = typeSpec;
        this.path = path;
        this.setDefaultDisplayName(path, alias);
    }

    public TypeSpecPath(BTypeSpec typeSpec, String path, String alias, BExpression function) {
        this.typeSpec = typeSpec;
        this.function = function;
        this.path = path;
        this.setDefaultDisplayName(path, alias);
    }

    public TypeSpecPath(BTypeSpec typeSpec, String path, String alias, BIQueryFilter defaultFilter) {
        this.typeSpec = typeSpec;
        this.defaultFilter = defaultFilter;
        this.setDefaultDisplayName(path, alias);
    }

    public void setDefaultDisplayName(String path) {
        this.setDefaultDisplayName(path, null);
    }

    public void setDefaultDisplayName(String path, String alias) {
        this.alias = alias != null ? alias : lex.getText(path);
    }

    public String toString() {
        if (this.alias == null) {
            throw new IllegalStateException("alias must not be null");
        }
        return this.alias;
    }

    public String encodeToString() {
        return this.typeSpec + "!" + this.path + "!" + this.alias;
    }

    public static TypeSpecPath decodeFromString(String encoded) {
        String[] split = TextUtil.split((String)encoded, (char)'!');
        TypeSpecPath typeSpecPath = new TypeSpecPath(BTypeSpec.make((String)split[0]), split[1], split[2]);
        return typeSpecPath;
    }
}

