/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.queryTable.hx;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.queryTable.hx.BHxQueryTableView;
import com.tridium.queryTable.ui.BQueryTableOptions;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.HxOptionsManager;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.filter.BHxFilterSheet;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.query.BQuery;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.ui.options.BOptions;

public class FilterCommand
extends SmartCommand {
    private FilterDialog dlg = new FilterDialog((Command)this);

    public FilterCommand(BHxView view) {
        super(view, smartTableHxLexModule);
    }

    public String getName(HxOp op) {
        return "filter";
    }

    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public BQuery getQuery(HxOp op) {
        return ((BHxQueryTableView)this.getView()).getQuery(op);
    }

    public boolean readonlyEnablePolicy(HxOp op) {
        return true;
    }

    public boolean isTableCommand(HxOp op) {
        return true;
    }

    public BImage getIcon(HxOp op) {
        BQuery query = this.getQuery(op);
        BQueryTableOptions options = (BQueryTableOptions)new HxOptionsManager(op).load(BQueryTableOptions.TYPE);
        BFilterSet filterSet = options.getFilterSet(query);
        if (filterSet == null || !BQueryTableOptions.anyVisibleActive(filterSet)) {
            return super.getIcon(op);
        }
        return this.getHighlightedIcon(op);
    }

    public BImage getHighlightedIcon(HxOp op) {
        return BImage.make((String)this.lexModule.getText(this.getLexName(op) + ".highlightedIcon", (Context)op));
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        BHxFilterSheet fe = BHxFilterSheet.INSTANCE;
        BQuery query = this.getQuery(op);
        BQueryTableOptions options = (BQueryTableOptions)new HxOptionsManager(op).load(BQueryTableOptions.TYPE);
        BFilterSet filterSet = options.getFilterSet(query);
        if (filterSet == null || !BQueryTableOptions.isFilterSetValid(query, filterSet)) {
            filterSet = BQueryTableOptions.rebuildFilterSet(query, filterSet, (Context)op);
            options.setFilterSet(query, filterSet);
        }
        HxOp fieldOp = op.make("filter", (BObject)filterSet, null);
        return fe.process(fieldOp);
    }

    public final void handle(HxOp op) throws Exception {
        if (!((BHxSmartTableView)this.getView()).isEnabled(op)) {
            return;
        }
        if (!this.dlg.isSubmit(op)) {
            this.dlg.open(op);
            return;
        }
        BQuery query = this.getQuery(op);
        BQueryTableOptions options = (BQueryTableOptions)new HxOptionsManager(op).load(BQueryTableOptions.TYPE);
        BFilterSet filterSet = options.getFilterSet(query);
        if (filterSet == null || !BQueryTableOptions.isFilterSetValid(query, filterSet)) {
            filterSet = BQueryTableOptions.rebuildFilterSet(query, filterSet, (Context)op);
            options.setFilterSet(query, filterSet);
        }
        boolean active = filterSet != null && filterSet.anyActive();
        BHxFilterSheet fe = BHxFilterSheet.INSTANCE;
        HxOp fieldOp = op.make("filter", (BObject)filterSet, null);
        BFilterSet save = (BFilterSet)fe.save(fieldOp);
        options.setFilterSet(query, save);
        new HxOptionsManager(op).save((BOptions)options);
        boolean newActive = save != null && save.anyActive();
        HtmlWriter out = op.getHtmlWriter();
        if (newActive && !active) {
            this.updateImage(this.getHighlightedIcon(op), op);
        } else if (!newActive && active) {
            this.updateImage(this.getIcon(op), op);
        }
        ((BHxQueryTableView)this.getView()).reloadTable(op);
    }

    class FilterDialog
    extends Dialog {
        public FilterDialog(Command handler) {
            super(handler);
        }

        protected String getTitle(HxOp op) {
            return FilterCommand.this.getDisplayName(op);
        }

        protected void writeContent(HxOp op) throws Exception {
            BQuery query = FilterCommand.this.getQuery(op);
            BQueryTableOptions options = (BQueryTableOptions)new HxOptionsManager(op).load(BQueryTableOptions.TYPE);
            BFilterSet filterSet = options.getFilterSet(query);
            if (filterSet == null || !BQueryTableOptions.isFilterSetValid(query, filterSet)) {
                filterSet = BQueryTableOptions.rebuildFilterSet(query, filterSet, (Context)op);
                options.setFilterSet(query, filterSet);
                new HxOptionsManager(op).save((BOptions)options);
            }
            BHxFilterSheet fe = BHxFilterSheet.INSTANCE;
            fe.write(op.make("filter", (BObject)filterSet, null));
        }
    }
}

