/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.ui;

import com.tridium.maxpro.camera.BMaxproCamera;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.BIRemoteVideoSource;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.rtsp.RtpPacket;
import javax.baja.rtsp.RtpStream;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import org.baja.ffmpeg.enums.BCodecIdEnum;
import org.baja.ffmpeg.videoDriver.FfmpegVideoDecoder;

public class MaxproRtspDecoder
extends FfmpegVideoDecoder {
    BPlaybackParams playbackParams;
    ByteBuffer videoFrameBuffer = new ByteBuffer();
    public static final Logger dataLog = Logger.getLogger("maxpro.RtspDecoder");
    protected int bgAlpha = 180;
    protected int fgAlpha = 250;
    private int numNullPackets = 0;
    private String sdpString;
    private static final byte[] START_CODE_PREFIX = new byte[]{0, 0, 0, 1};
    private static final byte FRAGMENTED_UNIT_TYPE_A = 28;
    private static final int MAX_NULL_PACKETS = 100;
    byte[] sequenceParameterSet = new byte[0];
    byte[] pictureParameterSet = new byte[0];
    RtpPacket packet1 = null;
    boolean isSPSReceived = false;

    public MaxproRtspDecoder(BCodecIdEnum codecSelected, BPlaybackParams playbackParams) {
        super(codecSelected);
        this.playbackParams = playbackParams;
        this.isSPSReceived = false;
    }

    public void readFrameData(VidFrame vf) throws Exception {
        try {
            this.videoFrameBuffer.reset();
            vf.rawData = this.videoFrameBuffer;
            this.readH264Data(vf);
            Thread.sleep(50L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RtpStream helpGetInputStream() {
        return (RtpStream)this.videoIn;
    }

    synchronized void readH264Data(VidFrame vf) throws Exception {
        block16: {
            int payloadLength;
            byte[] rtpPayload;
            RtpStream stream = this.helpGetInputStream();
            int numNullPackets = 0;
            while (true) {
                this.packet1 = stream.readPacket();
                while (this.packet1 == null) {
                    this.packet1 = stream.readPacket();
                }
                if (this.packet1 == null) {
                    if (numNullPackets++ <= 100) continue;
                    if (dataLog.isLoggable(Level.FINE)) {
                        dataLog.fine("packet is NULL && RESET MAX_NULL_PACKETS. Writing to vf " + this.videoFrameBuffer.getLength());
                    }
                    break block16;
                }
                int seq_num = this.packet1.seq_num;
                rtpPayload = this.packet1.payload;
                if (rtpPayload == null || rtpPayload.length == 0) continue;
                byte firstPayloadByte = rtpPayload[0];
                byte secondPayloadByte = rtpPayload[1];
                int start_bit = secondPayloadByte & 0x80;
                int end_bit = secondPayloadByte & 0x40;
                payloadLength = this.packet1.pay_length;
                if ((firstPayloadByte & 0x1F) != 28 || rtpPayload.length < 2) continue;
                numNullPackets = 0;
                if (start_bit == 128) {
                    int nal_type = -1;
                    if (rtpPayload[2] == 0 && rtpPayload[3] == 0 && rtpPayload[4] == 1) {
                        nal_type = rtpPayload[5] & 0x1F;
                    } else if (rtpPayload[2] == 0 && rtpPayload[3] == 0 && rtpPayload[4] == 0 && rtpPayload[5] == 1) {
                        nal_type = rtpPayload[6] & 0x1F;
                    }
                    if (dataLog.isLoggable(Level.FINE)) {
                        dataLog.fine("RTP Packet with NAL Type : " + nal_type + " Seq : " + seq_num);
                    }
                    if (nal_type == 7) {
                        if (this.videoFrameBuffer.available() > 0) {
                            if (dataLog.isLoggable(Level.FINE)) {
                                dataLog.fine("bytes in videoframeBuffer : " + this.videoFrameBuffer.available() + ". SHOULDN'T THIS BE RESET & EMPTY HERE. HENCE RESET");
                            }
                            this.videoFrameBuffer.reset();
                        }
                        if (dataLog.isLoggable(Level.FINE)) {
                            dataLog.fine("Writing SPS, PPS to the Video Frame buffer for the first time. Seq : " + seq_num);
                        }
                        this.videoFrameBuffer.write(new byte[]{0});
                        this.videoFrameBuffer.write(rtpPayload, 2, payloadLength - 2);
                        this.isSPSReceived = true;
                    } else {
                        if (!this.isSPSReceived) continue;
                        if (dataLog.isLoggable(Level.FINE)) {
                            dataLog.fine("RTP Packet with Non-IDR frame after SPS is received. Just adding to the buffer for Seq : " + seq_num);
                        }
                        this.videoFrameBuffer.write(new byte[]{0});
                        this.videoFrameBuffer.write(rtpPayload, 2, payloadLength - 2);
                    }
                }
                if (start_bit == 0 && end_bit == 0 && this.isSPSReceived) {
                    this.videoFrameBuffer.write(rtpPayload, 2, payloadLength - 2);
                }
                if (start_bit == 0 && end_bit == 64 && this.isSPSReceived) break;
            }
            this.videoFrameBuffer.write(rtpPayload, 2, payloadLength - 2);
        }
        this.addLog("End of while loop. returning to the decoder with bytes : " + this.videoFrameBuffer.available());
    }

    private synchronized boolean checkNextPacketSps(RtpPacket pkt) {
        if (pkt == null) {
            return false;
        }
        byte[] rtpPayload = pkt.payload;
        if (rtpPayload == null || rtpPayload.length == 0) {
            return false;
        }
        byte firstPayloadByte = rtpPayload[0];
        byte secondPayloadByte = rtpPayload[1];
        int start_bit = secondPayloadByte & 0x80;
        int end_bit = secondPayloadByte & 0x40;
        if ((firstPayloadByte & 0x1F) == 28 && rtpPayload.length >= 2) {
            if (start_bit == 128) {
                int nal_type = -1;
                if (rtpPayload[2] == 0 && rtpPayload[3] == 0 && rtpPayload[4] == 1) {
                    nal_type = rtpPayload[5] & 0x1F;
                } else if (rtpPayload[2] == 0 && rtpPayload[3] == 0 && rtpPayload[4] == 0 && rtpPayload[5] == 1) {
                    nal_type = rtpPayload[6] & 0x1F;
                }
                return nal_type == 7;
            }
            return false;
        }
        return false;
    }

    private void addLog(String content) {
    }

    private void extractParamaterSets() {
        RtpStream stream = this.helpGetInputStream();
        this.sdpString = stream.session.sdpString;
        if (!this.sdpString.equals("")) {
            String[] sdpTokens = TextUtil.splitAndTrim((String)this.sdpString, (char)'\n');
            for (int i = 0; i < sdpTokens.length; ++i) {
                String sdpToken = sdpTokens[i];
                String[] subTokens = TextUtil.splitAndTrim((String)sdpToken, (char)';');
                boolean found = false;
                for (int j = 0; j < subTokens.length; ++j) {
                    int index = subTokens[j].indexOf("sprop-parameter-sets");
                    if (index == -1) continue;
                    String subToken = subTokens[j];
                    String sprop_value = subToken.substring(subToken.indexOf("=") + 1);
                    String spsString = sprop_value.substring(0, sprop_value.indexOf(","));
                    String ppsString = sprop_value.substring(sprop_value.indexOf(",") + 1);
                    if (dataLog.isLoggable(Level.FINE)) {
                        dataLog.fine("SPS String received through RTSP Session : " + spsString);
                        dataLog.fine("PPS String received through RTSP Session : " + ppsString);
                    }
                    this.sequenceParameterSet = Base64.getDecoder().decode(spsString);
                    this.pictureParameterSet = Base64.getDecoder().decode(ppsString);
                    found = true;
                    break;
                }
                if (found) break;
            }
        }
    }

    private void extractSpsPps(byte[] payload) throws Exception {
        ByteBuffer spsBuffer = new ByteBuffer();
        ByteBuffer ppsBuffer = new ByteBuffer();
        int count = 2;
        boolean isSpsRead = false;
        boolean isPpsRead = false;
        spsBuffer.write(0);
        while (!isSpsRead || !isPpsRead) {
            if (payload[count] == 0 && payload[count + 1] == 0 && payload[count + 2] == 0 && payload[count + 3] == 1) {
                if (!isSpsRead) {
                    isSpsRead = true;
                } else if (!isPpsRead) {
                    isPpsRead = true;
                    break;
                }
            }
            if (!isSpsRead) {
                spsBuffer.write((int)payload[count]);
            } else if (!isPpsRead) {
                ppsBuffer.write((int)payload[count]);
            }
            ++count;
        }
        this.sequenceParameterSet = spsBuffer.toByteArray();
        this.pictureParameterSet = ppsBuffer.toByteArray();
    }

    public BIVideoSource getVideoSource(BIVideoSource videoSource) {
        if (videoSource instanceof BMaxproCamera) {
            return (BMaxproCamera)videoSource;
        }
        if (videoSource instanceof BIRemoteVideoCamera) {
            try {
                BIRemoteVideoCamera remoteCamera = (BIRemoteVideoCamera)videoSource;
                BIRemoteVideoSource remoteVideoSource = (BIRemoteVideoSource)remoteCamera.getRemoteVideoOrd().get((BObject)videoSource);
                return remoteVideoSource.getVideoSource();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        if (videoSource instanceof BIRemoteVideoSource) {
            BIRemoteVideoSource remoteVideoSource = (BIRemoteVideoSource)videoSource;
            return remoteVideoSource.getVideoSource();
        }
        throw new BajaRuntimeException("uknown source:" + videoSource.getType());
    }

    public void stopDecoding(WaitForStopDecoding stopMonitor) {
        super.stopDecoding(stopMonitor);
        BMaxproCamera camera = (BMaxproCamera)this.getVideoSource(this.videoSource);
        camera.closeStream(camera.getRtspStreadId());
    }
}

