/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.timezone.BDstSupportLevel;
import com.tridium.util.CommandLineArguments;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
@NiagaraSingleton
public class BSetTimeCommand
extends BDaemonSessionCommand {
    @Generated
    public static final BSetTimeCommand INSTANCE = new BSetTimeCommand();
    @Generated
    public static final Type TYPE = Sys.loadType(BSetTimeCommand.class);
    private static final Logger log = Logger.getLogger("settime");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BSetTimeCommand() {
    }

    public String getCommandName() {
        return "settime";
    }

    public String getCommandDescription() {
        return "set the system time and time zone for a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public boolean includeInCommandListing() {
        return false;
    }

    public void usage() {
        BSetTimeCommand.println((String)"", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"usage:", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  plat settime <flags> <utcMillis> <timeZone>", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"parameters:", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  utcMillis                UTC millis time for remote host", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  timeZone                 IANA Time Zone identifier for remote host", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"required flags:", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  -h:<hostord>             ORD for the remote host", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  -usr:<userName>          user name for the host's platform daemon", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  -pwd:<password>          password for the host's platform daemon", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  -noinput                 if given, command will fail when username\n                             and password are missing or incorrect,\n                             instead of prompting and reading them\n                             from stdin", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  -p:<port>                port for the host's platform daemon\n                             if omitted, default port 3011 or 5011 is used", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  -secure                  if given, the connection will be encrypted with TLS", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  -locale:<x>              set the default locale (en_US)", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  -@<option>               pass option to Java VM", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"  -buildreg                force rebuild of the registry", (Object[])new Object[0]);
        BSetTimeCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        long utcMillis;
        if (args.hasHelpOption() || args.parameters.length < 2) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        String utcMillisString = args.parameters[0];
        String ianaTimeZoneString = args.parameters[1];
        try {
            utcMillis = Long.parseLong(utcMillisString);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Invalid UTC millis specified", e);
            this.usage();
            return 2;
        }
        try {
            TimeZone.getTimeZone(ianaTimeZoneString);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Invalid IANA Time Zone ID specified", e);
            this.usage();
            return 2;
        }
        BDstSupportLevel supportLevel = session.getHostProperties().getTimezoneDayModeSupport();
        if (supportLevel != BDstSupportLevel.full) {
            log.log(Level.SEVERE, "Host does not support full time zones (BDstSupportLevel == " + supportLevel + ")");
            return 4;
        }
        BDaemonAccessLevel accessLevel = session.getHostProperties().getAccessLevel();
        if (session.getHostProperties().getAccessLevel() != BDaemonAccessLevel.full) {
            log.log(Level.SEVERE, "Host does not support setting time (BDaemonAccessLevel == " + accessLevel + ")");
            return 4;
        }
        BTimeZone updateTimeZone = BTimeZone.getTimeZone((String)ianaTimeZoneString);
        BAbsTime updatedTime = BAbsTime.make((long)utcMillis, (BTimeZone)updateTimeZone);
        try {
            DaemonTimeUtil.updateLocalTime((BDaemonSession)session, (BAbsTime)updatedTime, (String)ianaTimeZoneString, (BTimeZone)updateTimeZone);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to update time on remote host", e);
            return 4;
        }
        return 0;
    }
}

