/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.TellStationMessage;
import com.tridium.util.CommandLineArguments;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraSingleton
public class BTellStationCommand
extends BDaemonSessionCommand {
    @Generated
    public static final BTellStationCommand INSTANCE = new BTellStationCommand();
    @Generated
    public static final Type TYPE = Sys.loadType(BTellStationCommand.class);
    private static final Logger log = Logger.getLogger("tellstation");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BTellStationCommand() {
    }

    public String getCommandName() {
        return "tellstation";
    }

    public String getCommandDescription() {
        return "send text to the console of a running Niagara Station";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbenchAzul";
    }

    public void usage() {
        BTellStationCommand.println((String)"", (Object[])new Object[0]);
        BTellStationCommand.println((String)"usage:", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  plat tellstation <flags> <stationname> <message>", (Object[])new Object[0]);
        BTellStationCommand.println((String)"parameters:", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  stationname              name of the station which gets the message", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  message                  text to send to the station's console.  If", (Object[])new Object[0]);
        BTellStationCommand.println((String)"                             the text has whitespace, it should be quoted", (Object[])new Object[0]);
        BTellStationCommand.println((String)"required flags:", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -h:<hostord>             ORD for the remote host", (Object[])new Object[0]);
        BTellStationCommand.println((String)"optional flags:", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -usr:<userName>          user name for the host's platform daemon", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -pwd:<password>          password for the host's platform daemon", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -noinput                 if given, command will fail when username\n                             and password are missing or incorrect,\n                             instead of prompting and reading them\n                             from stdin", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -p:<port>                port for the host's platform daemon\n                             if omitted, default port 3011 or 5011 is used", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -secure                  if given, the connection will be encrypted with TLS", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -locale:<x>              set the default locale (en_US)", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -@<option>               pass option to Java VM", (Object[])new Object[0]);
        BTellStationCommand.println((String)"  -buildreg                force rebuild of the registry", (Object[])new Object[0]);
        BTellStationCommand.println((String)"", (Object[])new Object[0]);
    }

    public int invoke(CommandLineArguments args) throws Exception {
        if (args.hasHelpOption() || args.parameters.length < 2) {
            this.usage();
            return 2;
        }
        BDaemonSession session = this.getSession(args);
        if (session == null) {
            this.usage();
            return 2;
        }
        String stationName = args.parameters[0];
        String message = args.parameters[1];
        session.sendMessage((DaemonMessage)new TellStationMessage(stationName, message));
        log.info("message sent to " + stationName);
        return 0;
    }
}

