/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonProTransform.functions;

import java.util.List;
import java.util.Map;
import javax.baja.seriestransform.exceptions.SourceException;
import javax.baja.seriestransform.exceptions.TransformException;
import javax.baja.seriestransform.graph.BTransformFunction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class BQuotientFunction
extends BTransformFunction {
    public static final Type TYPE = Sys.loadType(BQuotientFunction.class);
    private static final Lexicon lex = Lexicon.make(BQuotientFunction.class);
    private static final String FUNCTION_NAME = lex.getText("functions.name.quotient");
    private static final String FUNCTION_DESC = lex.getText("functions.desc.quotient");

    public Type getType() {
        return TYPE;
    }

    public void applyFunction(Map<String, List<? extends BComplex>> series, String[] srcProps, Property dstSlot, BComplex resultRecord) throws TransformException {
        BDouble dividend = null;
        BDouble divisor = null;
        BDouble quotient = null;
        BUnit dstUnits = BQuotientFunction.getUnits((Property)dstSlot);
        Object srcUnits = null;
        BFacets srcFacets = null;
        for (String name : srcProps) {
            String seriesName = BQuotientFunction.getSeriesName((String)name);
            String fieldName = BQuotientFunction.getFieldName((String)name);
            List records = this.getSeriesRecords(series, seriesName);
            for (BComplex record : records) {
                BNumber check;
                Property srcProp = record.getProperty(fieldName);
                srcFacets = srcProp.getFacets();
                if (srcFacets != null && srcFacets.getFacet("dividend") != null) {
                    try {
                        check = this.sumValues((BNumber)dividend, record, srcProp, dstUnits);
                        if (check.equals((Object)BDouble.NaN)) continue;
                        dividend = check;
                    }
                    catch (SourceException e) {
                        dividend = BDouble.NaN;
                    }
                    continue;
                }
                if (srcFacets == null || srcFacets.getFacet("divisor") == null) continue;
                try {
                    check = this.sumValues((BNumber)divisor, record, srcProp, dstUnits);
                    if (check.equals((Object)BDouble.NaN)) continue;
                    divisor = check;
                }
                catch (SourceException e) {
                    divisor = BDouble.NaN;
                }
            }
        }
        try {
            BNumber check = this.divideValues((BNumber)dividend, (BNumber)divisor);
            if (!check.equals((Object)BDouble.NaN)) {
                quotient = check;
            }
        }
        catch (Exception e) {
            quotient = BDouble.NaN;
        }
        BQuotientFunction.setRecordValue((BComplex)resultRecord, (Property)dstSlot, (BValue)quotient);
    }

    protected BNumber sumValues(BNumber curSum, BComplex source, Property field, BUnit dstUnits) throws SourceException {
        BUnit origUnits;
        BValue value = source.get(field);
        BFacets facets = field.getFacets();
        BUnit bUnit = origUnits = facets != null ? (BUnit)facets.get("units") : BUnit.NULL;
        if (value instanceof BNumber) {
            BNumber number = BQuotientFunction.convertToUnits((BNumber)((BNumber)value), (BUnit)origUnits, (BUnit)dstUnits);
            curSum = null == curSum ? number : this.addValues(number, curSum);
        }
        return curSum;
    }

    protected BNumber addValues(BNumber a, BNumber b) {
        if (null == a || null == b || Double.isNaN(a.getNumeric()) || Double.isNaN(b.getNumeric())) {
            return BDouble.NaN;
        }
        if (a instanceof BDouble) {
            return BDouble.make((double)(a.getDouble() + b.getDouble()));
        }
        if (a instanceof BFloat) {
            return BFloat.make((float)(a.getFloat() + b.getFloat()));
        }
        if (a instanceof BLong) {
            return BLong.make((long)(a.getLong() + b.getLong()));
        }
        if (a instanceof BInteger) {
            return BInteger.make((int)(a.getInt() + b.getInt()));
        }
        return BDouble.make((double)(a.getDouble() + b.getDouble()));
    }

    protected BNumber divideValues(BNumber a, BNumber b) {
        if (null == a || null == b || b.getNumeric() == 0.0 || Double.isNaN(a.getNumeric()) || Double.isNaN(b.getNumeric())) {
            return BDouble.NaN;
        }
        if (a instanceof BDouble) {
            return BDouble.make((double)(a.getDouble() / b.getDouble()));
        }
        if (a instanceof BFloat) {
            return BFloat.make((float)(a.getFloat() / b.getFloat()));
        }
        if (a instanceof BLong) {
            return BLong.make((long)(a.getLong() / b.getLong()));
        }
        if (a instanceof BInteger) {
            return BInteger.make((int)(a.getInt() / b.getInt()));
        }
        return BDouble.make((double)(a.getDouble() / b.getDouble()));
    }

    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    public String getFunctionDesc() {
        return FUNCTION_DESC;
    }

    public Type getReturnType() {
        return BNumber.TYPE;
    }

    public Type[] getArgumentTypes() {
        return new Type[]{BNumber.TYPE};
    }
}

