/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.json.JSONObject;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nss.dashboard.BFoxSecurityDashboardChannel;
import com.tridium.nss.dashboard.BSecurityDashboardDataImport;
import com.tridium.nss.dashboard.DashboardException;
import com.tridium.nss.dashboard.DashboardNotSupportedException;
import com.tridium.nss.dashboard.IRemoteDashboardDataRetriever;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Context;
import javax.baja.util.LexiconModule;
import javax.baja.util.Version;

public abstract class AbstractFoxRemoteDashboardDataRetriever
implements IRemoteDashboardDataRetriever,
BFoxClientConnection.Interest {
    protected static final Logger LOGGER = Logger.getLogger("securityDashboard");
    protected static final LexiconModule LEX_MOD = LexiconModule.make((String)"nss");
    protected final BSecurityDashboardDataImport importDescriptor;

    public AbstractFoxRemoteDashboardDataRetriever(BSecurityDashboardDataImport importDescriptor) {
        this.importDescriptor = importDescriptor;
    }

    @Override
    public JSONObject getRemoteDashboardData(Context cx) throws DashboardException {
        if (!this.importDescriptor.isRunning()) {
            return null;
        }
        this.checkRemoteVersion();
        BNiagaraStation niagaraStation = this.getNiagaraStation();
        try {
            try {
                niagaraStation.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
            }
            catch (Exception e) {
                String message = LEX_MOD.getText("foxDataRetriever.connectionFailed", null, new Object[]{e.getMessage()});
                LOGGER.log(Level.FINE, message, e);
                throw new DashboardException(message, e);
            }
            this.checkRemoteStationForNssModule();
            this.checkRemoteStationForSecurityService();
            BFoxSecurityDashboardChannel foxChannel = this.getFoxChannel();
            if (foxChannel == null) {
                throw new DashboardException(LEX_MOD.get("foxDataRetriever.noDashboardChannelFound", null));
            }
            try {
                JSONObject message = this.getRemoteStationDashboardInfo(foxChannel);
                return message;
            }
            catch (Exception e) {
                String message = LEX_MOD.getText("foxDataRetriever.retrievalFailed", null, new Object[]{e.getMessage()});
                LOGGER.log(Level.FINE, message, e);
                throw new DashboardException(message, e);
            }
        }
        finally {
            if (niagaraStation.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                niagaraStation.getClientConnection().disengage((BFoxClientConnection.Interest)this);
            }
        }
    }

    protected abstract void checkRemoteVersion() throws DashboardNotSupportedException;

    protected abstract void checkRemoteStationForNssModule() throws DashboardNotSupportedException;

    protected abstract void checkRemoteStationForSecurityService() throws DashboardNotSupportedException;

    protected abstract JSONObject getRemoteStationDashboardInfo(BFoxSecurityDashboardChannel var1) throws Exception;

    private BFoxSecurityDashboardChannel getFoxChannel() {
        return (BFoxSecurityDashboardChannel)this.getNiagaraStation().getClientConnection().getChannels().get("securityDashboard", BFoxSecurityDashboardChannel.TYPE);
    }

    protected BSysChannel getSysChannel() {
        return (BSysChannel)this.getNiagaraStation().getClientConnection().getChannels().get("sys", BSysChannel.TYPE);
    }

    protected BDataChannel getDataChannel() {
        return (BDataChannel)this.getNiagaraStation().getClientConnection().getChannels().get("data", BDataChannel.TYPE);
    }

    protected BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.importDescriptor.getDevice();
    }

    protected void checkForNssModule(String ... reachableStationRoute) throws DashboardNotSupportedException {
        BSysChannel sysChannel = this.getSysChannel();
        boolean remoteNss = true;
        try {
            String key = "nss";
            byte[] versionBytes = sysChannel.stationCall("module.version", key.getBytes(), reachableStationRoute);
            remoteNss = !"0".equals(new String(versionBytes));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!remoteNss) {
            throw new DashboardNotSupportedException(LEX_MOD.get("foxDataRetriever.remoteStationHasNoNss", null));
        }
    }

    protected Version getRemoteVersion() {
        String remoteVersion = this.getNiagaraStation().getVersion();
        return remoteVersion.isEmpty() ? new Version("0") : new Version(remoteVersion);
    }
}

