/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.NiagaraPolicyUtil;
import com.tridium.nss.dashboard.ModuleSecurityInfoProvider;
import com.tridium.sys.module.DefaultModulesFileManager;
import com.tridium.sys.module.ManagedModuleFile;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"nss:SecurityService"})})
public final class BSecurityDashboardModulePermissions
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSecurityDashboardModulePermissions.class);
    private static final String SEVERE_PERMISSIONS_SUMMARY = "securityDashboard.severeModulePermissionGroup.summary";
    private static final String MODERATE_PERMISSIONS_SUMMARY = "securityDashboard.moderateModulePermissionGroup.summary";
    private static final String MILD_PERMISSIONS_SUMMARY = "securityDashboard.mildModulePermissionGroup.summary";
    private static final String OK_SEVERE_PERMISSIONS_SUMMARY = "securityDashboard.okSevereModulePermissionGroup.summary";
    private static final String OK_MODERATE_PERMISSIONS_SUMMARY = "securityDashboard.okModerateModulePermissionGroup.summary";
    private static final String OK_MILD_PERMISSIONS_SUMMARY = "securityDashboard.okMildModulePermissionGroup.summary";
    private static final String BAD_SIGNATURE_MODULE_SUMMARY = "securityDashboard.badSignatureModulePermissionGroup.summary";
    private static final String DESCRIPTION_KEY = "securityDashboard.modulePermissionGroup.description";
    private SecurityDashboardItemBuilder dashboardItemBuilder;
    private final ModuleSecurityInfoProvider securityInfoProvider;
    protected static final Logger LOGGER = Logger.getLogger("securityDashboard");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSecurityDashboardModulePermissions() {
        this.securityInfoProvider = new ModuleSecurityInfoProvider();
        this.dashboardItemBuilder = new SecurityDashboardItemBuilder(TYPE);
    }

    public BSecurityDashboardModulePermissions(JarSignatureRegistry signatureRegistry, ISecurityInfoProvider secInfoProvider) {
        this.securityInfoProvider = new ModuleSecurityInfoProvider(signatureRegistry, secInfoProvider);
        this.dashboardItemBuilder = new SecurityDashboardItemBuilder(TYPE);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.modulePermissionGroup.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return BOrd.DEFAULT;
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        TreeSet<String> severePermissionGroupModulesSet = new TreeSet<String>();
        TreeSet<String> okSeverePermissionGroupModuleSet = new TreeSet<String>();
        TreeSet<String> moderatePermissionGroupModulesSet = new TreeSet<String>();
        TreeSet<String> okModeratePermissionGroupModuleSet = new TreeSet<String>();
        TreeSet<String> mildPermissionGroupModulesSet = new TreeSet<String>();
        TreeSet<String> okMildPermissionGroupModulesSet = new TreeSet<String>();
        TreeSet<String> badModules = new TreeSet<String>();
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        Optional managerOptional = DefaultModulesFileManager.get();
        if (!managerOptional.isPresent()) {
            LOGGER.warning("Failed to retrieve requested module permissions, DefaultModulesFileManager is unavailable.");
            items.add(this.dashboardItemBuilder.makeInfo("securityDashboard.modulePermissionGroup.unableToRetrieve.summary", DESCRIPTION_KEY));
            return items;
        }
        EnumMap<ModuleSignatureStatusEnum, List<String>> moduleStatusMap = this.securityInfoProvider.makeModuleStatusMap();
        TreeSet<String> trustedModules = new TreeSet<String>();
        trustedModules.addAll(moduleStatusMap.getOrDefault(ModuleSignatureStatusEnum.OK, new ArrayList()));
        trustedModules.addAll(moduleStatusMap.getOrDefault(ModuleSignatureStatusEnum.SIGNER_SELF_SIGNED, new ArrayList()));
        trustedModules.addAll(moduleStatusMap.getOrDefault(ModuleSignatureStatusEnum.TIMESTAMP_SELF_SIGNED, new ArrayList()));
        List noCertPathModules = moduleStatusMap.getOrDefault(ModuleSignatureStatusEnum.CERT_PATH_VALIDATION_FAILURE, new ArrayList());
        noCertPathModules.forEach(trustedModules::remove);
        BSecurityDashboardModulePermissions.fetchPermissionGroupRiskLevels(severePermissionGroupModulesSet, okSeverePermissionGroupModuleSet, moderatePermissionGroupModulesSet, okModeratePermissionGroupModuleSet, mildPermissionGroupModulesSet, okMildPermissionGroupModulesSet, trustedModules, badModules, (DefaultModulesFileManager)managerOptional.get());
        if (!severePermissionGroupModulesSet.isEmpty()) {
            items.add(this.dashboardItemBuilder.makeWarning().withSummary(SEVERE_PERMISSIONS_SUMMARY, new Object[]{((Object)severePermissionGroupModulesSet).toString()}).withDescription(DESCRIPTION_KEY, new Object[0]));
        }
        if (!moderatePermissionGroupModulesSet.isEmpty()) {
            items.add(this.dashboardItemBuilder.makeWarning().withSummary(MODERATE_PERMISSIONS_SUMMARY, new Object[]{((Object)moderatePermissionGroupModulesSet).toString()}).withDescription(DESCRIPTION_KEY, new Object[0]));
        }
        if (!mildPermissionGroupModulesSet.isEmpty()) {
            items.add(this.dashboardItemBuilder.makeWarning().withSummary(MILD_PERMISSIONS_SUMMARY, new Object[]{((Object)mildPermissionGroupModulesSet).toString()}).withDescription(DESCRIPTION_KEY, new Object[0]));
        }
        if (!okMildPermissionGroupModulesSet.isEmpty()) {
            items.add(this.dashboardItemBuilder.makeOk().withSummary(OK_MILD_PERMISSIONS_SUMMARY, new Object[]{((Object)okMildPermissionGroupModulesSet).toString()}).withDescription(DESCRIPTION_KEY, new Object[0]));
        }
        if (!okModeratePermissionGroupModuleSet.isEmpty()) {
            items.add(this.dashboardItemBuilder.makeOk().withSummary(OK_MODERATE_PERMISSIONS_SUMMARY, new Object[]{((Object)okModeratePermissionGroupModuleSet).toString()}).withDescription(DESCRIPTION_KEY, new Object[0]));
        }
        if (!okSeverePermissionGroupModuleSet.isEmpty()) {
            items.add(this.dashboardItemBuilder.makeOk().withSummary(OK_SEVERE_PERMISSIONS_SUMMARY, new Object[]{((Object)okSeverePermissionGroupModuleSet).toString()}).withDescription(DESCRIPTION_KEY, new Object[0]));
        }
        if (!badModules.isEmpty()) {
            items.add(this.dashboardItemBuilder.makeInfo().withSummary(BAD_SIGNATURE_MODULE_SUMMARY, new Object[]{((Object)badModules).toString()}).withDescription(DESCRIPTION_KEY, new Object[0]));
        }
        if (items.isEmpty()) {
            items.add(SecurityDashboardItem.makeOk((Type)TYPE, (String)"securityDashboard.noModulePermissionGroup.summary", (String)DESCRIPTION_KEY));
        }
        return items;
    }

    private static void fetchPermissionGroupRiskLevels(Set<String> severePermissionGroupModules, Set<String> okSeverePermissionGroupModuleSet, Set<String> moderatePermissionGroupModules, Set<String> okModeratePermissionGroupModuleSet, Set<String> mildPermissionGroupModules, Set<String> okMildPermissionGroupModulesSet, Set<String> trustedModules, Set<String> badModules, DefaultModulesFileManager modulesFileManager) {
        DefaultModulesFileManager.ModuleFileSet modules = modulesFileManager.init(false);
        for (ManagedModuleFile module : modules) {
            String moduleUrl;
            String modulePartName = module.getModulePartName();
            if (!module.hasNiagaraPermissions()) continue;
            try {
                Sys.loadModule((String)module.getModuleName());
            }
            catch (Exception e) {
                LOGGER.fine("Cannot determine permissions for module: " + modulePartName + ".  Module could not be loaded.");
                badModules.add(modulePartName);
                continue;
            }
            try {
                moduleUrl = NiagaraPolicyUtil.canonicalizeCodeSource((String)module.getFile().getPath());
            }
            catch (IOException e) {
                continue;
            }
            Set groups = AccessController.doPrivileged(() -> NiagaraPolicyUtil.getAllPermissionGroups((String)moduleUrl));
            for (NiagaraPermissionGroup group : groups) {
                switch (group.getRiskLevel()) {
                    case SEVERE: {
                        if (trustedModules.contains(modulePartName)) {
                            okSeverePermissionGroupModuleSet.add(modulePartName);
                            break;
                        }
                        severePermissionGroupModules.add(modulePartName);
                        break;
                    }
                    case MODERATE: {
                        if (trustedModules.contains(modulePartName)) {
                            okModeratePermissionGroupModuleSet.add(modulePartName);
                            break;
                        }
                        moderatePermissionGroupModules.add(modulePartName);
                        break;
                    }
                    case MILD: {
                        if (trustedModules.contains(modulePartName)) {
                            okMildPermissionGroupModulesSet.add(modulePartName);
                            break;
                        }
                        mildPermissionGroupModules.add(modulePartName);
                    }
                }
            }
        }
    }
}

