/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nss.dashboard.ModuleSecurityInfoProvider;
import com.tridium.sys.Nre;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"nss:SecurityService"})})
public class BSecurityDashboardModuleSignatures
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSecurityDashboardModuleSignatures.class);
    private final ModuleVerificationMode verificationMode;
    private final ModuleSecurityInfoProvider securityInfoProvider;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSecurityDashboardModuleSignatures() {
        this(Nre.getJarSignatureRegistry(), Nre.getModuleVerificationMode(), AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider()));
    }

    public BSecurityDashboardModuleSignatures(JarSignatureRegistry signatureRegistry, ModuleVerificationMode verificationMode, ISecurityInfoProvider secInfoProvider) {
        this.securityInfoProvider = new ModuleSecurityInfoProvider(signatureRegistry, secInfoProvider);
        this.verificationMode = verificationMode;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.moduleSignatures.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return null;
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        this.addVerificationModeItem(items);
        this.addSignatureStatusItems(items);
        return items;
    }

    private void addVerificationModeItem(List<SecurityDashboardItem> items) {
        BSecurityItemStatus status = this.verificationMode.compareTo((Enum)ModuleVerificationMode.DEFAULT) < 0 ? BSecurityItemStatus.securityStatusWarning : (this.verificationMode == ModuleVerificationMode.high ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusInfo);
        items.add(SecurityDashboardItem.make((LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.moduleSignatures.verificationMode", (String)this.verificationMode.toString()), (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.moduleSignatures.verificationMode.description", (String)ModuleVerificationMode.DEFAULT.toString()), (BSecurityItemStatus)status));
    }

    private void addSignatureStatusItems(List<SecurityDashboardItem> items) {
        EnumMap<ModuleSignatureStatusEnum, List<String>> statusMap = this.securityInfoProvider.makeModuleStatusMap();
        for (Map.Entry<ModuleSignatureStatusEnum, List<String>> entry : statusMap.entrySet()) {
            BSecurityItemStatus itemStatus;
            LexiconFormatInfo summary;
            ModuleSignatureStatusEnum signatureStatus = entry.getKey();
            if (signatureStatus == ModuleSignatureStatusEnum.OK) {
                summary = LexiconFormatInfo.make((Type)TYPE, (String)("securityDashboard.moduleSignatures." + signatureStatus), (int)entry.getValue().size());
                itemStatus = BSecurityItemStatus.securityStatusOK;
            } else if (signatureStatus == ModuleSignatureStatusEnum.UNKNOWN) {
                summary = LexiconFormatInfo.make((Type)TYPE, (String)("securityDashboard.moduleSignatures." + signatureStatus), (String)String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue()));
                itemStatus = BSecurityItemStatus.securityStatusInfo;
            } else if (signatureStatus.isAcceptable(this.verificationMode)) {
                summary = LexiconFormatInfo.make((Type)TYPE, (String)("securityDashboard.moduleSignatures." + signatureStatus), (String)String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue()));
                itemStatus = BSecurityItemStatus.securityStatusWarning;
            } else {
                summary = LexiconFormatInfo.make((Type)TYPE, (String)("securityDashboard.moduleSignatures." + signatureStatus), (String)String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue()));
                itemStatus = BSecurityItemStatus.securityStatusAlert;
            }
            items.add(SecurityDashboardItem.make((Type)TYPE, (LexiconFormatInfo)summary, (String)("securityDashboard.moduleSignatures." + signatureStatus + ".description"), (BSecurityItemStatus)itemStatus));
        }
    }
}

