/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platNdio;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platNdio.BNdioPlatformService;
import com.tridium.platNdio.NdioPlatformServiceException;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNdioPlatformServiceQnx
extends BNdioPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BNdioPlatformServiceQnx.class);
    private boolean nativesLoaded = false;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        if (!PlatformUtil.isTridiumPlatform()) {
            return false;
        }
        if (!OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
            return false;
        }
        if (!this.loadLibraries(true)) {
            return false;
        }
        this.initialize();
        return this.isDaemonOk();
    }

    protected boolean loadLibraries(boolean quiet) {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            block2: {
                try {
                    log.fine("Loading platndio native library");
                    System.loadLibrary("platndio");
                    this.nativesLoaded = true;
                }
                catch (Throwable e) {
                    if (quiet) break block2;
                    log.log(Level.SEVERE, "Cannot load platndio native library", e);
                }
            }
            return this.nativesLoaded;
        });
    }

    @Override
    public void loadPlatformServiceProperties() {
        this.loadLibraries(false);
        super.loadPlatformServiceProperties();
    }

    @Override
    protected synchronized void initialize() {
        this.initialize0();
    }

    @Override
    protected synchronized void shutdown() {
        this.shutdown0();
    }

    @Override
    public synchronized boolean isDaemonOk() {
        boolean value = this.isDaemonOk0();
        return value;
    }

    @Override
    public synchronized long getInitTicks() throws NdioPlatformServiceException {
        long value = this.getInitTicks0();
        return value;
    }

    @Override
    public synchronized long getHeartbeatTicks() throws NdioPlatformServiceException {
        long value = this.getHeartbeatTicks0();
        return value;
    }

    @Override
    public void setKeepAliveInterval(long interval) throws NdioPlatformServiceException {
        this.setKeepAliveInterval0(interval);
    }

    @Override
    public void keepAlive() throws NdioPlatformServiceException {
        this.keepAlive0();
    }

    @Override
    public synchronized int readIoType(int procNum) throws NdioPlatformServiceException {
        int value = this.readIoType0(procNum);
        return value;
    }

    @Override
    public synchronized int readIoConfigState(int procNum) throws NdioPlatformServiceException {
        int value = this.readIoConfigState0(procNum);
        return value;
    }

    @Override
    public synchronized boolean isProcessorOk(int procNum) {
        boolean value = this.isProcessorOk0(procNum);
        return value;
    }

    @Override
    public synchronized int readUIType(int procNum, int index) throws NdioPlatformServiceException {
        int value = this.readUIType0(procNum, index);
        return value;
    }

    @Override
    public synchronized void writeUIType(int procNum, int index, int subtype) throws NdioPlatformServiceException {
        this.writeUIType0(procNum, index, subtype);
    }

    @Override
    public synchronized int readValue(int procNum, int type, int index) throws NdioPlatformServiceException {
        int value = this.readValue0(procNum, type, index);
        return value;
    }

    @Override
    public synchronized int readOutValue(int procNum, int type, int index) throws NdioPlatformServiceException {
        int value = this.readOutValue0(procNum, type, index);
        return value;
    }

    public synchronized int readScale(int procNum, int type, int subtype, int index) throws NdioPlatformServiceException {
        int value = this.readScale0(procNum, type, subtype, index);
        return value;
    }

    public synchronized int readOffset(int procNum, int type, int subtype, int index) throws NdioPlatformServiceException {
        int value = this.readOffset0(procNum, type, subtype, index);
        return value;
    }

    @Override
    public synchronized void writeValue(int procNum, int type, int index, int value) throws NdioPlatformServiceException {
        this.writeValue0(procNum, type, index, value);
    }

    @Override
    public synchronized long readUICount(int procNum, int index) throws NdioPlatformServiceException {
        long value = this.readUICount0(procNum, index);
        return value;
    }

    @Override
    public synchronized long readUICountDelta(int procNum, int index) throws NdioPlatformServiceException {
        long value = this.readUICountDelta0(procNum, index);
        return value;
    }

    @Override
    public synchronized long getFirstReadTicks(int procNum) throws NdioPlatformServiceException {
        long value = this.getFirstReadTicks0(procNum);
        return value;
    }

    @Override
    public synchronized int getErrorFlags(int procNum) throws NdioPlatformServiceException {
        int value = this.getErrorFlags0(procNum);
        return value;
    }

    @Override
    public synchronized int readConfigCode(int procNum) throws NdioPlatformServiceException {
        int value = this.readConfigCode0(procNum) & 0xFFFFFF;
        return value;
    }

    @Override
    public synchronized void writeConfigCode(int procNum, int value) throws NdioPlatformServiceException {
        this.writeConfigCode0(procNum, value);
    }

    @Override
    public synchronized int getFirmwareIntfNum(int procNum) throws NdioPlatformServiceException {
        int value = this.getFirmwareIntfNum0(procNum);
        return value;
    }

    @Override
    public synchronized int getFirmwareBuildNum(int procNum) throws NdioPlatformServiceException {
        int value = this.getFirmwareBuildNum0(procNum);
        return value;
    }

    @Override
    public synchronized long getSuccessTicks(int procNum) throws NdioPlatformServiceException {
        long value = this.getSuccessTicks0(procNum);
        return value;
    }

    @Override
    public synchronized boolean isProcessorCalibrated(int procNum) throws NdioPlatformServiceException {
        int i;
        boolean calibrated = false;
        for (i = 0; i < 8; ++i) {
            if (this.readScale(procNum, 0, 3, i) != 50) {
                calibrated = true;
            }
            if (this.readOffset(procNum, 0, 3, i) != 440) {
                calibrated = true;
            }
            if (this.readScale(procNum, 0, 4, i) != 50) {
                calibrated = true;
            }
            if (this.readOffset(procNum, 0, 4, i) != 440) {
                calibrated = true;
            }
            if (this.readScale(procNum, 0, 5, i) != 50) {
                calibrated = true;
            }
            if (this.readOffset(procNum, 0, 5, i) == 440) continue;
            calibrated = true;
        }
        for (i = 0; i < 4; ++i) {
            if (this.readScale(procNum, 2, 5, i) != 100) {
                calibrated = true;
            }
            if (this.readOffset(procNum, 2, 5, i) == 440) continue;
            calibrated = true;
        }
        return calibrated;
    }

    private native void initialize0();

    private native void shutdown0();

    private native boolean isDaemonOk0();

    private native long getInitTicks0();

    private native long getHeartbeatTicks0();

    private native void setKeepAliveInterval0(long var1);

    private native void keepAlive0();

    private native boolean isProcessorOk0(int var1);

    private native int readIoType0(int var1);

    private native int readIoConfigState0(int var1);

    private native int readUIType0(int var1, int var2);

    private native void writeUIType0(int var1, int var2, int var3);

    private native int readValue0(int var1, int var2, int var3);

    private native int readOutValue0(int var1, int var2, int var3);

    private native int readScale0(int var1, int var2, int var3, int var4);

    private native int readOffset0(int var1, int var2, int var3, int var4);

    private native void writeValue0(int var1, int var2, int var3, int var4);

    private native long readUICount0(int var1, int var2);

    private native long readUICountDelta0(int var1, int var2);

    private native long getFirstReadTicks0(int var1);

    private native int getErrorFlags0(int var1);

    private native int readConfigCode0(int var1);

    private native void writeConfigCode0(int var1, int var2);

    private native int getFirmwareIntfNum0(int var1);

    private native int getFirmwareBuildNum0(int var1);

    private native long getSuccessTicks0(int var1);
}

