/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platNdio;

import com.tridium.platNdio.BNdioPlatformService;
import com.tridium.platNdio.NdioPlatformServiceConstants;
import com.tridium.platNdio.NdioPlatformServiceException;
import java.io.PrintWriter;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;

public class NdioProcessorStatusPage
extends Spy
implements NdioPlatformServiceConstants {
    private BNdioPlatformService service;
    private int addr;

    public NdioProcessorStatusPage(BNdioPlatformService service, int addr) {
        this.service = service;
        this.addr = addr;
    }

    public void write(SpyWriter out) throws Exception {
        try {
            if (this.service.isDaemonOk()) {
                out.startProps();
                out.trTitle((Object)"processor", 2);
                out.prop((Object)"address", this.addr);
                int ioType = 0;
                int ioConfigState = 0;
                try {
                    ioType = this.service.readIoType(this.addr);
                    ioConfigState = this.service.readIoConfigState(this.addr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ioType != 0 && ioConfigState != 0 && ioConfigState != 1) {
                    int j;
                    out.prop((Object)"firstReadTicks", (Object)String.valueOf(this.service.getFirstReadTicks(this.addr)));
                    out.prop((Object)"ioBoardType", ioType);
                    out.prop((Object)"ioFirmware", (Object)(this.service.getFirmwareIntfNum(this.addr) + "." + this.service.getFirmwareBuildNum(this.addr)));
                    out.prop((Object)"configCode", this.service.readConfigCode(this.addr) & 0xFFFFFF);
                    out.prop((Object)"ioConfigState", ioConfigState);
                    out.prop((Object)"calibrated", this.service.isProcessorCalibrated(this.addr));
                    out.prop((Object)"successTicks", (Object)String.valueOf(this.service.getSuccessTicks(this.addr)));
                    StringBuilder buf = new StringBuilder();
                    for (j = 0; j < 8; ++j) {
                        buf.append("[").append(this.service.readUIType(this.addr, j)).append("]");
                    }
                    out.prop((Object)"definitionUIs", (Object)buf.toString());
                    buf = new StringBuilder();
                    for (j = 0; j < 8; ++j) {
                        buf.append("[").append(this.service.readValue(this.addr, 0, j)).append("]");
                    }
                    out.prop((Object)"uiInValues", (Object)buf.toString());
                    buf = new StringBuilder();
                    for (j = 0; j < 8; ++j) {
                        buf.append("[").append(this.service.readUICount(this.addr, j)).append("]");
                    }
                    out.prop((Object)"uiInCounts", (Object)buf.toString());
                    buf = new StringBuilder();
                    for (j = 0; j < 16; ++j) {
                        buf.append("[").append(this.service.readValue(this.addr, 1, j)).append("]");
                    }
                    out.prop((Object)"ovrInValues", (Object)buf.toString());
                    buf = new StringBuilder();
                    for (j = 0; j < 16; ++j) {
                        buf.append("[").append(this.service.readValue(this.addr, 3, j)).append("]");
                    }
                    out.prop((Object)"doInValues", (Object)buf.toString());
                    buf = new StringBuilder();
                    for (j = 0; j < 16; ++j) {
                        buf.append("[").append(this.service.readOutValue(this.addr, 3, j)).append("]");
                    }
                    out.prop((Object)"doOutValues", (Object)buf.toString());
                    buf = new StringBuilder();
                    for (j = 0; j < 4; ++j) {
                        buf.append("[").append(this.service.readValue(this.addr, 2, j)).append("]");
                    }
                    out.prop((Object)"aoInValues", (Object)buf.toString());
                    buf = new StringBuilder();
                    for (j = 0; j < 4; ++j) {
                        buf.append("[").append(this.service.readOutValue(this.addr, 2, j)).append("]");
                    }
                    out.prop((Object)"aoOutValues", (Object)buf.toString());
                } else {
                    out.prop((Object)"state", (Object)"undefined");
                }
            } else {
                throw new NdioPlatformServiceException("network is not running");
            }
            out.endProps();
        }
        catch (Exception e) {
            out.endProps();
            out.println("error getting ndio processor status:<br>");
            e.printStackTrace((PrintWriter)out);
        }
    }
}

