/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;
import javax.mail.internet.InternetAddress;

@NiagaraType
public final class BEmailAddress
extends BSimple
implements BIValidator {
    public static final BEmailAddress DEFAULT;
    public static final BEmailAddress NULL;
    public static final Type TYPE;
    private String address;
    private String personal;

    public static BEmailAddress make(String address, String personal) {
        return new BEmailAddress(address, personal);
    }

    public static BEmailAddress make(String address) {
        return new BEmailAddress(address, null);
    }

    private BEmailAddress(String address, String personal) {
        if (address != null && (address.indexOf(124) != -1 || address.indexOf(59) != -1)) {
            throw new LocalizableRuntimeException("email", "illegalAddress", new Object[]{address});
        }
        if (personal != null && (personal.indexOf(124) != -1 || personal.indexOf(59) != -1)) {
            throw new LocalizableRuntimeException("email", "illegalPersonalName", new Object[]{personal});
        }
        this.address = address == null ? null : address.trim();
        this.personal = personal;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        return this.personal;
    }

    public boolean isNull() {
        return this == NULL || (this.personal == null || this.personal.length() == 0) && (this.address == null || this.address.length() == 0);
    }

    public int hashCode() {
        if (this.personal != null && this.address != null) {
            return this.address.hashCode() ^ this.personal.hashCode();
        }
        if (this.address != null) {
            return this.address.hashCode();
        }
        if (this.personal != null) {
            return this.personal.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BEmailAddress) {
            BEmailAddress r = (BEmailAddress)((Object)obj);
            if (this.address == null && r.address != null) {
                return false;
            }
            if (this.address != null && r.address == null) {
                return false;
            }
            if (this.address != null && !this.address.equals(r.address)) {
                return false;
            }
            if (this.personal == null && r.personal != null) {
                return false;
            }
            if (this.personal != null && r.personal == null) {
                return false;
            }
            return this.personal == null || this.personal.equals(r.personal);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "";
        }
        if (this.address == null && this.personal == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.address);
        if (this.personal != null) {
            sb.append('|').append(this.personal);
        }
        return sb.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s == null) {
            return NULL;
        }
        if (s.equals("")) {
            return NULL;
        }
        int c = s.indexOf(124);
        if (c == -1) {
            return BEmailAddress.make(s);
        }
        return BEmailAddress.make(s.substring(0, c), s.substring(c + 1));
    }

    public void validate(BObject value, Context cx) throws CannotValidateException {
        BEmailAddress bEmailAddress = (BEmailAddress)value;
        if (bEmailAddress.getAddress() == null || bEmailAddress.getAddress().length() == 0) {
            return;
        }
        InternetAddress iAddress = new InternetAddress();
        try {
            iAddress.setAddress(bEmailAddress.getAddress());
            iAddress.setPersonal(bEmailAddress.getPersonal());
            iAddress.validate();
        }
        catch (Exception e) {
            throw new CannotValidateException(e.getMessage(), (Throwable)e);
        }
    }

    public Type getType() {
        return TYPE;
    }

    static {
        NULL = DEFAULT = new BEmailAddress(null, null);
        TYPE = Sys.loadType(BEmailAddress.class);
    }
}

