/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.email.BEmailAddress;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;

@NiagaraType
public final class BEmailAddressList
extends BSimple
implements BIValidator {
    public static final BEmailAddressList DEFAULT = new BEmailAddressList(new BEmailAddress[0]);
    public static final BEmailAddressList NULL = new BEmailAddressList(new BEmailAddress[0]);
    public static final Type TYPE = Sys.loadType(BEmailAddressList.class);
    private BEmailAddress[] addr;

    public static BEmailAddressList make(BEmailAddress[] addr) {
        return new BEmailAddressList(BEmailAddressList.clone(addr));
    }

    public static BEmailAddressList make(BEmailAddress addr) {
        return new BEmailAddressList(new BEmailAddress[]{addr});
    }

    public static BEmailAddressList make(String s) {
        try {
            return (BEmailAddressList)NULL.decodeFromString(s);
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private BEmailAddressList(BEmailAddress[] addr) {
        this.addr = addr;
    }

    public BEmailAddress[] getAddresses() {
        return BEmailAddressList.clone(this.addr);
    }

    private static BEmailAddress[] clone(BEmailAddress[] a) {
        if (a == null) {
            return null;
        }
        BEmailAddress[] c = new BEmailAddress[a.length];
        System.arraycopy(a, 0, c, 0, a.length);
        return c;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int hashCode() {
        int hash = 0;
        if (this.addr == null) {
            return hash;
        }
        for (int i = 0; i < this.addr.length; ++i) {
            hash = 31 * hash + this.addr[i].hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BEmailAddressList) {
            BEmailAddressList r = (BEmailAddressList)((Object)obj);
            if (this.addr == null) {
                return r.addr == null;
            }
            if (r.addr == null) {
                return false;
            }
            if (r.addr.length != this.addr.length) {
                return false;
            }
            for (int i = 0; i < this.addr.length; ++i) {
                if (this.addr[i].equals((Object)r.addr[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.isNull()) {
            return "";
        }
        if (this.addr == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.addr.length; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(this.addr[i].toString());
        }
        return sb.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s == null) {
            return NULL;
        }
        if (s.equals("")) {
            return NULL;
        }
        String[] str = TextUtil.split((String)s, (char)';');
        BEmailAddress[] arr = new BEmailAddress[str.length];
        for (int i = 0; i < str.length; ++i) {
            arr[i] = (BEmailAddress)BEmailAddress.NULL.decodeFromString(str[i]);
        }
        return new BEmailAddressList(arr);
    }

    public void validate(BObject value, Context cx) throws CannotValidateException {
        try {
            BEmailAddressList bEmailAddress = (BEmailAddressList)value;
            BEmailAddress[] addresses = bEmailAddress.getAddresses();
            if (addresses == null) {
                return;
            }
            for (int i = 0; i < addresses.length; ++i) {
                addresses[i].validate((BObject)addresses[i], cx);
            }
        }
        catch (Exception e) {
            throw new CannotValidateException(e.getMessage(), (Throwable)e);
        }
    }

    public Type getType() {
        return TYPE;
    }
}

