/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BOutgoingAccount;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;

@NiagaraType
@NiagaraAction(name="send", parameterType="BEmail", defaultValue="new BEmail()")
public class BEmailService
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Action send = BEmailService.newAction((int)0, (BValue)new BEmail(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BEmailService.class);
    private static final BIcon icon = BIcon.std((String)"email.png");
    private static Type[] serviceTypes = new Type[]{TYPE};
    public static final Logger log = Logger.getLogger("email");
    private static final int DEFAULT_MAX_NUMBER_OF_RETRIES_BEFORE_DISCARD = 6;
    static final Integer MAX_NUMBER_OF_RETRIES_BEFORE_DISCARD = AccessController.doPrivileged(() -> Integer.getInteger("niagara.email.maxNumberOfRetriesBeforeDiscard", 6));

    @Generated
    public void send(BEmail parameter) {
        this.invoke(send, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        AccessController.doPrivileged(new ServiceStartedPrivilegedAction());
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        BEmailAccount[] accts = this.getAccounts();
        for (int i = 0; i < accts.length; ++i) {
            accts[i].updateStatus();
            accts[i].endPolling();
        }
    }

    public void enabled() {
        BEmailAccount[] accts = this.getAccounts();
        for (int i = 0; i < accts.length; ++i) {
            accts[i].updateStatus();
        }
    }

    public void disabled() {
        BEmailAccount[] accts = this.getAccounts();
        for (int i = 0; i < accts.length; ++i) {
            accts[i].updateStatus();
        }
    }

    private BEmailAccount[] getAccounts() {
        return (BEmailAccount[])this.getChildren(BEmailAccount.class);
    }

    public BIcon getIcon() {
        return icon;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BEmailAccount.TYPE)) {
            BEmailAccount account = (BEmailAccount)this.get(property);
            account.updateStatus();
            if (account.isOperational()) {
                account.beginPolling();
            }
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BEmailAccount.TYPE)) {
            BEmailAccount account = (BEmailAccount)oldValue;
            account.endPolling();
        }
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "email");
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public BOutgoingAccount getDefaultOutgoingAccount() {
        BOutgoingAccount[] out = (BOutgoingAccount[])this.getChildren(BOutgoingAccount.class);
        if (out == null) {
            return null;
        }
        if (out.length == 0) {
            return null;
        }
        return out[0];
    }

    public void doSend(BEmail email, Context cx) {
        BOutgoingAccount out = this.getDefaultOutgoingAccount();
        if (out == null) {
            throw new BajaRuntimeException("BEmailService.send: There is no default outgoing account available");
        }
        out.invoke(BOutgoingAccount.send, (BValue)email, cx);
    }

    private class ServiceStartedPrivilegedAction
    implements PrivilegedAction<Void> {
        private ServiceStartedPrivilegedAction() {
        }

        @Override
        public Void run() {
            Class<?> cl = null;
            try {
                cl = Class.forName("com.sun.mail.smtp.SMTPTransport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (cl == null) {
                throw new BajaRuntimeException("EmailService will not trasmit and receive email without mail.jar in jre/lib/ext, download the the JavaMail Api from http://java.sun.com/products/javamail/downloads/index.html, retrieve mail.jar from the JavaMail zip file, and copy mail.jar to rel/jre/lib/ext.");
            }
            BEmailAccount[] accts = BEmailService.this.getAccounts();
            for (int i = 0; i < accts.length; ++i) {
                accts[i].updateStatus();
                if (!accts[i].isOperational()) continue;
                accts[i].beginPolling();
            }
            return null;
        }
    }
}

