/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.email;

import com.tridium.email.BBasicEmailClientAuthenticator;
import com.tridium.email.EmailUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.email.BDeliveryPolicy;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAccount;
import javax.baja.email.BEmailClientAuthenticator;
import javax.baja.email.BEmailRead;
import javax.baja.email.BEmailService;
import javax.baja.email.BIIncomingAccountClientAuthenticator;
import javax.baja.email.BIncomingAccountClientAuthenticatorTypeConfig;
import javax.baja.email.BStore;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="port", type="int", defaultValue="110", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(-1))")}, override=true), @NiagaraProperty(name="emailAuthenticator", type="BEmailAuthenticatorTypeConfig", defaultValue="new BIncomingAccountClientAuthenticatorTypeConfig()", flags=4, facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}, override=true), @NiagaraProperty(name="store", type="BStore", defaultValue="BStore.pop3"), @NiagaraProperty(name="deliveryPolicy", type="BDeliveryPolicy", defaultValue="BDeliveryPolicy.delete"), @NiagaraProperty(name="emailToRead", type="BEmailRead", defaultValue="BEmailRead.unreadEmail"), @NiagaraProperty(name="incomingEmailSizeLimit", type="int", defaultValue="25000", facets={@Facet(name="BFacets.UNITS", value="BUnit.make(\"kilobyte\", \"KB\", BDimension.NULL)"), @Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="BInteger.MAX")}), @NiagaraProperty(name="sizeLimitPerPoll", type="int", defaultValue="25000", facets={@Facet(name="BFacets.UNITS", value="BUnit.make(\"kilobyte\", \"KB\", BDimension.NULL)"), @Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="BInteger.MAX")}), @NiagaraProperty(name="ignoreAttachments", type="boolean", defaultValue="BBoolean.FALSE")})
@NiagaraTopic(name="received", eventType="BEmail")
public class BIncomingAccount
extends BEmailAccount {
    @Generated
    public static final Property port = BIncomingAccount.newProperty((int)0, (int)110, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)-1)));
    @Generated
    public static final Property emailAuthenticator = BIncomingAccount.newProperty((int)4, (BValue)new BIncomingAccountClientAuthenticatorTypeConfig(), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property store = BIncomingAccount.newProperty((int)0, (BValue)BStore.pop3, null);
    @Generated
    public static final Property deliveryPolicy = BIncomingAccount.newProperty((int)0, (BValue)BDeliveryPolicy.delete, null);
    @Generated
    public static final Property emailToRead = BIncomingAccount.newProperty((int)0, (BValue)BEmailRead.unreadEmail, null);
    @Generated
    public static final Property incomingEmailSizeLimit = BIncomingAccount.newProperty((int)0, (int)25000, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"kilobyte", (String)"KB", (BDimension)BDimension.NULL)), (BFacets)BFacets.make((String)"min", (int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.MAX)));
    @Generated
    public static final Property sizeLimitPerPoll = BIncomingAccount.newProperty((int)0, (int)25000, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.make((String)"kilobyte", (String)"KB", (BDimension)BDimension.NULL)), (BFacets)BFacets.make((String)"min", (int)1)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.MAX)));
    @Generated
    public static final Property ignoreAttachments = BIncomingAccount.newProperty((int)0, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Topic received = BIncomingAccount.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIncomingAccount.class);
    private static final BIcon icon = BIcon.std((String)"inbox.png");
    private static final Logger LOG = Logger.getLogger("email");

    @Generated
    public BStore getStore() {
        return (BStore)this.get(store);
    }

    @Generated
    public void setStore(BStore v) {
        this.set(store, (BValue)v, null);
    }

    @Generated
    public BDeliveryPolicy getDeliveryPolicy() {
        return (BDeliveryPolicy)this.get(deliveryPolicy);
    }

    @Generated
    public void setDeliveryPolicy(BDeliveryPolicy v) {
        this.set(deliveryPolicy, (BValue)v, null);
    }

    @Generated
    public BEmailRead getEmailToRead() {
        return (BEmailRead)this.get(emailToRead);
    }

    @Generated
    public void setEmailToRead(BEmailRead v) {
        this.set(emailToRead, (BValue)v, null);
    }

    @Generated
    public int getIncomingEmailSizeLimit() {
        return this.getInt(incomingEmailSizeLimit);
    }

    @Generated
    public void setIncomingEmailSizeLimit(int v) {
        this.setInt(incomingEmailSizeLimit, v, null);
    }

    @Generated
    public int getSizeLimitPerPoll() {
        return this.getInt(sizeLimitPerPoll);
    }

    @Generated
    public void setSizeLimitPerPoll(int v) {
        this.setInt(sizeLimitPerPoll, v, null);
    }

    @Generated
    public boolean getIgnoreAttachments() {
        return this.getBoolean(ignoreAttachments);
    }

    @Generated
    public void setIgnoreAttachments(boolean v) {
        this.setBoolean(ignoreAttachments, v, null);
    }

    @Generated
    public void fireReceived(BEmail event) {
        this.fire(received, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    @Override
    final void migrateDeprecatedAuthProperties() {
        if (!Flags.isUserDefined2((BComplex)this, (Slot)emailAuthenticator)) {
            if (!this.getAccount().isEmpty()) {
                BBasicEmailClientAuthenticator authenticator = new BBasicEmailClientAuthenticator();
                authenticator.setAccount(this.getAccount());
                authenticator.setPassword(this.getPassword());
                BIncomingAccountClientAuthenticatorTypeConfig authenticatorTypeConfig = new BIncomingAccountClientAuthenticatorTypeConfig();
                authenticatorTypeConfig.setTypeSpec(authenticator.getType().getTypeSpec());
                authenticatorTypeConfig.syncFrom((BObject)authenticator);
                this.setEmailAuthenticator(authenticatorTypeConfig);
            }
            this.setFlags((Slot)emailAuthenticator, this.getFlags((Slot)emailAuthenticator) | 0x20000000);
        }
        super.migrateDeprecatedAuthProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void poll() throws Exception {
        Store messageStore;
        block26: {
            int noOfEmailToRead;
            Folder inbox;
            block24: {
                block25: {
                    String storeType = this.store();
                    Session session = this.mailPlatformHandler.getIncomingSession(this, storeType);
                    messageStore = null;
                    inbox = null;
                    messageStore = session.getStore(storeType);
                    ((BEmailClientAuthenticator)this.getEmailAuthenticator().make()).connectIncomingSession(messageStore, storeType);
                    noOfEmailToRead = 0;
                    inbox = BIncomingAccount.getInbox(messageStore);
                    inbox.open(2);
                    if (inbox.getMessageCount() != 0) break block24;
                    inbox.close(false);
                    inbox = null;
                    if (inbox == null) break block25;
                    inbox.close(this.getDeliveryPolicy() == BDeliveryPolicy.delete);
                }
                if (messageStore != null) {
                    messageStore.close();
                }
                return;
            }
            try {
                BEmailService.log.fine("BIncomingAccount just received " + inbox.getMessageCount() + " email(s).");
                int emailCount = this.getEmailToRead().getEmailReadCount();
                Message[] messages = null;
                if ((this.getDeliveryPolicy() == BDeliveryPolicy.delete || this.getDeliveryPolicy() == BDeliveryPolicy.markAsRead) && this.getEmailToRead() == BEmailRead.unreadEmail) {
                    messages = inbox.search((SearchTerm)new FlagTerm(new javax.mail.Flags(Flags.Flag.SEEN), false));
                    noOfEmailToRead = messages.length <= emailCount ? messages.length : emailCount;
                } else {
                    messages = inbox.getMessages();
                    noOfEmailToRead = messages.length;
                }
                FetchProfile fp = new FetchProfile();
                fp.add(FetchProfile.Item.ENVELOPE);
                fp.add(FetchProfile.Item.FLAGS);
                fp.add(FetchProfile.Item.SIZE);
                fp.add("X-Mailer");
                inbox.fetch(messages, fp);
                long totalSize = 0L;
                int numEmailsRead = 0;
                int numEmailsTooLarge = 0;
                long sizeLimitPerPollInBytes = (long)this.getSizeLimitPerPoll() * 1000L;
                long emailSizeLimitInBytes = (long)this.getIncomingEmailSizeLimit() * 1000L;
                for (int i = 0; i < noOfEmailToRead; ++i) {
                    Message m = messages[i];
                    int messageSize = m.getSize();
                    if ((long)messageSize > emailSizeLimitInBytes) {
                        ++numEmailsTooLarge;
                        LOG.info(String.format("Incoming email with subject '%s' exceeds size limit: %d > %d. This email will be ignored and marked as read/unread/deleted per the account policy.", m.getSubject(), messageSize, emailSizeLimitInBytes));
                    } else {
                        if (totalSize + (long)messageSize > sizeLimitPerPollInBytes) {
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine(String.format("Reading incoming email would exceed size limit per poll: %d > %d. This email will be skipped but will re-attempted next poll", (long)messageSize + totalSize, sizeLimitPerPollInBytes));
                            continue;
                        }
                        totalSize += (long)messageSize;
                        ++numEmailsRead;
                        String subject = "?";
                        try {
                            BEmail mail;
                            subject = m.getSubject();
                            try {
                                mail = AccessController.doPrivileged(() -> EmailUtil.fromMessage(m, this.getIgnoreAttachments()));
                            }
                            catch (PrivilegedActionException e) {
                                throw e.getException();
                            }
                            this.fireReceived(mail);
                        }
                        catch (Exception e) {
                            LOG.log(Level.SEVERE, "BIncomingAccount could not process message: " + subject, e);
                        }
                    }
                    if (this.getDeliveryPolicy() == BDeliveryPolicy.delete) {
                        m.setFlag(Flags.Flag.DELETED, true);
                        continue;
                    }
                    if (this.getDeliveryPolicy() == BDeliveryPolicy.markAsRead) {
                        m.setFlag(Flags.Flag.SEEN, true);
                        continue;
                    }
                    if (this.getDeliveryPolicy() != BDeliveryPolicy.markAsUnread) continue;
                    m.setFlag(Flags.Flag.SEEN, false);
                }
                int numEmailsToReattempt = noOfEmailToRead - (numEmailsRead + numEmailsTooLarge);
                if (LOG.isLoggable(Level.FINE)) {
                    StringBuilder logMessage = new StringBuilder("Read ").append(numEmailsRead).append(" of ").append(noOfEmailToRead).append(" available emails.");
                    if (numEmailsTooLarge > 0) {
                        logMessage.append(" Ignored ").append(numEmailsTooLarge).append(" email(s) that exceeded the max email size limit.");
                    }
                    if (numEmailsToReattempt > 0) {
                        logMessage.append(" Skipped ").append(numEmailsToReattempt).append(" email(s) after maximum read size per poll was reached, which will be read on the next poll.");
                    }
                    LOG.fine(logMessage.toString());
                } else if (LOG.isLoggable(Level.INFO) && numEmailsToReattempt > 0) {
                    LOG.info("Skipped " + numEmailsToReattempt + " emails after maximum read size per poll was reached. These will be read on the next poll.");
                }
                inbox.close(this.getDeliveryPolicy() == BDeliveryPolicy.delete);
                inbox = null;
                if (inbox == null) break block26;
                inbox.close(this.getDeliveryPolicy() == BDeliveryPolicy.delete);
            }
            catch (Throwable throwable) {
                if (inbox != null) {
                    inbox.close(this.getDeliveryPolicy() == BDeliveryPolicy.delete);
                }
                if (messageStore != null) {
                    messageStore.close();
                }
                throw throwable;
            }
        }
        if (messageStore != null) {
            messageStore.close();
        }
    }

    private static Folder getInbox(Store store) throws Exception {
        Folder folder = store.getDefaultFolder();
        if (folder == null) {
            throw new IllegalStateException("No default mail folder");
        }
        if ((folder = folder.getFolder("INBOX")) == null) {
            throw new IllegalStateException("No inbox folder.");
        }
        return folder;
    }

    private String store() {
        switch (this.getStore().getOrdinal()) {
            case 0: {
                return "pop3";
            }
            case 1: {
                return "imap";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Type getTargetEmailAuthenticatorType() {
        return BIIncomingAccountClientAuthenticator.TYPE;
    }
}

