/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.ui;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.discover.BIDdfDiscoveryGroup;
import com.tridium.ddf.point.BDdfProxyExt;
import com.tridium.workbench.propsheet.BPropertySheetFE;
import javax.baja.control.BControlPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

public class DdfMgrColumnUtil
implements IDdfFacetConst {
    protected DdfMgrColumnUtil() {
    }

    public static int getMgrColumnFlags(BComplex owner, Property prop) {
        int mgrColumnFlags = 0;
        if (DdfFacets.isMgrInclude((BComplex)owner, (Property)prop)) {
            if (!DdfFacets.isMgrNotInDialog((BComplex)owner, (Property)prop)) {
                mgrColumnFlags |= 1;
            }
            if (DdfFacets.isMgrOptionalInTable((BComplex)owner, (Property)prop)) {
                mgrColumnFlags |= 2;
            }
        } else {
            mgrColumnFlags |= 2;
        }
        if (Flags.isReadonly((BComplex)owner, (Slot)prop) || DdfFacets.isMgrReadOnly((BComplex)owner, (Property)prop)) {
            mgrColumnFlags |= 4;
        }
        return mgrColumnFlags;
    }

    public static MgrColumn[] getColumnsFor(BComplex databaseOrDiscoveryPrototypeObject) {
        if (databaseOrDiscoveryPrototypeObject instanceof BDdfProxyExt) {
            BControlPoint parentPt = ((BDdfProxyExt)databaseOrDiscoveryPrototypeObject).getParentPoint();
            if (parentPt == null) {
                parentPt = new BStringPoint();
                parentPt.setProxyExt((BAbstractProxyExt)((BDdfProxyExt)databaseOrDiscoveryPrototypeObject.newCopy()));
            }
            databaseOrDiscoveryPrototypeObject = parentPt;
        }
        Array retVals = new Array(MgrColumn.class);
        retVals.addAll((Object[])DdfMgrColumnUtil.getColumnsRecursive(databaseOrDiscoveryPrototypeObject));
        return (MgrColumn[])retVals.trim();
    }

    protected static MgrColumn[] getDirectColumnsFor(BComplex complex) {
        Array mgrColumnProps = new Array(MgrColumn.Prop.class);
        Property[] complexProps = complex.getPropertiesArray();
        for (int i = 0; i < complexProps.length; ++i) {
            BValue defaultValue = complexProps[i].getDefaultValue();
            if (!defaultValue.getType().is(BSimple.TYPE) && (!defaultValue.getType().is(BStruct.TYPE) || BWbFieldEditor.makeFor((BObject)defaultValue).getType().is(BPropertySheetFE.TYPE)) || !DdfFacets.isMgrInclude((BComplex)complex, (Property)complexProps[i])) continue;
            mgrColumnProps.add((Object)new DdfMgrProp(complexProps[i], DdfMgrColumnUtil.getMgrColumnFlags(complex, complexProps[i])));
        }
        return (MgrColumn[])mgrColumnProps.trim();
    }

    protected static MgrColumn[] getColumnsRecursive(BComplex complex) {
        Property[] complexProps = complex.getFrozenPropertiesArray();
        Array mgrColumnProps = new Array(MgrColumn.class);
        mgrColumnProps.addAll((Object[])DdfMgrColumnUtil.getDirectColumnsFor(complex));
        for (int i = 0; i < complexProps.length; ++i) {
            if ((!(complex instanceof BControlPoint) || !complexProps[i].equals(BControlPoint.proxyExt)) && (!(complex instanceof BDdfDevice) || !complexProps[i].equals(BDdfDevice.deviceId) && !complexProps[i].equals(BDdfDevice.pingParameters)) && (!complexProps[i].getDefaultValue().getType().is(BComplex.TYPE) || !DdfFacets.isMgrInclude((BComplex)complex, (Property)complexProps[i]) || !BWbFieldEditor.makeFor((BObject)complex.get(complexProps[i])).getType().is(BPropertySheetFE.TYPE))) continue;
            mgrColumnProps.addAll((Object[])DdfMgrColumnUtil.getRecursive((BComplex)complex.get(complexProps[i]), new Property[]{complexProps[i]}));
        }
        return (MgrColumn[])mgrColumnProps.trim();
    }

    protected static MgrColumn.PropPath[] getRecursive(BComplex complex, Property[] propPathSoFar) {
        Array mgrColumnProps = new Array(MgrColumn.PropPath.class);
        Property[] childProps = complex.getFrozenPropertiesArray();
        for (int i = 0; i < childProps.length; ++i) {
            Array fullPath = new Array((Object[])propPathSoFar);
            fullPath.add((Object)childProps[i]);
            if ((childProps[i].getDefaultValue().getType().is(BSimple.TYPE) || childProps[i].getDefaultValue().getType().is(BStruct.TYPE) && !BWbFieldEditor.makeFor((BObject)childProps[i].getDefaultValue()).getType().is(BPropertySheetFE.TYPE)) && DdfFacets.isMgrInclude((BComplex)complex, (Property)childProps[i])) {
                mgrColumnProps.add((Object)new DdfMgrPropPath((Property[])fullPath.trim(), DdfMgrColumnUtil.getMgrColumnFlags(complex, childProps[i])));
                continue;
            }
            if (!childProps[i].getDefaultValue().getType().is(BComplex.TYPE) || !DdfFacets.isMgrInclude((BComplex)complex, (Property)childProps[i])) continue;
            mgrColumnProps.addAll((Object[])DdfMgrColumnUtil.getRecursive((BComplex)complex.get(childProps[i]), (Property[])fullPath.trim()));
        }
        return (MgrColumn.PropPath[])mgrColumnProps.trim();
    }

    static String toDotNotation(Property[] propPath) {
        String dotNotation = "";
        for (int i = 0; i < propPath.length; ++i) {
            if (dotNotation.length() > 0) {
                dotNotation = dotNotation + ".";
            }
            dotNotation = dotNotation + propPath[i].getName();
        }
        if (dotNotation.startsWith("proxyExt.")) {
            dotNotation = dotNotation.substring(9);
        }
        return dotNotation;
    }

    static String getMgrColumnName(Property[] props) {
        String mgrColumnName = props[props.length - 1].getDefaultDisplayName(null);
        String propPathInDotNotation = DdfMgrColumnUtil.toDotNotation(props);
        for (int i = 0; i < props.length; ++i) {
            Lexicon propLex = props[i].getDeclaringType().getModule().getLexicon();
            if (propLex == null) continue;
            mgrColumnName = propLex.get(propPathInDotNotation, mgrColumnName);
        }
        return mgrColumnName;
    }

    public static class DdfMgrProp
    extends MgrColumn.Prop {
        public final Property prop;

        public DdfMgrProp(Property prop, int flags) {
            super(prop, flags);
            this.prop = prop;
        }

        public Property getProp() {
            return this.prop;
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            return super.toEditor(rows, colIndex, null);
        }
    }

    public static class DdfMgrPropPath
    extends MgrColumn.PropPath {
        public final Property[] props;

        public DdfMgrPropPath(Property[] props, int flags) {
            super(DdfMgrColumnUtil.getMgrColumnName(props), props, flags);
            this.props = props;
        }

        public Property[] getPropPath() {
            return this.props;
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            return super.toEditor(rows, colIndex, null);
        }

        public Object get(Object row) {
            if (row instanceof BIDdfDiscoveryGroup) {
                return row.toString();
            }
            return super.get(row);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (row instanceof BIDdfDiscoveryGroup) {
                return row.toString();
            }
            return super.toDisplayString(row, value, cx);
        }
    }
}

