/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.ui;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.discover.BDdfDiscoveryJob;
import com.tridium.ddf.discover.BDdfPointDiscoveryLeaf;
import com.tridium.ddf.discover.BIDdfDeviceDiscoveryLeaf;
import com.tridium.ddf.discover.BIDdfDiscoveryGroup;
import com.tridium.ddf.discover.BIDdfDiscoveryHost;
import com.tridium.ddf.discover.BIDdfDiscoveryLeaf;
import com.tridium.ddf.discover.BIDdfDiscoveryObject;
import com.tridium.ddf.discover.BIDdfPointDiscoveryLeaf;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryJob;
import com.tridium.ddf.identify.BDdfDeviceId;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.point.BDdfProxyExt;
import com.tridium.ddf.ui.DdfMgrColumnUtil;
import com.tridium.ddf.ui.DdfMgrLearnUtil;
import com.tridium.ddf.ui.DdfMgrUtil;
import com.tridium.ddf.ui.DdfUiLexicon;
import com.tridium.ddf.ui.device.BDdfDeviceManager;
import com.tridium.ddf.ui.discover.BIDdfDiscoveryIcon;
import com.tridium.ddf.ui.point.BDdfPointManager;
import com.tridium.workbench.job.BJobBar;
import java.util.Hashtable;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.driver.point.BProxyExt;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class DdfMgrLearn
extends MgrLearn
implements IDdfFacetConst {
    private JobBarSubscriber jobBarSubscriber;
    public static final BImage deviceIcon = BImage.make((String)"module://icons/x16/device.png");
    public static final BImage pointGroupIcon = BImage.make((String)"module://icons/x16/pointFolder.png");
    public static final BImage deviceGroupIcon = BImage.make((String)"module://icons/x16/deviceFolder.png");
    public static final BImage numericElementIcon = BImage.make((String)"module://icons/x16/control/numericPoint.png");
    public static final BImage booleanElementIcon = BImage.make((String)"module://icons/x16/control/booleanPoint.png");
    public static final BImage enumElementIcon = BImage.make((String)"module://icons/x16/control/enumPoint.png");
    public static final BImage stringElementIcon = BImage.make((String)"module://icons/x16/control/stringPoint.png");
    public static final BImage numericElementIconRo = BImage.make((String)"module://icons/x16/statusNumeric.png");
    public static final BImage booleanElementIconRo = BImage.make((String)"module://icons/x16/statusBoolean.png");
    public static final BImage enumElementIconRo = BImage.make((String)"module://icons/x16/statusEnum.png");
    public static final BImage stringElementIconRo = BImage.make((String)"module://icons/x16/statusString.png");

    public DdfMgrLearn(BAbstractManager manager) {
        super(manager);
    }

    private String customizeJobBarNameBasedOnDriverName(BIDdfDiscoveryHost discoveryHost) {
        String driverName = discoveryHost.getType().getModule().getModuleName();
        if (driverName != null && driverName.length() > 0) {
            driverName = TextUtil.toFriendly((String)driverName);
            return driverName + ' ' + DdfUiLexicon.LEX.getText("Discovery");
        }
        return null;
    }

    private String getJobBarNameFromDriverLexicon(BIDdfDiscoveryHost discoveryHost) {
        Lexicon driverLexicon = discoveryHost.getType().getModule().getLexicon();
        String lexiconKeyForJobBarName = discoveryHost.getType().getTypeName() + ".discovery.jobBar.name";
        return driverLexicon.get(lexiconKeyForJobBarName);
    }

    private void customizeJobBarName() {
        BWidget jobBar = this.getJobBar();
        if (jobBar != null) {
            BIDdfDiscoveryHost discoveryHost = DdfMgrUtil.findDiscoveryHost(this.getManager());
            String jobBarName = this.getJobBarNameFromDriverLexicon(discoveryHost);
            if (jobBarName == null) {
                jobBarName = this.customizeJobBarNameBasedOnDriverName(discoveryHost);
            }
            this.updateJobBarName(jobBarName);
        }
    }

    void updateJobBarName(String jobBarName) {
        BLabel jobBarNameLabel;
        if (jobBarName != null && (jobBarNameLabel = this.getJobBarNameLabel()) != null) {
            if (!jobBarName.equals(jobBarNameLabel.getText())) {
                jobBarNameLabel.setText(jobBarName);
            }
            if (this.jobBarSubscriber == null) {
                this.jobBarSubscriber = new JobBarSubscriber(jobBarName);
                this.jobBarSubscriber.subscribe((BComponent)jobBarNameLabel);
            }
        }
    }

    public void setJob(BJob job) {
        super.setJob(job);
        if (job instanceof BDdfAutoDiscoveryJob) {
            this.customizeJobBarName();
        }
    }

    BLabel getJobBarNameLabel() {
        BValue gridValue2;
        BGridPane jobBarGridPane;
        Property[] gridWidgetProps;
        BWidget jobBarCenter;
        if (this.getJobBar() != null && this.getJobBar() instanceof BJobBar && (jobBarCenter = ((BJobBar)this.getJobBar()).getCenter()) instanceof BGridPane && (gridWidgetProps = (jobBarGridPane = (BGridPane)jobBarCenter).getDynamicPropertiesArray()).length > 2 && (gridValue2 = jobBarGridPane.get(gridWidgetProps[1])) instanceof BLabel) {
            return (BLabel)gridValue2;
        }
        return null;
    }

    protected MgrColumn[] makeColumns() {
        return DdfMgrLearnUtil.makeColumns(this.getManager());
    }

    public void toRow(Object discovery, MgrEditRow row) {
        if (discovery instanceof BIDdfDiscoveryLeaf) {
            if (this.getManager() instanceof BDdfDeviceManager) {
                this.deviceManagerToRow(discovery, row);
            } else if (this.getManager() instanceof BDdfPointManager) {
                this.pointManagerToRow(discovery, row);
            }
        }
    }

    public void jobComplete(BJob job) {
        if (job instanceof BDdfDiscoveryJob) {
            this.updateRoots(((BDdfDiscoveryJob)job).getRootDiscoveryObjects());
        }
    }

    public boolean isDepthExpandable(int depth) {
        return true;
    }

    public boolean hasChildren(Object discovery) {
        return discovery instanceof BIDdfDiscoveryGroup;
    }

    public boolean isExisting(Object discovery, BComponent component) {
        if (discovery == null || component == null) {
            return false;
        }
        if (discovery instanceof BIDdfDiscoveryLeaf) {
            if (this.getManager() instanceof BDdfDeviceManager && component instanceof BDdfDevice) {
                return this.isExistingDevice((BIDdfDiscoveryLeaf)discovery, (BDdfDevice)component);
            }
            if (this.getManager() instanceof BDdfPointManager && component instanceof BControlPoint) {
                return this.isExistingPoint((BIDdfDiscoveryLeaf)discovery, (BControlPoint)component);
            }
            return super.isExisting(discovery, component);
        }
        return super.isExisting(discovery, component);
    }

    public Object[] getChildren(Object discovery) {
        if (discovery instanceof BIDdfDiscoveryGroup) {
            BIDdfDiscoveryGroup discoveryGroup = (BIDdfDiscoveryGroup)discovery;
            Object[] discoveryChildren = discoveryGroup.getChildren(BIDdfDiscoveryObject.class);
            for (int i = 0; i < discoveryChildren.length; ++i) {
                if (!(discoveryChildren[i] instanceof BComponent)) continue;
                this.getManager().registerForComponentEvents((BComponent)discoveryChildren[i]);
            }
            return discoveryChildren;
        }
        return null;
    }

    public BImage getIcon(Object discovery) {
        if (discovery instanceof BIDdfDiscoveryIcon) {
            return ((BIDdfDiscoveryIcon)discovery).getDiscoveryIcon();
        }
        return this.getIconDefault(discovery);
    }

    public MgrTypeInfo[] toTypes(Object discovery) {
        return DdfMgrLearnUtil.toTypes(discovery);
    }

    public boolean isGroup(Object discovery) {
        return discovery instanceof BIDdfDiscoveryGroup;
    }

    protected void updateControlPointProps(DdfMgrColumnUtil.DdfMgrProp editDlgColProp, BIDdfPointDiscoveryLeaf discoveryPointLeaf, MgrEditRow row) {
        if (editDlgColProp.getProp().equals(BControlPoint.facets) && discoveryPointLeaf.getDiscoveryPointFacets() != null) {
            row.setCell((MgrColumn)editDlgColProp, (BValue)discoveryPointLeaf.getDiscoveryPointFacets());
        }
    }

    protected void updateControlPointProps(DdfMgrColumnUtil.DdfMgrPropPath editDlgColPropPath, BIDdfPointDiscoveryLeaf discoveryPointLeaf, MgrEditRow row) {
        Property[] colPropPath = editDlgColPropPath.getPropPath();
        if (colPropPath.length == 2 && colPropPath[0].equals(BControlPoint.proxyExt)) {
            if (colPropPath[1].equals(BProxyExt.deviceFacets) && discoveryPointLeaf.getDiscoveryDeviceFacets() != null) {
                row.setCell((MgrColumn)editDlgColPropPath, (BValue)discoveryPointLeaf.getDiscoveryDeviceFacets());
            }
            if (colPropPath[1].equals(BProxyExt.conversion) && discoveryPointLeaf.getDiscoveryConversion() != null) {
                row.setCell((MgrColumn)editDlgColPropPath, (BValue)discoveryPointLeaf.getDiscoveryConversion());
            }
            if (colPropPath[1].equals(BProxyExt.tuningPolicyName) && discoveryPointLeaf.getDiscoveryTuningPolicyName() != null) {
                row.setCell((MgrColumn)editDlgColPropPath, (BValue)BString.make((String)discoveryPointLeaf.getDiscoveryTuningPolicyName()));
            }
        }
    }

    protected void updateControlPointProps(MgrColumn editDlgCol, BIDdfPointDiscoveryLeaf discoveryPointLeaf, MgrEditRow row) {
        if (editDlgCol instanceof DdfMgrColumnUtil.DdfMgrProp) {
            this.updateControlPointProps((DdfMgrColumnUtil.DdfMgrProp)editDlgCol, discoveryPointLeaf, row);
        } else if (editDlgCol instanceof DdfMgrColumnUtil.DdfMgrPropPath) {
            this.updateControlPointProps((DdfMgrColumnUtil.DdfMgrPropPath)editDlgCol, discoveryPointLeaf, row);
        }
    }

    protected void updateControlPointProps(BIDdfPointDiscoveryLeaf discoveryPointLeaf, MgrEditRow row) {
        MgrColumn[] editDlgCols = row.getColumns();
        for (int i = 0; i < editDlgCols.length; ++i) {
            this.updateControlPointProps(editDlgCols[i], discoveryPointLeaf, row);
        }
    }

    protected void pointManagerToRow(Object discovery, MgrEditRow row) {
        BIDdfDiscoveryObject ddfDiscoveryObject = (BIDdfDiscoveryObject)discovery;
        Type readParametersType = this.getProxyExtReadParametersType(row);
        Type writeParametersType = this.getProxyExtWriteParametersType(row);
        Type pointIdType = this.getProxyExtPointIdType(row);
        Type discoveryObjectType = ddfDiscoveryObject.getType();
        if (readParametersType == discoveryObjectType) {
            this.updateDatabaseIdColumns(BDdfProxyExt.readParameters, discovery, row);
        } else if (writeParametersType == discoveryObjectType) {
            this.updateDatabaseIdColumns(BDdfProxyExt.writeParameters, discovery, row);
        } else if (pointIdType == discoveryObjectType) {
            this.updateDatabaseIdColumns(BDdfProxyExt.pointId, discovery, row);
        } else if (discoveryObjectType.is(BIDdfPointDiscoveryLeaf.TYPE)) {
            BIDdfPointDiscoveryLeaf pointLeaf = (BIDdfPointDiscoveryLeaf)discovery;
            this.updateDatabaseIdColumns(BDdfProxyExt.readParameters, pointLeaf, row);
            this.updateDatabaseIdColumns(BDdfProxyExt.writeParameters, pointLeaf, row);
            this.updateDatabaseIdColumns(BDdfProxyExt.pointId, pointLeaf, row);
            this.updateControlPointProps(pointLeaf, row);
        }
    }

    protected Type getProxyExtWriteParametersType(MgrEditRow row) {
        BComponent targetComponent = row.getTarget();
        if (targetComponent instanceof BControlPoint) {
            BControlPoint targetCp = (BControlPoint)targetComponent;
            if (targetCp.getProxyExt() instanceof BDdfProxyExt) {
                BDdfProxyExt targetProxyExt = (BDdfProxyExt)targetCp.getProxyExt();
                return targetProxyExt.getWriteParameters().getType();
            }
            return null;
        }
        return null;
    }

    protected Type getProxyExtReadParametersType(MgrEditRow row) {
        BComponent targetComponent = row.getTarget();
        if (targetComponent instanceof BControlPoint) {
            BControlPoint targetCp = (BControlPoint)targetComponent;
            if (targetCp.getProxyExt() instanceof BDdfProxyExt) {
                BDdfProxyExt targetProxyExt = (BDdfProxyExt)targetCp.getProxyExt();
                return targetProxyExt.getReadParameters().getType();
            }
            return null;
        }
        return null;
    }

    protected Type getProxyExtPointIdType(MgrEditRow row) {
        BComponent targetComponent = row.getTarget();
        if (targetComponent instanceof BControlPoint) {
            BControlPoint targetCp = (BControlPoint)targetComponent;
            if (targetCp.getProxyExt() instanceof BDdfProxyExt) {
                BDdfProxyExt targetProxyExt = (BDdfProxyExt)targetCp.getProxyExt();
                return targetProxyExt.getPointId().getType();
            }
            return null;
        }
        return null;
    }

    protected void updateDatabaseIdColumns(Property idProperty, Object discoverValue, MgrEditRow row) {
        MgrColumn[] disCols = this.getColumns();
        Hashtable<String, MgrColumn> disColsPropPathStrings = new Hashtable<String, MgrColumn>(disCols.length);
        for (int i = 0; i < disCols.length; ++i) {
            if (disCols[i] instanceof DdfMgrColumnUtil.DdfMgrPropPath) {
                disColsPropPathStrings.put(this.makePropPathHelperString((DdfMgrColumnUtil.DdfMgrPropPath)disCols[i], ""), disCols[i]);
                continue;
            }
            if (!(disCols[i] instanceof DdfMgrColumnUtil.DdfMgrProp)) continue;
            disColsPropPathStrings.put(idProperty.getName() + "." + ((DdfMgrColumnUtil.DdfMgrProp)disCols[i]).getProp().getName(), disCols[i]);
        }
        DdfMgrColumnUtil.DdfMgrPropPath[] databaseIdCols = this.getDatabaseColumnsForProp(idProperty.getName());
        for (int i = 0; i < databaseIdCols.length; ++i) {
            String dbColPropPathString = this.makePropPathHelperString(databaseIdCols[i], idProperty.getName());
            MgrColumn disCol = (MgrColumn)disColsPropPathStrings.get(dbColPropPathString);
            if (disCol == null || !databaseIdCols[i].isEditable()) continue;
            row.setCell((MgrColumn)databaseIdCols[i], (BValue)disCol.get(discoverValue));
        }
    }

    protected String makePropPathHelperString(DdfMgrColumnUtil.DdfMgrPropPath ddfMgrPropPath, String fromProp) {
        String helperString = fromProp;
        Property[] propPath = ddfMgrPropPath.getPropPath();
        boolean afterProp = fromProp.length() <= 0;
        for (int i = 0; i < propPath.length; ++i) {
            if (afterProp) {
                if (helperString.length() > 0) {
                    helperString = helperString + ".";
                }
                helperString = helperString + propPath[i].getName();
                continue;
            }
            if (!propPath[i].getName().equals(fromProp)) continue;
            afterProp = true;
        }
        return helperString;
    }

    protected DdfMgrColumnUtil.DdfMgrPropPath[] getDatabaseColumnsForProp(String propName) {
        Array databaseColumnsForProp = new Array(DdfMgrColumnUtil.DdfMgrPropPath.class);
        MgrColumn[] databaseColumns = this.getManager().getModel().getColumns();
        for (int i = 0; i < databaseColumns.length; ++i) {
            if (!(databaseColumns[i] instanceof DdfMgrColumnUtil.DdfMgrPropPath)) continue;
            Property[] dbColPropPath = ((DdfMgrColumnUtil.DdfMgrPropPath)databaseColumns[i]).getPropPath();
            for (int p = 0; p < dbColPropPath.length; ++p) {
                if (!dbColPropPath[p].getName().equals(propName)) continue;
                databaseColumnsForProp.add((Object)((DdfMgrColumnUtil.DdfMgrPropPath)databaseColumns[i]));
            }
        }
        return (DdfMgrColumnUtil.DdfMgrPropPath[])databaseColumnsForProp.trim();
    }

    protected void deviceManagerToRow(Object discovery, MgrEditRow row) {
        BIDdfDiscoveryLeaf leaf;
        BIDdfDiscoveryObject ddfDiscoveryObject = (BIDdfDiscoveryObject)discovery;
        Type deviceIdType = this.getDeviceIdType(row);
        Type pingParametersType = this.getPingParametersType(row);
        if (deviceIdType != BDdfIdParams.TYPE && ddfDiscoveryObject.getType().is(deviceIdType)) {
            this.updateDatabaseIdColumns(BDdfDevice.deviceId, discovery, row);
        }
        if (pingParametersType != BDdfIdParams.TYPE && ddfDiscoveryObject.getType().is(pingParametersType)) {
            this.updateDatabaseIdColumns(BDdfDevice.pingParameters, discovery, row);
        }
        if (ddfDiscoveryObject.getType().is(BIDdfDeviceDiscoveryLeaf.TYPE)) {
            this.updateDatabaseIdColumns(BDdfDevice.deviceId, discovery, row);
            this.updateDatabaseIdColumns(BDdfDevice.pingParameters, discovery, row);
            this.updateDatabaseIdColumns(BDdfDevice.communicator, discovery, row);
        }
        if (discovery instanceof BIDdfDiscoveryLeaf && (leaf = (BIDdfDiscoveryLeaf)discovery).getDiscoveryName() != null) {
            row.setDefaultName(leaf.getDiscoveryName());
        }
    }

    protected Type getDeviceIdType(MgrEditRow row) {
        BComponent targetComponent = row.getTarget();
        if (targetComponent instanceof BDdfDevice) {
            return ((BDdfDevice)targetComponent).getDeviceId().getType();
        }
        return null;
    }

    protected Type getPingParametersType(MgrEditRow row) {
        BComponent targetComponent = row.getTarget();
        if (targetComponent instanceof BDdfDevice) {
            return ((BDdfDevice)targetComponent).getPingParameters().getType();
        }
        return null;
    }

    public boolean isExistingDevice(BIDdfDiscoveryLeaf discoveryLeaf, BDdfDevice databaseDevice) {
        if (discoveryLeaf instanceof BIDdfDeviceDiscoveryLeaf) {
            BIDdfDeviceDiscoveryLeaf deviceDiscoveryLeaf = (BIDdfDeviceDiscoveryLeaf)discoveryLeaf;
            return deviceDiscoveryLeaf.getDeviceId().isExisting(databaseDevice.getDeviceId(), CONTEXT_DEVICE_MANAGER) && deviceDiscoveryLeaf.getPingParameters().isExisting(databaseDevice.getPingParameters(), CONTEXT_DEVICE_MANAGER);
        }
        if (discoveryLeaf instanceof BDdfDeviceId) {
            return ((BDdfDeviceId)discoveryLeaf).isExisting(databaseDevice.getDeviceId(), CONTEXT_DEVICE_MANAGER);
        }
        return false;
    }

    public boolean isExistingPoint(BIDdfDiscoveryLeaf discoveryLeaf, BControlPoint proxyPoint) {
        if (discoveryLeaf == null || proxyPoint == null) {
            return false;
        }
        if (proxyPoint.getProxyExt() instanceof BDdfProxyExt) {
            BDdfProxyExt dbProxyExt = (BDdfProxyExt)proxyPoint.getProxyExt();
            if (discoveryLeaf instanceof BDdfPointDiscoveryLeaf) {
                BDdfPointDiscoveryLeaf pointDiscoveryLeaf = (BDdfPointDiscoveryLeaf)discoveryLeaf;
                return pointDiscoveryLeaf.getPointId().isExisting(dbProxyExt.getPointId(), CONTEXT_POINT_MANAGER) && pointDiscoveryLeaf.getReadParameters().isExisting(dbProxyExt.getReadParameters(), CONTEXT_POINT_MANAGER) && pointDiscoveryLeaf.getWriteParameters().isExisting(dbProxyExt.getWriteParameters(), CONTEXT_POINT_MANAGER);
            }
            if (discoveryLeaf instanceof BDdfIdParams) {
                BDdfIdParams discoveryLeafId = (BDdfIdParams)discoveryLeaf;
                if (discoveryLeafId.isExisting(dbProxyExt.getPointId(), CONTEXT_POINT_MANAGER)) {
                    return true;
                }
                if (discoveryLeafId.isExisting(dbProxyExt.getReadParameters(), CONTEXT_POINT_MANAGER)) {
                    return true;
                }
                return discoveryLeafId.isExisting(dbProxyExt.getWriteParameters(), CONTEXT_POINT_MANAGER);
            }
            return false;
        }
        return false;
    }

    protected BImage getPointIconDefault(Object discovery) {
        if (discovery instanceof BIDdfDiscoveryLeaf) {
            return this.getPointIconDefault((BIDdfDiscoveryLeaf)discovery);
        }
        if (discovery instanceof BIDdfDiscoveryGroup) {
            return pointGroupIcon;
        }
        return stringElementIconRo;
    }

    protected BImage getPointIconDefault(BIDdfDiscoveryLeaf discovery) {
        TypeInfo[] databaseTypes = discovery.getValidDatabaseTypes();
        if (databaseTypes != null && databaseTypes.length > 0) {
            Type defaultType = databaseTypes[0].getTypeSpec().getResolvedType();
            if (defaultType != null) {
                if (defaultType.is(BNumericWritable.TYPE)) {
                    return numericElementIcon;
                }
                if (defaultType.is(BNumericPoint.TYPE)) {
                    return numericElementIconRo;
                }
                if (defaultType.is(BBooleanWritable.TYPE)) {
                    return booleanElementIcon;
                }
                if (defaultType.is(BBooleanPoint.TYPE)) {
                    return booleanElementIconRo;
                }
                if (defaultType.is(BEnumWritable.TYPE)) {
                    return enumElementIcon;
                }
                if (defaultType.is(BEnumPoint.TYPE)) {
                    return enumElementIconRo;
                }
                if (defaultType.is(BStringWritable.TYPE)) {
                    return stringElementIcon;
                }
                if (defaultType.is(BStringPoint.TYPE)) {
                    return stringElementIconRo;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    protected BImage getDeviceIconDefault(Object discovery) {
        if (discovery instanceof BIDdfDiscoveryGroup) {
            return deviceGroupIcon;
        }
        return deviceIcon;
    }

    protected BImage getIconDefault(Object discovery) {
        if (this.getManager() instanceof BDdfDeviceManager) {
            return this.getDeviceIconDefault(discovery);
        }
        if (this.getManager() instanceof BDdfPointManager) {
            return this.getPointIconDefault(discovery);
        }
        return null;
    }

    class JobBarSubscriber
    extends Subscriber {
        String jobBarName;

        JobBarSubscriber(String jobBarName) {
            this.jobBarName = jobBarName;
        }

        public void event(BComponentEvent event) {
            DdfMgrLearn.this.updateJobBarName(this.jobBarName);
        }
    }
}

