/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.ui.point;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.discover.BDdfPointDiscoveryLeaf;
import com.tridium.ddf.discover.BIDdfDiscoveryLeaf;
import com.tridium.ddf.discover.BIDdfPointDiscoveryLeaf;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.point.BDdfProxyExt;
import com.tridium.ddf.ui.DdfMgrControllerUtil;
import com.tridium.ddf.ui.point.BDdfPointManager;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class DdfPointController
extends PointController
implements IDdfFacetConst {
    public DdfPointController(BDdfPointManager manager) {
        super((BPointManager)manager);
    }

    public MgrEdit makeEdit(String label) {
        return new DdfMgrPointEdit(this.getManager(), label);
    }

    public CommandArtifact doDiscover(Context cx) throws Exception {
        return DdfMgrControllerUtil.doDiscover(this.getManager(), cx);
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return DdfMgrControllerUtil.makeCommands(super.makeCommands(), (BDdfPointManager)this.getManager());
    }

    public void updateCommands() {
        DdfMgrControllerUtil.updateCommands(this.getManager());
        super.updateCommands();
    }

    public BWidget makeActionBar() {
        MgrController.IMgrCommand[] mgrCommands = this.getCommands();
        Array firstRow = new Array(MgrController.IMgrCommand.class);
        Array secondRow = new Array(MgrController.IMgrCommand.class);
        for (int i = 0; i < mgrCommands.length; ++i) {
            if (mgrCommands[i] instanceof DdfMgrControllerUtil.DdfPointMgrAgentCommand) {
                secondRow.add((Object)mgrCommands[i]);
                continue;
            }
            firstRow.add((Object)mgrCommands[i]);
        }
        if (secondRow.size() < 2) {
            return super.makeActionBar();
        }
        MgrController.IMgrCommand[] row1Commands = (MgrController.IMgrCommand[])firstRow.trim();
        MgrController.IMgrCommand[] row2Commands = (MgrController.IMgrCommand[])secondRow.trim();
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.makeActionPane(row1Commands));
        pane.setCenter((BWidget)new BBorderPane(this.makeActionPane(row2Commands)));
        return pane;
    }

    public static void initializeControlPoint(Object discovery, BControlPoint newCtPt) {
        if (discovery instanceof BDdfPointDiscoveryLeaf) {
            BDdfPointDiscoveryLeaf discoveryLeaf = (BDdfPointDiscoveryLeaf)discovery;
            BDdfProxyExt ddfProxyExt = (BDdfProxyExt)newCtPt.getProxyExt();
            ddfProxyExt.setReadParameters((BDdfIdParams)discoveryLeaf.getReadParameters().newCopy());
            ddfProxyExt.setWriteParameters((BDdfIdParams)discoveryLeaf.getWriteParameters().newCopy());
            ddfProxyExt.setPointId((BDdfIdParams)discoveryLeaf.getPointId().newCopy());
        }
        if (discovery instanceof BIDdfPointDiscoveryLeaf) {
            BIDdfPointDiscoveryLeaf ptDis = (BIDdfPointDiscoveryLeaf)discovery;
            if (ptDis.getDiscoveryPointFacets() != null) {
                newCtPt.setFacets(ptDis.getDiscoveryPointFacets());
            }
            BProxyExt proxy = (BProxyExt)newCtPt.getProxyExt();
            if (ptDis.getDiscoveryDeviceFacets() != null) {
                proxy.setDeviceFacets(ptDis.getDiscoveryDeviceFacets());
            }
            if (ptDis.getDiscoveryConversion() != null) {
                proxy.setConversion(ptDis.getDiscoveryConversion());
            }
            if (ptDis.getDiscoveryTuningPolicyName() != null) {
                proxy.setTuningPolicyName(ptDis.getDiscoveryTuningPolicyName());
            }
        }
    }

    class DdfMgrPointEdit
    extends MgrEdit {
        public DdfMgrPointEdit(BAbstractManager manager, String title) {
            super(manager, title);
        }

        public MgrEditRow addRow(Object discovery, MgrTypeInfo[] types) throws Exception {
            BIDdfDiscoveryLeaf ptDis;
            BControlPoint newCtPt = (BControlPoint)this.getManager().getModel().newInstance(types[0]);
            DdfPointController.initializeControlPoint(discovery, newCtPt);
            MgrEditRow newMgrRow = this.addRow(this.makeRow((BComponent)newCtPt, discovery, types));
            if (discovery instanceof BIDdfDiscoveryLeaf && (ptDis = (BIDdfDiscoveryLeaf)discovery).getDiscoveryName() != null) {
                newMgrRow.setDefaultName(ptDis.getDiscoveryName());
            }
            return newMgrRow;
        }

        protected MgrEditRow makeRow(BComponent target, Object discovery, MgrTypeInfo[] types) throws Exception {
            return new DdfMgrEditRow(target, discovery, types);
        }
    }

    class DdfMgrEditRow
    extends MgrEditRow {
        public DdfMgrEditRow(BComponent target, Object discovery, MgrTypeInfo[] types) {
            super(target, discovery, types);
        }

        public void setType(MgrTypeInfo type) throws Exception {
            String nameBeforeTypeChange = this.getName();
            super.setType(type);
            DdfPointController.initializeControlPoint(this.getDiscovery(), (BControlPoint)this.getTarget());
            this.loadCells();
            if (this.getDiscovery() != null) {
                this.getLearn().toRow(this.getDiscovery(), (MgrEditRow)this);
            }
            this.setName(this.getEdit().getUniqueName((MgrEditRow)this, nameBeforeTypeChange));
        }
    }
}

