/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import com.tridium.chart.ChartUtil;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.Series;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="displayValueLabels", type="boolean", defaultValue="false"), @NiagaraProperty(name="barWidthPercent", type="int", defaultValue="75"), @NiagaraProperty(name="pen", type="BPen", defaultValue="BPen.make(1)"), @NiagaraProperty(name="stroke", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="font", type="BFont", defaultValue="BFont.DEFAULT")})
public class BAggregationChart
extends BChart {
    @Generated
    public static final Property displayValueLabels = BAggregationChart.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property barWidthPercent = BAggregationChart.newProperty((int)0, (int)75, null);
    @Generated
    public static final Property pen = BAggregationChart.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    @Generated
    public static final Property stroke = BAggregationChart.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Property font = BAggregationChart.newProperty((int)0, (BValue)BFont.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAggregationChart.class);
    private Series[] seriesArray = null;
    private Series series = null;
    private double barWidth;
    private double maxVal;
    private double minVal;

    @Generated
    public boolean getDisplayValueLabels() {
        return this.getBoolean(displayValueLabels);
    }

    @Generated
    public void setDisplayValueLabels(boolean v) {
        this.setBoolean(displayValueLabels, v, null);
    }

    @Generated
    public int getBarWidthPercent() {
        return this.getInt(barWidthPercent);
    }

    @Generated
    public void setBarWidthPercent(int v) {
        this.setInt(barWidthPercent, v, null);
    }

    @Generated
    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    @Generated
    public void setPen(BPen v) {
        this.set(pen, (BValue)v, null);
    }

    @Generated
    public BBrush getStroke() {
        return (BBrush)this.get(stroke);
    }

    @Generated
    public void setStroke(BBrush v) {
        this.set(stroke, (BValue)v, null);
    }

    @Generated
    public BFont getFont() {
        return (BFont)this.get(font);
    }

    @Generated
    public void setFont(BFont v) {
        this.set(font, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAggregationChart() {
    }

    public BAggregationChart(ChartModel model) {
        super(model);
    }

    public double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public void doLayout(BWidget[] kids) {
        ChartModel model;
        if (this.seriesArray == null || this.seriesArray.length == 0) {
            this.seriesArray = this.getModel().getAllSeries();
        }
        if ((model = this.getModel()).getSpecCount() == 0) {
            return;
        }
        this.series = this.seriesArray[0];
        BAxis xAxis = model.getSpec(0).getXAxis();
        xAxis.setMinMargin(5.0);
        xAxis.setMaxMargin(5.0);
        this.barWidth = xAxis.getFullLength() / (double)this.series.getRowCount();
        double minSpacing = Double.MAX_VALUE;
        double prevKeyVal = Double.NEGATIVE_INFINITY;
        if (this.series.getRowCount() > 1) {
            for (int row = 0; row < this.series.getRowCount(); ++row) {
                if (this.series.getValue(row, 1) == null) continue;
                double curKeyVal = xAxis.toDisplaySpace(this.series.getValue(row, 0));
                if (curKeyVal - prevKeyVal < minSpacing) {
                    minSpacing = curKeyVal - prevKeyVal;
                }
                prevKeyVal = curKeyVal;
            }
            if (minSpacing < this.barWidth) {
                this.barWidth = minSpacing;
            }
        } else {
            this.barWidth = this.getWidth();
        }
        double margin = this.barWidth / 2.0;
        this.barWidth = this.barWidth * 2.0 / 3.0;
        xAxis.setMinMargin(margin);
        xAxis.setMaxMargin(margin);
    }

    public void doPaint(Graphics g) {
        int roundValue = 2;
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        if (specCount == 0) {
            return;
        }
        this.maxVal = Double.MIN_VALUE;
        this.minVal = Double.MAX_VALUE;
        for (int row = 0; row < this.series.getRowCount(); ++row) {
            BINumeric number = (BINumeric)this.series.getValue(row, 1);
            double d = number.getNumeric();
            if ((d = this.round(d, roundValue)) > this.maxVal) {
                this.maxVal = d;
            }
            if (!(d < this.minVal)) continue;
            this.minVal = d;
        }
        if (this.maxVal - this.minVal == 0.0) {
            double inc = Math.abs(this.maxVal) * 0.05;
            if (this.maxVal > 0.0) {
                this.maxVal += inc;
                this.minVal -= inc;
            } else {
                this.maxVal -= inc;
                this.minVal += inc;
            }
        }
        BAxis yAxis = model.getSpec(0).getYAxis();
        yAxis.setAxisMax((Object)BDouble.make((double)this.maxVal));
        yAxis.setAxisMin((Object)BDouble.make((double)this.minVal));
        yAxis.setShowSwatches(false);
        yAxis.setMaxAuto(false);
        yAxis.setMinAuto(false);
        double zeroLoc = yAxis.toDisplaySpace(yAxis.getAxisMin());
        double maxLoc = yAxis.toDisplaySpace(yAxis.getAxisMax());
        BAxis xAxis = model.getSpec(0).getXAxis();
        for (int row = 0; row < this.series.getRowCount(); ++row) {
            double loc = this.series.getRowCount() == 1 ? this.getWidth() / 2.0 : xAxis.toDisplaySpace(this.series.getValue(row, 0));
            double bar = loc - this.barWidth / 2.0;
            BPen pen = this.series.getPen();
            g.setPen(pen == null ? BPen.DEFAULT : pen);
            BINumeric number = (BINumeric)this.series.getValue(row, 1);
            double d = number.getNumeric();
            d = this.round(d, roundValue);
            double numerator = this.maxVal - d;
            double denominator = this.maxVal - this.minVal;
            double percent = numerator / denominator;
            double y = (zeroLoc - maxLoc) * percent + maxLoc;
            g.setBrush(ChartUtil.makeGradient((BBrush)this.series.getBrush()));
            g.setBrush(this.series.getBrush());
            g.fillRect(bar, y, this.barWidth, zeroLoc);
            g.setBrush(this.getStroke());
            g.strokeRect(bar, y, this.barWidth, zeroLoc);
        }
    }
}

