/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui.chart;

import com.tridiumx.analytics.ui.chart.BHoursAxis;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChart;
import javax.baja.chart.BContinuousAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
public class BLoadDurationChart
extends BChart {
    @Generated
    public static final Type TYPE = Sys.loadType(BLoadDurationChart.class);
    BContinuousAxis x = new BHoursAxis(this);
    private BPen defaultPen = BPen.make((double)1.0);
    double maxValue;
    double minValue;
    double minDuration;
    double maxDuration;
    double interval;
    Array<Double> valueArray;
    Array<Double> durationArray;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLoadDurationChart() {
        this.setModel((ChartModel)new Model());
    }

    public void doLayout(BWidget[] children) {
        super.doLayout(children);
        if (this.getModel().getSpecCount() == 0) {
            return;
        }
        ChartModel model = this.getModel();
        for (int i = 0; i < model.getSpecCount(); ++i) {
            ChartSpec spec = model.getSpec(i);
            this.processSeries(spec.getSeries());
            spec.getYAxis().setAxisMax((Object)BDouble.make((double)this.maxValue));
            spec.getYAxis().setAxisMin((Object)BDouble.make((double)this.minValue));
            spec.getYAxis().setMaxAuto(false);
            spec.getYAxis().setMinAuto(false);
            spec.getYAxis().setShowSwatches(false);
            spec.getXAxis().setAxisMax((Object)BDouble.make((double)this.maxDuration));
            spec.getXAxis().setAxisMin((Object)BDouble.make((double)this.minDuration));
            spec.getXAxis().setMaxAuto(false);
            spec.getXAxis().setMinAuto(false);
            spec.getXAxis().setShowSwatches(false);
        }
    }

    public void doPaint(Graphics g) {
        if (this.getModel().getSpecCount() == 0) {
            return;
        }
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        for (int i = 0; i < specCount; ++i) {
            ChartSpec spec = model.getSpec(i);
            Series series = spec.getSeries();
            if (series.getRowCount() <= 1) {
                return;
            }
            g.setBrush(series.getBrush());
            double lastX = Double.NaN;
            double lastY = Double.NaN;
            BPen pen = series.getPen();
            if (pen == null) {
                pen = this.defaultPen;
            }
            g.setPen(pen);
            this.maxValue = ((BDouble)spec.getYAxis().getAxisMax()).getDouble();
            this.minValue = ((BDouble)spec.getYAxis().getAxisMin()).getDouble();
            this.maxDuration = ((BDouble)spec.getXAxis().getAxisMax()).getDouble();
            this.minDuration = ((BDouble)spec.getXAxis().getAxisMin()).getDouble();
            BAxis yaxis = spec.getYAxis();
            double zerolocy = yaxis.toDisplaySpace(yaxis.getAxisMin());
            double maxlocy = yaxis.toDisplaySpace(yaxis.getAxisMax());
            double height = zerolocy - maxlocy;
            BAxis xaxis = spec.getXAxis();
            double zerolocx = xaxis.toDisplaySpace(xaxis.getAxisMin());
            double maxlocx = xaxis.toDisplaySpace(xaxis.getAxisMax());
            double width = maxlocx - zerolocx;
            for (int row = 0; row < this.valueArray.size(); ++row) {
                double duration = (Double)this.durationArray.get(row);
                double value = (Double)this.valueArray.get(row);
                double x = width * ((duration - this.minDuration) / (this.maxDuration - this.minDuration)) + zerolocx;
                double y = height * ((this.maxValue - value) / (this.maxValue - this.minValue)) + maxlocy;
                g.strokeLine(lastX, lastY, x, y);
                lastX = x;
                lastY = y;
            }
        }
    }

    private void processSeries(Series series) {
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.MIN_VALUE;
        this.minDuration = Double.MAX_VALUE;
        this.maxDuration = Double.MIN_VALUE;
        this.valueArray = new Array(Double.class);
        this.durationArray = new Array(Double.class);
        this.interval = -1.0;
        int lastValidIndex = Integer.MIN_VALUE;
        int rowCount = series.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            BAbsTime time = (BAbsTime)series.getValue(i, 0);
            BDouble value = (BDouble)series.getValue(i, 1);
            if (value.getDouble() > this.maxValue) {
                this.maxValue = value.getDouble();
            }
            if (value.getDouble() < this.minValue) {
                this.minValue = value.getDouble();
            }
            if (this.interval != -1.0) continue;
            if (lastValidIndex != i - 1) {
                lastValidIndex = i;
                continue;
            }
            BAbsTime lastTime = (BAbsTime)series.getValue(lastValidIndex, 0);
            this.interval = (double)(time.getMillis() - lastTime.getMillis()) / 3600000.0;
        }
        double deltaValue = (this.maxValue - this.minValue) / (double)rowCount;
        if (deltaValue <= 0.0) {
            return;
        }
        for (int k = 0; k < rowCount; ++k) {
            this.valueArray.add((Object)(this.minValue + (double)k * deltaValue));
            this.durationArray.add((Object)0.0);
        }
        this.valueArray.add((Object)this.maxValue);
        this.durationArray.add((Object)0.0);
        for (int j = 0; j < rowCount; ++j) {
            BDouble value = (BDouble)series.getValue(j, 1);
            double position = (value.getDouble() - this.minValue) / deltaValue;
            position = Math.floor(position);
            int k = 0;
            while ((double)k < position) {
                double currentValue = (Double)this.durationArray.get(k);
                double newValue = currentValue + this.interval;
                if (newValue > this.maxDuration) {
                    this.maxDuration = newValue;
                }
                if (newValue < this.minDuration) {
                    this.minDuration = newValue;
                }
                this.durationArray.set(k, (Object)newValue);
                ++k;
            }
        }
        this.minDuration = 0.0;
    }

    class Model
    extends BoundChartModel {
        Model() {
        }

        public synchronized void doSyncBindings() {
            super.doSyncBindings();
            if (this.getSpecCount() == 0) {
                return;
            }
            for (int i = 0; i < this.getSpecCount(); ++i) {
                ChartSpec spec = this.getSpec(i);
                BLoadDurationChart.this.processSeries(spec.getSeries());
                spec.getYAxis().setAxisMax((Object)BDouble.make((double)BLoadDurationChart.this.maxValue));
                spec.getYAxis().setAxisMin((Object)BDouble.make((double)BLoadDurationChart.this.minValue));
                spec.getYAxis().setMaxAuto(false);
                spec.getYAxis().setMinAuto(false);
                spec.getYAxis().setShowSwatches(false);
                spec.getXAxis().setAxisMax((Object)BDouble.make((double)BLoadDurationChart.this.maxDuration));
                spec.getXAxis().setAxisMin((Object)BDouble.make((double)BLoadDurationChart.this.minDuration));
                spec.getXAxis().setMaxAuto(false);
                spec.getXAxis().setMinAuto(false);
                spec.getXAxis().setShowSwatches(false);
            }
        }

        public BAxis findAxis(BAxis axis) {
            if (axis.getDimension().equals((Object)BAxisDimension.x)) {
                return BLoadDurationChart.this.x;
            }
            return super.findAxis(axis);
        }
    }
}

