/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverAC256.job;

import com.tridium.andoverAC256.BAndoverDevice;
import com.tridium.andoverAC256.datatypes.BAndoverPointDiscoveryConfig;
import com.tridium.andoverAC256.job.BAndoverDiscoveryPoint;
import com.tridium.andoverAC256.messages.AndoverGenericRequest;
import com.tridium.andoverAC256.messages.AndoverGetFlagPointsResponse;
import com.tridium.andoverAC256.messages.AndoverGetIOPointsResponse;
import com.tridium.andoverAC256.messages.AndoverGetSystemTablePointsResponse;
import com.tridium.andoverAC256.messages.AndoverMessageConst;
import com.tridium.andoverAC256.messages.AndoverStatusResponse;
import com.tridium.andoverAC256.messages.AndoverStringResponse;
import com.tridium.basicdriver.message.Message;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAndoverDiscoverPointsJob
extends BJob
implements AndoverMessageConst,
Runnable {
    @Generated
    public static final Type TYPE = Sys.loadType(BAndoverDiscoverPointsJob.class);
    private BAndoverDevice device;
    private BAndoverPointDiscoveryConfig config;
    private int domain = 0;
    private int numberIOUs;
    private int numberLCUs;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAndoverDiscoverPointsJob() {
    }

    public BAndoverDiscoverPointsJob(BAndoverDevice device, BAndoverPointDiscoveryConfig config) {
        this.device = device;
        this.config = config;
    }

    public void doRun(Context cx) {
        this.device.andoverNetwork().dispatch(this);
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
    }

    @Override
    public void run() {
        try {
            int i;
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru AndoverDevice.submitPointDiscoveryJob()");
            }
            if (!this.config.learnAnything()) {
                this.log().message("not configured to learn anything");
                this.progress(100);
                this.success();
                return;
            }
            int progressWeight = this.config.progressWeight();
            int progress = 0;
            this.domain = 0;
            if (this.device.getSupportsDomainKeyword()) {
                this.domain = this.setDomain(0);
            }
            if (this.domain != 0) {
                return;
            }
            this.learnSize();
            if (this.config.getSvPoints()) {
                if (!this.isAlive()) {
                    return;
                }
                this.log().message("Learning SV Points, domain 0");
                this.getSystemTablePoints("SV");
                this.progress(progress++ / progressWeight * 100);
            }
            if (this.config.getSaPoints()) {
                if (!this.isAlive()) {
                    return;
                }
                this.log().message("Learning SA Points, domain 0");
                this.getSystemTablePoints("SA");
                this.progress(progress++ / progressWeight * 100);
            }
            if (this.config.getSxPoints()) {
                if (!this.isAlive()) {
                    return;
                }
                this.log().message("Learning SX Points, domain 0");
                this.getSystemTablePoints("SX");
                this.progress(progress++ / progressWeight * 100);
            }
            if (this.config.learnFlags()) {
                if (!this.isAlive()) {
                    return;
                }
                this.log().message("Learning SF Points, domain 0");
                this.getFlagPoints(this.config.getUserFlagPoints(), this.config.getSystemFlagPoints());
                this.progress(progress++ / progressWeight * 100);
            }
            if (this.config.getIou().learnAnything()) {
                int iouStart = this.config.getIou().getStartAddress();
                int iouStop = this.config.getIou().getStopAddress();
                for (i = iouStart; i < iouStop + 1; ++i) {
                    if (!this.config.getIou().getIouPoints()) continue;
                    if (!this.isAlive()) {
                        return;
                    }
                    this.log().message("Learning IOU " + i + " Points, domain 0");
                    this.getIoTablePoints(Integer.toString(i));
                    this.progress(progress++ / progressWeight * 100);
                }
            }
            if (this.config.getLcu().learnAnything()) {
                int lcuStart = this.config.getLcu().getStartAddress();
                int lcuStop = this.config.getLcu().getStopAddress();
                for (i = lcuStart; i < lcuStop + 1; ++i) {
                    this.domain = this.setDomain(i);
                    if (this.domain != i) {
                        this.log().message("Could not set to domain " + i + ", no points learned");
                        this.progress(progress++ / progressWeight * 100);
                        continue;
                    }
                    if (this.config.getLcu().getSvPoints()) {
                        if (!this.isAlive()) {
                            return;
                        }
                        this.log().message("Learning SV Points, domain " + i);
                        this.getSystemTablePoints("SV");
                        this.progress(progress++ / progressWeight * 100);
                    }
                    if (this.config.getLcu().getFlagPoints()) {
                        if (!this.isAlive()) {
                            return;
                        }
                        this.log().message("Learning SF Points, domain " + i);
                        this.getFlagPoints(true, false);
                        this.progress(progress++ / progressWeight * 100);
                    }
                    if (!this.config.getLcu().getIoPoints()) continue;
                    if (!this.isAlive()) {
                        return;
                    }
                    this.log().message("Learning IO Points, domain " + i);
                    this.getIoTablePoints("1");
                    this.progress(progress++ / progressWeight * 100);
                }
                this.domain = this.setDomain(0);
            }
            this.progress(100);
            this.success();
        }
        catch (Throwable e) {
            this.failed(e);
        }
    }

    private void getSystemTablePoints(String fromTable) {
        this.log().message("Learning " + fromTable + ", domain " + this.domain + "...");
        AndoverGenericRequest aReq = new AndoverGenericRequest("P " + fromTable + "\n", 10);
        AndoverGetSystemTablePointsResponse svRsp = (AndoverGetSystemTablePointsResponse)this.device.andoverNetwork().getComm().transmit((Message)aReq, BRelTime.makeSeconds((int)10), 0);
        if (svRsp != null && !svRsp.isError()) {
            svRsp.decodeMessage();
            this.log().message("found " + svRsp.getNumberPointsReturned() + " points in " + fromTable);
            for (int i = 0; i < svRsp.getNumberPointsReturned(); ++i) {
                BAndoverDiscoveryPoint newPoint = new BAndoverDiscoveryPoint(svRsp.getName(i), svRsp.getValue(i), fromTable + " DOM " + Integer.toString(this.domain));
                this.add(null, (BValue)newPoint);
            }
        }
    }

    private void getIoTablePoints(String fromTable) {
        String origin = "";
        origin = this.domain == 0 ? "IOU " + fromTable : "LCU IO";
        this.log().message("Learning " + origin + ", domain " + this.domain + "...");
        AndoverGenericRequest aReq = new AndoverGenericRequest("P " + fromTable + "\n", 9);
        AndoverGetIOPointsResponse svRsp = (AndoverGetIOPointsResponse)this.device.andoverNetwork().getComm().transmit((Message)aReq, BRelTime.makeSeconds((int)10), 0);
        if (svRsp != null && !svRsp.isError()) {
            svRsp.decodeMessage();
            this.log().message("found " + svRsp.getNumberPointsReturned() + " points in " + fromTable);
            for (int i = 0; i < svRsp.getNumberPointsReturned(); ++i) {
                BAndoverDiscoveryPoint newPoint = new BAndoverDiscoveryPoint(svRsp.getName(i), svRsp.getValue(i), origin + " DOM " + Integer.toString(this.domain), svRsp.getPointNotes(i));
                this.add(null, (BValue)newPoint);
            }
        }
    }

    private void getFlagPoints(boolean userFlags, boolean systemFlags) {
        if (userFlags & systemFlags) {
            this.log().message("Learning System AND User Defined Flags, domain " + this.domain + "...");
        } else if (userFlags) {
            this.log().message("Learning User Defined Flags, domain " + this.domain + "...");
        } else if (systemFlags) {
            this.log().message("Learning System Flags, domain " + this.domain + "...");
        } else {
            return;
        }
        AndoverGenericRequest aReq = new AndoverGenericRequest("P SF\n", 11);
        AndoverGetFlagPointsResponse svRsp = (AndoverGetFlagPointsResponse)this.device.andoverNetwork().getComm().transmit((Message)aReq, BRelTime.makeSeconds((int)10), 0);
        if (svRsp != null && !svRsp.isError()) {
            svRsp.decodeMessage(userFlags, systemFlags);
            this.log().message("found " + svRsp.getNumberPointsReturned() + " points in SF table");
            for (int i = 0; i < svRsp.getNumberPointsReturned(); ++i) {
                BAndoverDiscoveryPoint newPoint = new BAndoverDiscoveryPoint(svRsp.getName(i), svRsp.getValue(i), "SF DOM " + Integer.toString(this.domain));
                this.add(null, (BValue)newPoint);
            }
        }
    }

    private int setDomain(int domain) {
        if (!this.device.getSupportsDomainKeyword()) {
            return 0;
        }
        try {
            AndoverGenericRequest domainReq = new AndoverGenericRequest("DOM " + domain + "\n", 12);
            AndoverStringResponse domainRsp = (AndoverStringResponse)this.device.andoverNetwork().getComm().transmit((Message)domainReq, BRelTime.makeSeconds((int)10), 0);
            if (domainRsp == null) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            if (domainRsp.isError()) {
                this.log().message("    ERROR: could not set to domain " + domain);
                return -1;
            }
            this.device.setCurrentDomain(domainRsp.getDomain());
            return domainRsp.getDomain();
        }
        catch (Exception e) {
            this.log().message("ERROR setting domain to " + domain + ": " + e);
            return -1;
        }
    }

    private void learnSize() {
        this.log().message("Learning about number of IOUs and LCUs configured in Andover panel");
        AndoverStatusResponse rsp = null;
        AndoverGenericRequest req = new AndoverGenericRequest("P STATUS\n", 1);
        rsp = (AndoverStatusResponse)this.device.andoverNetwork().getComm().transmit((Message)req, BRelTime.makeSeconds((int)10), 0);
        if (rsp == null || rsp.exceptionCode != 0) {
            this.log().failed("Job Failed, could not get STATUS message from Andover panel");
            this.doCancel(null);
            this.complete(BJobState.failed);
            return;
        }
        this.numberIOUs = rsp.getNumberIOUs();
        this.numberLCUs = rsp.getNumberLCUs();
        this.config.getIou().setStopAddress(this.numberIOUs);
        this.config.getLcu().setStopAddress(this.numberLCUs);
        if (this.numberIOUs == 0) {
            this.config.setFlags((Slot)BAndoverPointDiscoveryConfig.iou, this.config.getFlags((Slot)BAndoverPointDiscoveryConfig.iou) | 1);
        }
        if (this.numberLCUs == 0) {
            this.config.setFlags((Slot)BAndoverPointDiscoveryConfig.lcu, this.config.getFlags((Slot)BAndoverPointDiscoveryConfig.lcu) | 1);
        }
    }
}

